/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import tingeltangel.core.Repository;
import tingeltangel.core.Translator;
import tingeltangel.core.Tupel;
import tingeltangel.tools.Callback;
import tingeltangel.tools.FileEnvironment;

public class IDChooser
extends JDialog {
    private final LinkedList<Tupel<Integer, String>> idList = new LinkedList();
    private MyListModel model = new MyListModel();
    private Callback<Integer> callback;
    private JRadioButton anyID;
    private JButton button;
    private ButtonGroup buttonGroup1;
    private JRadioButton freeID;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JList list;
    private JRadioButton niceID;

    public IDChooser(Frame parent, Callback<Integer> callback) {
        super(parent, false);
        this.initComponents();
        this.callback = callback;
        this.list.setModel(this.model);
        this.niceIDActionPerformed(null);
        this.setVisible(true);
    }

    public IDChooser(Dialog parent, Callback<Integer> callback) {
        super(parent, false);
        this.initComponents();
        this.callback = callback;
        this.list.setModel(this.model);
        this.niceIDActionPerformed(null);
        this.setVisible(true);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.niceID = new JRadioButton();
        this.freeID = new JRadioButton();
        this.anyID = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.list = new JList();
        this.button = new JButton();
        this.setDefaultCloseOperation(2);
        this.buttonGroup1.add(this.niceID);
        this.niceID.setSelected(true);
        this.niceID.setText("empfohlene & freie MID (empfohlen)");
        this.niceID.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IDChooser.this.niceIDActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.freeID);
        this.freeID.setText("freie MID");
        this.freeID.setToolTipText("");
        this.freeID.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IDChooser.this.freeIDActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.anyID);
        this.anyID.setText("beliebige MID");
        this.anyID.setToolTipText("");
        this.anyID.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IDChooser.this.anyIDActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("Tahoma", 1, 14));
        this.jLabel1.setText("Bitte w\u00e4hle eine Option aus");
        this.jLabel1.setToolTipText("");
        this.list.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.list);
        this.button.setText("OK");
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IDChooser.this.buttonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.freeID).addComponent(this.niceID).addComponent(this.anyID)))).addGap(0, 171, Short.MAX_VALUE)).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.button))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.niceID).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.freeID).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.anyID).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -2, 215, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.button).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private boolean isNiceID(int id) {
        return id >= 8000 && id <= 8500 || id >= 9500 && id <= 9999;
    }

    private String renderName(int id) {
        String name = Integer.toString(id);
        while (name.length() < 5) {
            name = "0" + name;
        }
        HashMap<String, String> txt = Repository.getBookTxt(id);
        if (txt != null) {
            name = name + " " + txt.get("Name") + " (" + txt.get("Author") + ")";
        }
        return name;
    }

    private void niceIDActionPerformed(ActionEvent evt) {
        int i;
        this.idList.clear();
        File[] books = FileEnvironment.getBooksDirectory().listFiles();
        HashSet<Integer> _books = new HashSet<Integer>();
        for (i = 0; i < books.length; ++i) {
            try {
                _books.add(Integer.parseInt(books[i].getName()));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        for (i = 0; i <= 9999; ++i) {
            if (Translator.ting2code(i) < 0 || !this.isNiceID(i) || _books.contains(i)) continue;
            this.idList.add(new Tupel<Integer, String>(i, this.renderName(i)));
        }
        this.model.refresh();
    }

    private void freeIDActionPerformed(ActionEvent evt) {
        this.idList.clear();
        for (int i = 0; i <= 9999; ++i) {
            if (Repository.getBookTxt(i) != null) continue;
            this.idList.add(new Tupel<Integer, String>(i, this.renderName(i)));
        }
        this.model.refresh();
    }

    private void anyIDActionPerformed(ActionEvent evt) {
        this.idList.clear();
        for (int i = 0; i <= 9999; ++i) {
            this.idList.add(new Tupel<Integer, String>(i, this.renderName(i)));
        }
        this.model.refresh();
    }

    private void buttonActionPerformed(ActionEvent evt) {
        int index = this.list.getSelectedIndex();
        if (index != -1) {
            int id = (Integer)this.idList.get((int)index).a;
            this.callback.callback(id);
            this.setVisible(false);
        }
    }

    class MyListModel
    implements ListModel {
        private LinkedList<ListDataListener> listeners = new LinkedList();

        MyListModel() {
        }

        @Override
        public int getSize() {
            return IDChooser.this.idList.size();
        }

        public Object getElementAt(int index) {
            return ((Tupel)((IDChooser)IDChooser.this).idList.get((int)index)).b;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        public void refresh() {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                ((ListDataListener)i.next()).contentsChanged(null);
            }
        }
    }
}

