/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import tingeltangel.tools.FileEnvironment;
import tingeltangel.tools.ProgressDialog;

public class Repository {
    private static final String KNOWN_BOOKS_FILE = "/known_books.txt";
    private static final HashMap<Integer, HashMap<String, String>> BOOKS = new HashMap();

    private static HashMap<String, String> readTxt(File txt) throws IOException {
        String row;
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(txt), "UTF-8"));
        HashMap<String, String> data = new HashMap<String, String>();
        while ((row = in.readLine()) != null) {
            if ((row = row.trim()).isEmpty()) continue;
            int p = row.indexOf(":");
            if (p > 0) {
                String key = row.substring(0, p).trim();
                String value = row.substring(p + 1).trim();
                data.put(key, value);
                continue;
            }
            throw new IOException("txt file broken");
        }
        in.close();
        return data;
    }

    private static void init() {
        try {
            BOOKS.clear();
            File booksDir = FileEnvironment.getRepositoryDirectory();
            if (!booksDir.canRead()) {
                throw new Error("can't read from books directory");
            }
            if (!booksDir.canWrite()) {
                throw new Error("can't write to books directory");
            }
            List<File> bookFiles = Arrays.asList(booksDir.listFiles());
            for (File bookFile : bookFiles) {
                String name = bookFile.getName();
                if (!name.endsWith(".txt")) continue;
                int id = Integer.parseInt(name.substring(0, name.indexOf("_")));
                HashMap<String, String> data = Repository.readTxt(bookFile);
                if (data.containsKey("Name")) {
                    BOOKS.put(id, data);
                    continue;
                }
                System.out.println(String.format("Deleted broken file %s", data.get("Name")));
                bookFile.delete();
            }
        }
        catch (IOException ioe) {
            throw new Error(ioe);
        }
    }

    public static Integer[] getIDs() {
        Object[] bks = BOOKS.keySet().toArray(new Integer[0]);
        Arrays.sort(bks);
        return bks;
    }

    public static HashMap<String, String> getBookTxt(int id) {
        return BOOKS.get(id);
    }

    private static File getBookFile(int id, String type) {
        String _id = Integer.toString(id);
        while (_id.length() < 5) {
            _id = "0" + _id;
        }
        File file = new File(FileEnvironment.getRepositoryDirectory(), _id + type);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    public static boolean exists(int id) {
        return Repository.getBookFile(id, "_en.ouf") != null;
    }

    public static boolean txtExists(int id) {
        return Repository.getBookFile(id, "_en.txt") != null;
    }

    public static File getBookOuf(int id) {
        return Repository.getBookFile(id, "_en.ouf");
    }

    public static File getBookPng(int id) {
        return Repository.getBookFile(id, "_en.png");
    }

    public static File getBookSrc(int id) {
        return Repository.getBookFile(id, "_en.src");
    }

    public static File getBookTxtFile(int id) {
        return Repository.getBookFile(id, "_en.txt");
    }

    private static void download(String url, File dest, ProgressDialog progress) throws FileNotFoundException, IOException {
        int k;
        byte[] buffer = new byte[4096];
        URLConnection connection = new URL(url).openConnection();
        int size = connection.getContentLength();
        if (progress != null) {
            progress.setMax(size);
        }
        InputStream in = connection.getInputStream();
        FileOutputStream out = new FileOutputStream(dest);
        int s = 0;
        while ((k = in.read(buffer)) != -1) {
            ((OutputStream)out).write(buffer, 0, k);
            s += k;
            if (progress == null) continue;
            progress.setVal(s);
        }
        in.close();
        ((OutputStream)out).close();
    }

    public static void download(int id, ProgressDialog progress) throws IOException {
        String _id = Integer.toString(id);
        while (_id.length() < 5) {
            _id = "0" + _id;
        }
        File txtFile = new File(FileEnvironment.getRepositoryDirectory(), _id + "_en.txt");
        Repository.download("http://system.ting.eu/book-files/get-description/id/" + _id + "/area/en", txtFile, null);
        BOOKS.put(id, Repository.readTxt(txtFile));
        File pngFile = new File(FileEnvironment.getRepositoryDirectory(), _id + "_en.png");
        Repository.download("http://system.ting.eu/book-files/get/id/" + _id + "/area/en/type/thumb", pngFile, null);
        File oufFile = new File(FileEnvironment.getRepositoryDirectory(), _id + "_en.ouf");
        Repository.download("http://system.ting.eu/book-files/get/id/" + _id + "/area/en/type/archive", oufFile, progress);
        if (Repository.getBookTxt(id).containsKey("ScriptMD5")) {
            File scriptFile = new File(FileEnvironment.getRepositoryDirectory(), _id + "_en.src");
            try {
                Repository.download("http://system.ting.eu/book-files/get/id/" + _id + "/area/en/type/script", scriptFile, null);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    public static void update(int id, ProgressDialog progress) throws FileNotFoundException, IOException {
        String _id = Integer.toString(id);
        while (_id.length() < 5) {
            _id = "0" + _id;
        }
        HashMap<String, String> bookTxt = Repository.getBookTxt(id);
        if (bookTxt == null) {
            throw new FileNotFoundException();
        }
        int version = Integer.parseInt(Repository.getBookTxt(id).get("Book Version"));
        File txtFile = new File(FileEnvironment.getRepositoryDirectory(), _id + "_en.txt");
        Repository.download("http://system.ting.eu/book-files/get-description/id/" + _id + "/area/en", txtFile, null);
        BOOKS.put(id, Repository.readTxt(txtFile));
        int version2 = Integer.parseInt(Repository.getBookTxt(id).get("Book Version"));
        if (version2 > version || !Repository.exists(id)) {
            File pngFile = new File(FileEnvironment.getRepositoryDirectory(), _id + "_en.png");
            Repository.download("http://system.ting.eu/book-files/get/id/" + _id + "/area/en/type/thumb", pngFile, null);
            File oufFile = new File(FileEnvironment.getRepositoryDirectory(), _id + "_en.ouf");
            Repository.download("http://system.ting.eu/book-files/get/id/" + _id + "/area/en/type/archive", oufFile, progress);
            if (Repository.getBookTxt(id).containsKey("ScriptMD5")) {
                File scriptFile = new File(FileEnvironment.getRepositoryDirectory(), _id + "_en.src");
                try {
                    Repository.download("http://system.ting.eu/book-files/get/id/" + _id + "/area/en/type/script", scriptFile, null);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (progress != null) {
            progress.done();
        }
    }

    public static void search(int id) {
        byte[] buffer = new byte[4096];
        InputStream in = null;
        OutputStream out = null;
        try {
            int k;
            String _id = Integer.toString(id);
            while (_id.length() < 5) {
                _id = "0" + _id;
            }
            in = new URL("http://system.ting.eu/book-files/get-description/id/" + _id + "/area/en").openStream();
            out = new FileOutputStream(new File(FileEnvironment.getRepositoryDirectory(), _id + "_en.txt"));
            while ((k = in.read(buffer)) != -1) {
                out.write(buffer, 0, k);
            }
            in.close();
            out.close();
        }
        catch (IOException ioe) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            System.out.println("id=" + id + ": " + ioe.getMessage());
        }
    }

    public static void search(ProgressDialog progress) {
        if (progress != null) {
            progress.setMax(9999);
        }
        for (int id = 0; id <= 9999; ++id) {
            if (progress != null) {
                progress.setVal(id);
            }
            Repository.search(id);
        }
        Repository.init();
        progress.done();
    }

    public static void initialUpdate(final Thread done) throws IOException {
        String row;
        final HashSet<String> toDownload = new HashSet<String>();
        BufferedReader bin = new BufferedReader(new InputStreamReader(Repository.class.getResourceAsStream(KNOWN_BOOKS_FILE)));
        while ((row = bin.readLine()) != null) {
            if ((row = row.trim()).isEmpty() || row.startsWith("#") || Repository.txtExists(Integer.parseInt(row))) continue;
            toDownload.add(row);
        }
        bin.close();
        final JFrame splash = new JFrame("initialisieren...");
        splash.setResizable(false);
        splash.setDefaultCloseOperation(0);
        splash.setBounds(100, 100, 300, 100);
        final JProgressBar bar = new JProgressBar();
        bar.setMaximum(toDownload.size());
        bar.setValue(0);
        bar.setBounds(10, 160, 280, 20);
        JPanel panel = new JPanel();
        JLabel label = new JLabel("B\u00fccher-Index herunterladen...");
        label.setBounds(30, 30, 100, 20);
        panel.add(label);
        panel.add(bar);
        splash.getContentPane().add(panel);
        splash.setVisible(true);
        System.out.println("need to download " + toDownload.size() + " book txt files...");
        new Thread(){

            @Override
            public void run() {
                byte[] buffer = new byte[4096];
                Iterator ids = toDownload.iterator();
                int c = 0;
                while (ids.hasNext()) {
                    String row = (String)ids.next();
                    bar.setValue(c++);
                    InputStream in = null;
                    OutputStream out = null;
                    try {
                        int k;
                        in = new URL("http://system.ting.eu/book-files/get-description/id/" + row + "/area/en").openStream();
                        out = new FileOutputStream(new File(FileEnvironment.getRepositoryDirectory(), row + "_en.txt"));
                        while ((k = in.read(buffer)) != -1) {
                            out.write(buffer, 0, k);
                        }
                        in.close();
                        out.close();
                    }
                    catch (IOException ioe) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        new File(FileEnvironment.getRepositoryDirectory(), row + "_en.txt").delete();
                        System.out.println("failed to load book " + row + ": " + ioe.getMessage());
                    }
                }
                System.out.println("got " + toDownload.size() + " book txt files");
                splash.dispose();
                Repository.init();
                done.start();
            }
        }.start();
    }

    public static void update(ProgressDialog progress) throws IOException {
        int r;
        Integer[] ids = Repository.getIDs();
        LinkedList<Integer> _ids = new LinkedList<Integer>();
        for (r = 0; r < ids.length; ++r) {
            if (!Repository.exists(ids[r])) continue;
            _ids.add(ids[r]);
        }
        if (progress != null) {
            progress.setMax(_ids.size());
        }
        for (r = 0; r < _ids.size(); ++r) {
            if (progress != null) {
                progress.setVal(r);
            }
            Repository.update((Integer)_ids.get(r), null);
        }
    }

    public static void cleanup() {
        File[] toDelete = FileEnvironment.getRepositoryDirectory().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".ouf");
            }
        });
        for (int i = 0; i < toDelete.length; ++i) {
            toDelete[i].delete();
        }
    }

    public static void main(String[] args) throws Exception {
        Integer[] ids = Repository.getIDs();
        File f = new File("bookList.txt");
        PrintWriter out = new PrintWriter(new FileWriter(f));
        out.println("^ Buch ID ^ Name ^ Herausgeber ^ Autor ^ Version ^ URL ^ L\u00e4ndercode ^ Downloads ^^^^");
        for (int i = 0; i < ids.length; ++i) {
            HashMap<String, String> book = Repository.getBookTxt(ids[i]);
            String id = Integer.toString(ids[i]);
            while (id.length() < 5) {
                id = "0" + id;
            }
            out.print("| " + id + " | " + book.get("Name") + " | ");
            out.print(book.get("Publisher") + " | " + book.get("Author") + " | ");
            out.print(book.get("Book Version") + " | " + book.get("URL") + " | " + book.get("Book Area Code") + " | ");
            out.print("[[http://system.ting.eu/book-files/get-description/id/" + id + "/area/en|txt-Datei]]" + " | ");
            out.print("[[http://system.ting.eu/book-files/get/id/" + id + "/area/en/type/thumb|png-Datei]]" + " | ");
            out.print("[[http://system.ting.eu/book-files/get/id/" + id + "/area/en/type/archive|ouf-Datei]]" + " | ");
            if (book.get("ScriptMD5") != null) {
                out.println("[[http://system.ting.eu/book-files/get/id/" + id + "/area/en/type/script|src-Datei]]" + " |");
                continue;
            }
            out.println("- |");
        }
        out.close();
    }

    public static HashMap<String, String> getBook(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return Repository.readTxt(file);
    }

    static {
        Repository.init();
    }
}

