/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli_ng;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import tingeltangel.cli_ng.CLI;
import tingeltangel.cli_ng.CliCmd;
import tingeltangel.core.Book;
import tingeltangel.core.Codes;
import tingeltangel.tools.FileEnvironment;

class GenerateCodes
extends CliCmd {
    GenerateCodes() {
    }

    @Override
    public String getName() {
        return "generate-codes";
    }

    @Override
    public String getDescription() {
        return "generate-codes png|eps 600|1200 <size in mm> <zip file>|<directory>";
    }

    @Override
    public int execute(String[] args) {
        if (args.length != 4) {
            return this.error("falsche Anzahl von Parametern angegeben");
        }
        File file = new File(args[3].trim());
        if (!file.canWrite()) {
            return this.error("Die Datei oder das Verzeichnis \" + file.getAbsolutePath() + \" kann nicht geschrieben werden");
        }
        if (args[1].toLowerCase().equals("600")) {
            Codes.setResolution(0);
        } else if (args[1].toLowerCase().equals("1200")) {
            Codes.setResolution(1);
        } else {
            return this.error("Syntax Fehler");
        }
        int size = -1;
        try {
            size = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            return this.error("ung\u00fcltige Gro\u00dfe angegeben (5-100)");
        }
        if (size < 5 || size > 100) {
            return this.error("ung\u00fcltige Gro\u00dfe angegeben (5-100)");
        }
        Book book = CLI.getBook();
        try {
            File[] entries = null;
            if (args[0].toLowerCase().equals("png")) {
                book.pngExport(FileEnvironment.getCodesDirectory(book.getID()), size, null);
                entries = FileEnvironment.getCodesDirectory(book.getID()).listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().endsWith(".png");
                    }
                });
            } else if (args[0].toLowerCase().equals("eps")) {
                book.epsExport(FileEnvironment.getCodesDirectory(book.getID()), size, null);
                entries = FileEnvironment.getCodesDirectory(book.getID()).listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().endsWith(".eps");
                    }
                });
            } else {
                return this.error("Syntax Fehler");
            }
            if (file.isDirectory()) {
                for (int i = 0; i < entries.length; ++i) {
                    FileEnvironment.copy(entries[i], new File(file, entries[i].getName()));
                }
            } else {
                FileOutputStream fos = new FileOutputStream(file);
                ZipOutputStream out = new ZipOutputStream(fos);
                byte[] buffer = new byte[4096];
                for (int i = 0; i < entries.length; ++i) {
                    int length;
                    FileInputStream in = new FileInputStream(entries[i]);
                    ZipEntry zipEntry = new ZipEntry(entries[i].getName());
                    out.putNextEntry(zipEntry);
                    while ((length = in.read(buffer)) >= 0) {
                        out.write(buffer, 0, length);
                    }
                    out.closeEntry();
                    in.close();
                }
                out.close();
                fos.close();
            }
        }
        catch (IOException e) {
            return this.error("Codes konnten nicht erzeugt werden", e);
        }
        return this.ok();
    }
}

