/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import tingeltangel.core.Book;
import tingeltangel.core.SortedIntList;
import tingeltangel.core.scripting.RegisterListener;
import tingeltangel.gui.EditorFrame;

public class RegisterPanel
extends JPanel
implements RegisterListener {
    private final SortedIntList registers = new SortedIntList();
    private final RegisterTableModel model = new RegisterTableModel();
    private final JTable table = new JTable(this.model);
    private final EditorFrame frame;

    public RegisterPanel(EditorFrame frame) {
        this.frame = frame;
        this.setLayout(new GridLayout(1, 1));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(0);
        this.table.getColumnModel().getColumn(1).setMinWidth(20);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(0);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setPreferredSize(new Dimension(0, 300));
        this.add(jScrollPane);
    }

    @Override
    public void registerChanged(int register, int value) {
        this.registers.add(register);
        this.model.pushEvent(new TableModelEvent(this.model));
    }

    class RegisterTableModel
    implements TableModel {
        private final HashSet<TableModelListener> listeners = new HashSet();

        RegisterTableModel() {
        }

        @Override
        public int getRowCount() {
            return RegisterPanel.this.registers.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Register";
                }
                case 1: {
                    return "Bemerkung";
                }
                case 2: {
                    return "Wert";
                }
            }
            throw new Error();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return true;
                }
            }
            throw new Error();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Book book = RegisterPanel.this.frame.getBook();
            switch (columnIndex) {
                case 0: {
                    return RegisterPanel.this.registers.get(rowIndex);
                }
                case 1: {
                    return book.getEmulator().getHint(RegisterPanel.this.registers.get(rowIndex));
                }
                case 2: {
                    return book.getEmulator().getRegister(RegisterPanel.this.registers.get(rowIndex));
                }
            }
            throw new Error();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Book book = RegisterPanel.this.frame.getBook();
            switch (columnIndex) {
                case 1: {
                    book.getEmulator().setHint(RegisterPanel.this.registers.get(rowIndex), (String)aValue);
                    this.pushEvent(new TableModelEvent(this, rowIndex, rowIndex, 1));
                    break;
                }
                case 2: {
                    int value = 0;
                    try {
                        value = Integer.parseInt((String)aValue);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    book.getEmulator().setRegister(RegisterPanel.this.registers.get(rowIndex), value);
                    this.pushEvent(new TableModelEvent(this, rowIndex, rowIndex, 1));
                }
            }
        }

        private void pushEvent(TableModelEvent event) {
            Iterator<TableModelListener> i = this.listeners.iterator();
            while (i.hasNext()) {
                i.next().tableChanged(event);
            }
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }
    }
}

