/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.core;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import tingeltangel.core.Translator;
import tingeltangel.core.Tupel;

public class Codes {
    private static final float[] PS_DOT_SIZE = new float[]{0.12f, 0.06f};
    private static final float[] PS_DELTA_SIZE = new float[]{0.12f, 0.12f};
    private static final float[] PS_BLOCK_SIZE = new float[]{0.84f, 0.84f};
    private static final int[] PNG_DOT_SIZE = new int[]{1, 2};
    private static final int[] PNG_DELTA_SIZE = new int[]{1, 2};
    private static final int[] PNG_DELTA_X_SIZE = new int[]{1, 2};
    private static final int[] PNG_BLOCK_SIZE = new int[]{6, 12};
    private static final float[] PNG_PIXEL_PER_MM = new float[]{23.62205f, 47.24409f};
    public static final int DPI600 = 0;
    public static final int DPI1200 = 1;
    private static int resolution = 1;

    public static void setResolution(int resolution) {
        Codes.resolution = resolution;
    }

    private static int[] getDotPosFromInt(int i) {
        int[] f = new int[2];
        switch (i) {
            case 0: {
                f[0] = 1;
                f[1] = -1;
                return f;
            }
            case 1: {
                f[0] = -1;
                f[1] = -1;
                return f;
            }
            case 2: {
                f[0] = -1;
                f[1] = 1;
                return f;
            }
            case 3: {
                f[0] = 1;
                f[1] = 1;
                return f;
            }
        }
        throw new Error();
    }

    private static int getPari(int w7, int w6, int w5, int w4, int w3, int w2, int w1, int w0) {
        int c1 = ((w1 ^ w4 ^ w6 ^ w7) & 1) << 1;
        int c2 = (w0 ^ w2 ^ w3 ^ w5) & 1;
        return c1 | c2;
    }

    private static int[][][] getPatternFromInt(int i) {
        int w0 = i & 3;
        int w1 = i >> 2 & 3;
        int w2 = i >> 4 & 3;
        int w3 = i >> 6 & 3;
        int w4 = i >> 8 & 3;
        int w5 = i >> 10 & 3;
        int w6 = i >> 12 & 3;
        int w7 = i >> 14 & 3;
        int[][][] pattern = new int[][][]{new int[][]{{0, 0}, {0, 0}, {0, 0}, {0, 0}}, new int[][]{{0, 0}, Codes.getDotPosFromInt(Codes.getPari(w7, w6, w5, w4, w3, w2, w1, w0)), Codes.getDotPosFromInt(w7), Codes.getDotPosFromInt(w6)}, new int[][]{{1, 0}, Codes.getDotPosFromInt(w5), Codes.getDotPosFromInt(w4), Codes.getDotPosFromInt(w3)}, new int[][]{{0, 0}, Codes.getDotPosFromInt(w2), Codes.getDotPosFromInt(w1), Codes.getDotPosFromInt(w0)}};
        return pattern;
    }

    private static void drawText(float x, float y, String text, PrintWriter out) {
        out.println("newpath");
        out.println(x + " " + y + " moveto");
        out.println("(" + text + ") show");
    }

    private static void drawDot(float x, float y, PrintWriter out) {
        out.println("newpath");
        out.println(x + " " + y + " moveto");
        out.println(x + " " + (y + PS_DOT_SIZE[resolution]) + " lineto");
        out.println(x + PS_DOT_SIZE[resolution] + " " + (y + PS_DOT_SIZE[resolution]) + " lineto");
        out.println(x + PS_DOT_SIZE[resolution] + " " + y + " lineto");
        out.println("fill");
    }

    private static void drawPattern(int p, float x, float y, PrintWriter out) {
        int[][][] pattern = Codes.getPatternFromInt(p);
        for (int dx = 0; dx < 4; ++dx) {
            for (int dy = 0; dy < 4; ++dy) {
                float px = (float)pattern[3 - dy][dx][0] * PS_DELTA_SIZE[resolution];
                float py = (float)pattern[3 - dy][dx][1] * PS_DELTA_SIZE[resolution];
                Codes.drawDot(x + (float)dx * PS_BLOCK_SIZE[resolution] + px, y + (float)dy * PS_BLOCK_SIZE[resolution] + py, out);
            }
        }
    }

    private static void drawCarpet(int p, float x, float y, int w, int h, String label, PrintWriter out) {
        if (label != null) {
            Codes.drawText(x, y - 4.0f, label, out);
        }
        w = (int)((float)w / (4.0f * PS_BLOCK_SIZE[resolution]));
        h = (int)((float)h / (4.0f * PS_BLOCK_SIZE[resolution]));
        for (int ix = 0; ix < w; ++ix) {
            for (int iy = 0; iy < h; ++iy) {
                Codes.drawPattern(p, x + (float)(ix * 4) * PS_BLOCK_SIZE[resolution], y + (float)(iy * 4) * PS_BLOCK_SIZE[resolution], out);
            }
        }
        out.flush();
    }

    public static void drawEps(int code, int width, int height, PrintWriter out) {
        width = (int)((double)width * 100.0 / 25.4);
        height = (int)((double)height * 100.0 / 25.4);
        out.println("%!PS-Adobe-3.0 EPSF-3.0");
        out.println("%%BoundingBox: 0 0 " + width + " " + height);
        Codes.drawCarpet(code, 0.0f, 0.0f, width, height, null, out);
    }

    private static void drawPattern(int code, int x, int y, int width, int height, Graphics2D graphics) {
        int[][][] pattern = Codes.getPatternFromInt(code);
        for (int ix = 0; ix < width; ++ix) {
            for (int iy = 0; iy < height; ++iy) {
                for (int dx = 0; dx < 4; ++dx) {
                    int mx = ix * 4 * PNG_BLOCK_SIZE[resolution] + dx * PNG_BLOCK_SIZE[resolution] + PNG_BLOCK_SIZE[resolution] / 2;
                    for (int dy = 0; dy < 4; ++dy) {
                        int py;
                        int px;
                        int my = iy * 4 * PNG_BLOCK_SIZE[resolution] + dy * PNG_BLOCK_SIZE[resolution] + PNG_BLOCK_SIZE[resolution] / 2;
                        if (pattern[dy][dx][1] == 0 && pattern[dy][dx][0] > 0) {
                            px = mx + pattern[dy][dx][0] * PNG_DELTA_X_SIZE[resolution];
                            py = my;
                        } else {
                            px = mx + pattern[dy][dx][0] * PNG_DELTA_SIZE[resolution];
                            py = my - pattern[dy][dx][1] * PNG_DELTA_SIZE[resolution];
                        }
                        graphics.fillRect(px + x, py + y, PNG_DOT_SIZE[resolution], PNG_DOT_SIZE[resolution]);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePng(BufferedImage image, OutputStream out) throws IOException {
        Iterator<ImageWriter> iw = ImageIO.getImageWritersByFormatName("PNG");
        while (iw.hasNext()) {
            ImageWriter writer = iw.next();
            ImageWriteParam writeParam = writer.getDefaultWriteParam();
            ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
            IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
            if (metadata.isReadOnly() || !metadata.isStandardMetadataFormatSupported()) continue;
            double dotsPerMilli = PNG_PIXEL_PER_MM[resolution];
            IIOMetadataNode horiz = new IIOMetadataNode("HorizontalPixelSize");
            horiz.setAttribute("value", Double.toString(dotsPerMilli));
            IIOMetadataNode vert = new IIOMetadataNode("VerticalPixelSize");
            vert.setAttribute("value", Double.toString(dotsPerMilli));
            IIOMetadataNode dim = new IIOMetadataNode("Dimension");
            dim.appendChild(horiz);
            dim.appendChild(vert);
            IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
            root.appendChild(dim);
            metadata.mergeTree("javax_imageio_1.0", root);
            ImageOutputStream stream = ImageIO.createImageOutputStream(out);
            try {
                writer.setOutput(stream);
                writer.write(metadata, new IIOImage(image, null, metadata), writeParam);
                break;
            }
            finally {
                stream.close();
            }
        }
    }

    public static BufferedImage generateCodeImage(int code, int width, int height) {
        width = (int)((float)width * PNG_PIXEL_PER_MM[resolution]);
        height = (int)((float)height * PNG_PIXEL_PER_MM[resolution]);
        int imageWidth = (width /= 4 * PNG_BLOCK_SIZE[resolution]) * 4 * PNG_BLOCK_SIZE[resolution];
        int imageHeight = (height /= 4 * PNG_BLOCK_SIZE[resolution]) * 4 * PNG_BLOCK_SIZE[resolution];
        BufferedImage image = new BufferedImage(imageWidth, imageHeight, 2);
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, imageWidth, imageHeight);
        graphics.setColor(Color.black);
        Codes.drawPattern(code, 0, 0, width, height, graphics);
        return image;
    }

    public static void drawPng(int code, int width, int height, OutputStream out) throws IOException {
        Codes.writePng(Codes.generateCodeImage(code, width, height), out);
    }

    public static void drawBooklet(String title, int mid, List<Tupel<Integer, String>> booklet, PrintWriter out) {
        mid = Translator.ting2code(mid);
        int entriesPerPage = 30;
        int pages = booklet.size() / entriesPerPage;
        if (booklet.size() % entriesPerPage > 0) {
            ++pages;
        }
        int page = 0;
        int entry = 0;
        out.println("%!PS-Adobe-2.0");
        out.println();
        out.println("%%Pages: " + pages);
        for (Tupel<Integer, String> tupel : booklet) {
            if (entry % entriesPerPage == 0) {
                if (entry != 0) {
                    out.println("showpage");
                    ++page;
                }
                out.println("%%Page: " + (page + 1) + " " + (page + 1));
                out.println("/Times-Roman findfont");
                out.println("10 scalefont");
                out.println("setfont");
                Codes.drawText(80.0f, 815.0f, "Buch: " + title + " [Seite " + (page + 1) + " von " + pages + "]", out);
                out.println("/Times-Roman findfont");
                out.println("8 scalefont");
                out.println("setfont");
                if (mid >= 0) {
                    Codes.drawCarpet(mid, 50.0f, 810.0f, 20, 20, null, out);
                }
            }
            Codes.drawText(80.0f, 780 - entry % entriesPerPage * 25, Integer.toString((Integer)tupel.a) + ": " + (String)tupel.b, out);
            int cid = Translator.ting2code((Integer)tupel.a);
            if (cid >= 0) {
                Codes.drawCarpet(cid, 50.0f, 775 - entry % entriesPerPage * 25, 20, 20, null, out);
            }
            ++entry;
        }
        out.println("showpage");
        out.flush();
    }

    public static void drawPage(int start, PrintWriter out) {
        int cx = 25;
        int cy = 40;
        int till = Math.min(65535, start + cx * cy - 1);
        out.println("/Times-Roman findfont");
        out.println("5 scalefont");
        out.println("setfont");
        Codes.drawText(50.0f, 815.0f, "CODE IDS: " + start + " - " + till, out);
        out.println("/Times-Roman findfont");
        out.println("4 scalefont");
        out.println("setfont");
        for (int y = cy - 1; y >= 0; --y) {
            for (int x = 0; x < cx; ++x) {
                if (start >= 65536) continue;
                Codes.drawCarpet(start, 50 + x * 20, 17 + y * 20, 15, 15, "" + start++, out);
            }
        }
        out.println("showpage");
        out.flush();
    }

    public static void drawPage(int[] index, String[] caption, PrintWriter out) {
        int cx = 25;
        int cy = 40;
        out.println("/Times-Roman findfont");
        out.println("5 scalefont");
        out.println("setfont");
        Codes.drawText(50.0f, 815.0f, "TING IDS: " + caption[0] + " - " + caption[caption.length - 1], out);
        out.println("/Times-Roman findfont");
        out.println("4 scalefont");
        out.println("setfont");
        int p = 0;
        for (int y = cy - 1; y >= 0; --y) {
            for (int x = 0; x < cx; ++x) {
                if (p >= index.length) continue;
                if (index[p] != -1) {
                    Codes.drawCarpet(index[p], 50 + x * 20, 17 + y * 20, 15, 15, caption[p], out);
                }
                ++p;
            }
        }
        out.println("showpage");
        out.flush();
    }
}

