/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.core.scripting;

import java.lang.reflect.Method;
import tingeltangel.core.scripting.Emulator;
import tingeltangel.core.scripting.Methods;

public class Command
implements Comparable {
    public static final int NONE = 0;
    public static final int REGISTER = 1;
    public static final int VALUE = 2;
    public static final int LABEL = 3;
    private String asm;
    private int code;
    private int firstArgument;
    private int secondArgument;
    private String method;
    private String description;

    public String getAsm() {
        return this.asm;
    }

    public String getDescription() {
        return this.description;
    }

    public Method getMethod() {
        try {
            return Methods.class.getMethod(this.method, Emulator.class, Integer.class, Integer.class);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    public int getCode() {
        return this.code;
    }

    public Command(String method, String asm, int code, String description) {
        this.init(method, asm, code, 0, 0, description);
    }

    public Command(String method, String asm, int code, int argument, String description) {
        this.init(method, asm, code, argument, 0, description);
    }

    public Command(String method, String asm, int code, int firstArgument, int secondArgument, String description) {
        this.init(method, asm, code, firstArgument, secondArgument, description);
    }

    private void init(String method, String asm, int code, int firstArgument, int secondArgument, String description) {
        this.asm = asm;
        this.code = code;
        this.firstArgument = firstArgument;
        this.secondArgument = secondArgument;
        this.method = method;
        this.description = description;
    }

    public int getNumberOfArguments() {
        if (this.firstArgument == 0) {
            return 0;
        }
        if (this.secondArgument == 0) {
            return 1;
        }
        return 2;
    }

    public boolean firstArgumentIsRegister() {
        return this.firstArgument == 1;
    }

    public boolean firstArgumentIsValue() {
        return this.firstArgument == 2;
    }

    public boolean firstArgumentIsLabel() {
        return this.firstArgument == 3;
    }

    public boolean secondArgumentIsRegister() {
        return this.secondArgument == 1;
    }

    public boolean secondArgumentIsValue() {
        return this.secondArgument == 2;
    }

    public int compareTo(Object obj) {
        Command c = (Command)obj;
        return Integer.valueOf(this.code).compareTo(c.code);
    }
}

