/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.core.scripting;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import tingeltangel.core.scripting.Commands;
import tingeltangel.core.scripting.Parameter;
import tingeltangel.core.scripting.SyntaxError;

public class Template {
    private final LinkedList<Parameter> params = new LinkedList();
    private final LinkedList<String> work = new LinkedList();
    private final String code;
    private String name = "";
    private int labelCounter = 0;
    private static final String[] TEMPLATES = new String[]{"div", "mod", "divmod"};
    private static final HashMap<String, Template> templates = new HashMap();

    private Template(String file) {
        this.name = file;
        try {
            String row;
            BufferedReader in = new BufferedReader(new InputStreamReader(Commands.class.getResourceAsStream("/templates/" + this.name)));
            StringBuilder _code = new StringBuilder();
            boolean inHead = true;
            while ((row = in.readLine()) != null) {
                if ((row = row.trim().toLowerCase()).isEmpty() || row.startsWith("//")) continue;
                if (inHead) {
                    int i;
                    String[] p;
                    if (row.startsWith("params=")) {
                        p = row.substring("params=".length()).split(",");
                        for (i = 0; i < p.length; ++i) {
                            int k = p[i].indexOf(":");
                            String def = p[i].substring(0, k).trim();
                            Parameter param = new Parameter();
                            param.name = p[i].substring(k + 1).trim();
                            param.register = def.contains("r");
                            param.value = def.contains("v");
                            this.params.add(param);
                        }
                        continue;
                    }
                    if (row.startsWith("work=")) {
                        p = row.substring("work=".length()).split(",");
                        for (i = 0; i < p.length; ++i) {
                            this.work.add(p[i].trim());
                        }
                        continue;
                    }
                    if (row.equals("---")) {
                        inHead = false;
                        continue;
                    }
                    throw new Error();
                }
                _code.append(row).append("\n");
            }
            this.code = _code.toString();
        }
        catch (IOException ioe) {
            throw new Error(ioe);
        }
    }

    public static Template getTemplate(String name) {
        return templates.get(name);
    }

    public String getName() {
        return this.name;
    }

    public String getCode(LinkedList<String> args, LinkedList<Integer> usableRegisters) throws SyntaxError {
        if (args.size() != this.params.size()) {
            throw new SyntaxError("falsche Anzahl der Argumente in " + this.name);
        }
        if (usableRegisters.size() < this.work.size()) {
            throw new SyntaxError("es stehen zu wenig freie Register zur Verf\u00fcgung in " + this.name);
        }
        String _code = this.code;
        Iterator works = this.work.iterator();
        Iterator regs = usableRegisters.iterator();
        while (works.hasNext()) {
            String w = (String)works.next();
            int r = (Integer)regs.next();
            _code = _code.replaceAll("\\" + w, "v" + Integer.toString(r));
        }
        Iterator as = args.iterator();
        Iterator ps = this.params.iterator();
        int k = 0;
        while (as.hasNext()) {
            ++k;
            String a = ((String)as.next()).toLowerCase();
            Parameter p = (Parameter)ps.next();
            if (a.startsWith("v")) {
                if (!p.register) {
                    throw new SyntaxError("register in " + this.name + " als " + k + ". argument nicht erlaubt");
                }
            } else if (!p.value) {
                throw new SyntaxError("wert in " + this.name + " als " + k + ". argument nicht erlaubt");
            }
            _code = _code.replaceAll("\\" + p.name, a);
        }
        ++this.labelCounter;
        BufferedReader in = new BufferedReader(new StringReader(_code));
        StringBuilder out = new StringBuilder();
        try {
            String row;
            while ((row = in.readLine()) != null) {
                row = row.trim().toLowerCase();
                boolean rowAdded = false;
                if (row.startsWith(":")) {
                    rowAdded = true;
                    out.append(":").append("templatelabel_").append(this.name);
                    out.append("_").append(this.labelCounter).append("_").append(row.substring(1));
                } else {
                    int p = row.indexOf(" ");
                    if (p != -1 && Commands.isJump(row.substring(0, p))) {
                        rowAdded = true;
                        out.append(row.substring(0, p)).append(" templatelabel_").append(this.name);
                        out.append("_").append(this.labelCounter).append("_").append(row.substring(p).trim());
                    }
                }
                if (!rowAdded) {
                    out.append(row);
                }
                out.append("\n");
            }
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
        return out.toString();
    }

    static {
        for (int i = 0; i < TEMPLATES.length; ++i) {
            templates.put(TEMPLATES[i], new Template(TEMPLATES[i]));
        }
    }
}

