/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.core.scripting;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import tingeltangel.core.scripting.Command;
import tingeltangel.core.scripting.SyntaxError;

public class Commands {
    private static final HashMap<String, HashSet<Command>> commands = new HashMap();
    private static final HashMap<Integer, Command> opcode2command = new HashMap();

    private static int parseArg(String s) {
        if (s.equals("L")) {
            return 3;
        }
        if (s.equals("R")) {
            return 1;
        }
        if (s.equals("V")) {
            return 2;
        }
        throw new Error();
    }

    public static Command getCommand(int opcode) {
        return opcode2command.get(opcode);
    }

    public static Command getCommand(String cmd) {
        HashSet<Command> set = commands.get(cmd);
        if (set.size() != 1) {
            throw new Error();
        }
        return set.iterator().next();
    }

    public static boolean isJump(String cmd) {
        HashSet<Command> set = commands.get(cmd);
        if (set.isEmpty()) {
            return false;
        }
        return set.iterator().next().firstArgumentIsLabel();
    }

    private static boolean isValue(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static boolean isRegister(String s) {
        int i;
        if (!s.toLowerCase().startsWith("v")) {
            return false;
        }
        s = s.substring(1);
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return i >= 0 && i <= 99;
    }

    public static Command getCommand(String cmd, String firstArgument) throws SyntaxError {
        HashSet<Command> set = commands.get(cmd);
        Command cmd12 = set.iterator().next();
        if (cmd12.firstArgumentIsLabel()) {
            return cmd12;
        }
        for (Command cmd12 : set) {
            if (Commands.isValue(firstArgument) && cmd12.firstArgumentIsValue()) {
                return cmd12;
            }
            if (!Commands.isRegister(firstArgument) || !cmd12.firstArgumentIsRegister()) continue;
            return cmd12;
        }
        throw new SyntaxError("bad number of arguments or bad argument types (cmd=" + cmd + "; arg1=" + firstArgument + ")");
    }

    public static Command getCommand(String cmd, String firstArgument, String secondArgument) throws SyntaxError {
        for (Command cmd1 : commands.get(cmd)) {
            boolean match1 = false;
            boolean match2 = false;
            if (Commands.isValue(firstArgument) && cmd1.firstArgumentIsValue()) {
                match1 = true;
            } else if (Commands.isRegister(firstArgument) && cmd1.firstArgumentIsRegister()) {
                match1 = true;
            }
            if (Commands.isValue(secondArgument) && cmd1.secondArgumentIsValue()) {
                match2 = true;
            } else if (Commands.isRegister(secondArgument) && cmd1.secondArgumentIsRegister()) {
                match2 = true;
            }
            if (!match1 || !match2) continue;
            return cmd1;
        }
        throw new SyntaxError("bad number of arguments or bad argument types (cmd=" + cmd + "; arg1=" + firstArgument + "; arg2=" + secondArgument + ")");
    }

    private static void addCmd(Command command) {
        HashSet<Command> set = commands.get(command.getAsm());
        if (set == null) {
            set = new HashSet();
            commands.put(command.getAsm(), set);
        }
        set.add(command);
        opcode2command.put(command.getCode(), command);
    }

    public static Iterator<Command> iterator() {
        TreeSet all = new TreeSet();
        Iterator<HashSet<Command>> i = commands.values().iterator();
        while (i.hasNext()) {
            all.addAll(i.next());
        }
        return all.iterator();
    }

    public static int getSize(String cmd) throws SyntaxError {
        HashSet<Command> set = commands.get(cmd);
        if (set == null) {
            throw new SyntaxError("unknown command (" + cmd + ")");
        }
        Command c = set.iterator().next();
        return c.getNumberOfArguments() * 2 + 2;
    }

    public static int getArguments(String cmd) throws SyntaxError {
        HashSet<Command> set = commands.get(cmd);
        if (set == null) {
            throw new SyntaxError("unknown command (" + cmd + ")");
        }
        return set.iterator().next().getNumberOfArguments();
    }

    static {
        try {
            String row;
            BufferedReader in = new BufferedReader(new InputStreamReader(Commands.class.getResourceAsStream("/commands.properties")));
            while ((row = in.readLine()) != null) {
                if ((row = row.trim()).isEmpty() || row.startsWith("#")) continue;
                String[] args = row.split("\\|");
                int code = Integer.parseInt(args[0].substring(2), 16);
                if (args.length == 4) {
                    Commands.addCmd(new Command(args[1], args[2], code, args[3]));
                    continue;
                }
                if (args.length == 5) {
                    Commands.addCmd(new Command(args[1], args[2], code, Commands.parseArg(args[3]), args[4]));
                    continue;
                }
                if (args.length == 6) {
                    Commands.addCmd(new Command(args[1], args[2], code, Commands.parseArg(args[3]), Commands.parseArg(args[4]), args[5]));
                    continue;
                }
                throw new Error();
            }
            in.close();
        }
        catch (IOException ioe) {
            throw new Error(ioe);
        }
    }
}

