/* This file was generated by SableCC (http://www.sablecc.org/). */

package tiptoi_reveng.parser;

import tiptoi_reveng.lexer.*;
import tiptoi_reveng.node.*;
import tiptoi_reveng.analysis.*;
import java.util.*;

import java.io.DataInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;

@SuppressWarnings("nls")
public class Parser
{
    public final Analysis ignoredTokens = new AnalysisAdapter();

    protected ArrayList nodeList;

    private final Lexer lexer;
    private final ListIterator stack = new LinkedList().listIterator();
    private int last_pos;
    private int last_line;
    private Token last_token;
    private final TokenIndex converter = new TokenIndex();
    private final int[] action = new int[2];

    private final static int SHIFT = 0;
    private final static int REDUCE = 1;
    private final static int ACCEPT = 2;
    private final static int ERROR = 3;

    public Parser(@SuppressWarnings("hiding") Lexer lexer)
    {
        this.lexer = lexer;
    }

    @SuppressWarnings({"unchecked","unused"})
    private void push(int numstate, ArrayList listNode) throws ParserException, LexerException, IOException
    {
        this.nodeList = listNode;

        if(!this.stack.hasNext())
        {
            this.stack.add(new State(numstate, this.nodeList));
            return;
        }

        State s = (State) this.stack.next();
        s.state = numstate;
        s.nodes = this.nodeList;
    }

    private int goTo(int index)
    {
        int state = state();
        int low = 1;
        int high = gotoTable[index].length - 1;
        int value = gotoTable[index][0][1];

        while(low <= high)
        {
            int middle = (low + high) / 2;

            if(state < gotoTable[index][middle][0])
            {
                high = middle - 1;
            }
            else if(state > gotoTable[index][middle][0])
            {
                low = middle + 1;
            }
            else
            {
                value = gotoTable[index][middle][1];
                break;
            }
        }

        return value;
    }

    private int state()
    {
        State s = (State) this.stack.previous();
        this.stack.next();
        return s.state;
    }

    private ArrayList pop()
    {
        return ((State) this.stack.previous()).nodes;
    }

    private int index(Switchable token)
    {
        this.converter.index = -1;
        token.apply(this.converter);
        return this.converter.index;
    }

    @SuppressWarnings("unchecked")
    public Start parse() throws ParserException, LexerException, IOException
    {
        push(0, null);
        List<Node> ign = null;
        while(true)
        {
            while(index(this.lexer.peek()) == -1)
            {
                if(ign == null)
                {
                    ign = new LinkedList<Node>();
                }

                ign.add(this.lexer.next());
            }

            if(ign != null)
            {
                this.ignoredTokens.setIn(this.lexer.peek(), ign);
                ign = null;
            }

            this.last_pos = this.lexer.peek().getPos();
            this.last_line = this.lexer.peek().getLine();
            this.last_token = this.lexer.peek();

            int index = index(this.lexer.peek());
            this.action[0] = Parser.actionTable[state()][0][1];
            this.action[1] = Parser.actionTable[state()][0][2];

            int low = 1;
            int high = Parser.actionTable[state()].length - 1;

            while(low <= high)
            {
                int middle = (low + high) / 2;

                if(index < Parser.actionTable[state()][middle][0])
                {
                    high = middle - 1;
                }
                else if(index > Parser.actionTable[state()][middle][0])
                {
                    low = middle + 1;
                }
                else
                {
                    this.action[0] = Parser.actionTable[state()][middle][1];
                    this.action[1] = Parser.actionTable[state()][middle][2];
                    break;
                }
            }

            switch(this.action[0])
            {
                case SHIFT:
		    {
		        ArrayList list = new ArrayList();
		        list.add(this.lexer.next());
                        push(this.action[1], list);
                    }
		    break;
                case REDUCE:
                    switch(this.action[1])
                    {
                    case 0: /* reduce AConditionalStatement */
		    {
			ArrayList list = new0();
			push(goTo(0), list);
		    }
		    break;
                    case 1: /* reduce AConditionalNoActionStatement */
		    {
			ArrayList list = new1();
			push(goTo(0), list);
		    }
		    break;
                    case 2: /* reduce AActionStatement */
		    {
			ArrayList list = new2();
			push(goTo(0), list);
		    }
		    break;
                    case 3: /* reduce ASetAction */
		    {
			ArrayList list = new3();
			push(goTo(1), list);
		    }
		    break;
                    case 4: /* reduce APlayAction */
		    {
			ArrayList list = new4();
			push(goTo(1), list);
		    }
		    break;
                    case 5: /* reduce AJumpAction */
		    {
			ArrayList list = new5();
			push(goTo(1), list);
		    }
		    break;
                    case 6: /* reduce AGameAction */
		    {
			ArrayList list = new6();
			push(goTo(1), list);
		    }
		    break;
                    case 7: /* reduce ACancelAction */
		    {
			ArrayList list = new7();
			push(goTo(1), list);
		    }
		    break;
                    case 8: /* reduce AEqComparison */
		    {
			ArrayList list = new8();
			push(goTo(2), list);
		    }
		    break;
                    case 9: /* reduce ANeqComparison */
		    {
			ArrayList list = new9();
			push(goTo(2), list);
		    }
		    break;
                    case 10: /* reduce ALtComparison */
		    {
			ArrayList list = new10();
			push(goTo(2), list);
		    }
		    break;
                    case 11: /* reduce AGtComparison */
		    {
			ArrayList list = new11();
			push(goTo(2), list);
		    }
		    break;
                    case 12: /* reduce ALteqComparison */
		    {
			ArrayList list = new12();
			push(goTo(2), list);
		    }
		    break;
                    case 13: /* reduce AGteqComparison */
		    {
			ArrayList list = new13();
			push(goTo(2), list);
		    }
		    break;
                    case 14: /* reduce APlayCommand */
		    {
			ArrayList list = new14();
			push(goTo(3), list);
		    }
		    break;
                    case 15: /* reduce AJumpCommand */
		    {
			ArrayList list = new15();
			push(goTo(4), list);
		    }
		    break;
                    case 16: /* reduce AGameCommand */
		    {
			ArrayList list = new16();
			push(goTo(5), list);
		    }
		    break;
                    case 17: /* reduce ATextFileName */
		    {
			ArrayList list = new17();
			push(goTo(6), list);
		    }
		    break;
                    case 18: /* reduce ANumberFileName */
		    {
			ArrayList list = new18();
			push(goTo(6), list);
		    }
		    break;
                    case 19: /* reduce ASingleFileList */
		    {
			ArrayList list = new19();
			push(goTo(7), list);
		    }
		    break;
                    case 20: /* reduce AMultipleFileList */
		    {
			ArrayList list = new20();
			push(goTo(7), list);
		    }
		    break;
                    case 21: /* reduce ASetAssignment */
		    {
			ArrayList list = new21();
			push(goTo(8), list);
		    }
		    break;
                    case 22: /* reduce APlusAssignment */
		    {
			ArrayList list = new22();
			push(goTo(8), list);
		    }
		    break;
                    case 23: /* reduce AMinusAssignment */
		    {
			ArrayList list = new23();
			push(goTo(8), list);
		    }
		    break;
                    case 24: /* reduce AValueTerm */
		    {
			ArrayList list = new24();
			push(goTo(9), list);
		    }
		    break;
                    case 25: /* reduce AVariableTerm */
		    {
			ArrayList list = new25();
			push(goTo(9), list);
		    }
		    break;
                    case 26: /* reduce AVariableLocation */
		    {
			ArrayList list = new26();
			push(goTo(10), list);
		    }
		    break;
                    case 27: /* reduce ARegisterLocation */
		    {
			ArrayList list = new27();
			push(goTo(10), list);
		    }
		    break;
                    case 28: /* reduce ATerminal$Action */
		    {
			ArrayList list = new28();
			push(goTo(11), list);
		    }
		    break;
                    case 29: /* reduce ANonTerminal$Action */
		    {
			ArrayList list = new29();
			push(goTo(11), list);
		    }
		    break;
                    }
                    break;
                case ACCEPT:
                    {
                        EOF node2 = (EOF) this.lexer.next();
                        PStatement node1 = (PStatement) pop().get(0);
                        Start node = new Start(node1, node2);
                        return node;
                    }
                case ERROR:
                    throw new ParserException(this.last_token,
                        "[" + this.last_line + "," + this.last_pos + "] " +
                        Parser.errorMessages[Parser.errors[this.action[1]]]);
            }
        }
    }



    @SuppressWarnings("unchecked")
    ArrayList new0() /* reduce AConditionalStatement */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PStatement pstatementNode1;
        {
            // Block
        PComparison pcomparisonNode2;
        PStatement pstatementNode3;
        pcomparisonNode2 = (PComparison)nodeArrayList1.get(0);
        pstatementNode3 = (PStatement)nodeArrayList3.get(0);

        pstatementNode1 = new AConditionalStatement(pcomparisonNode2, pstatementNode3);
        }
	nodeList.add(pstatementNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new1() /* reduce AConditionalNoActionStatement */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PStatement pstatementNode1;
        {
            // Block

        pstatementNode1 = new ANoopStatement();
        }
	nodeList.add(pstatementNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new2() /* reduce AActionStatement */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PStatement pstatementNode1;
        {
            // Block
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode2 = new LinkedList();
        listNode2 = (LinkedList)nodeArrayList1.get(0);
	if(listNode2 != null)
	{
	  listNode3.addAll(listNode2);
	}
        }

        pstatementNode1 = new AActionStatement(listNode3);
        }
	nodeList.add(pstatementNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new3() /* reduce ASetAction */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PAction pactionNode1;
        pactionNode1 = (PAction)nodeArrayList1.get(0);
	nodeList.add(pactionNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new4() /* reduce APlayAction */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PAction pactionNode1;
        pactionNode1 = (PAction)nodeArrayList1.get(0);
	nodeList.add(pactionNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new5() /* reduce AJumpAction */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PAction pactionNode1;
        pactionNode1 = (PAction)nodeArrayList1.get(0);
	nodeList.add(pactionNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new6() /* reduce AGameAction */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PAction pactionNode1;
        pactionNode1 = (PAction)nodeArrayList1.get(0);
	nodeList.add(pactionNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new7() /* reduce ACancelAction */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PAction pactionNode1;
        {
            // Block

        pactionNode1 = new ACancelAction();
        }
	nodeList.add(pactionNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new8() /* reduce AEqComparison */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PComparison pcomparisonNode1;
        {
            // Block
        PValue pvalueNode2;
        PValue pvalueNode3;
        pvalueNode2 = (PValue)nodeArrayList1.get(0);
        pvalueNode3 = (PValue)nodeArrayList3.get(0);

        pcomparisonNode1 = new ABopEqComparison(pvalueNode2, pvalueNode3);
        }
	nodeList.add(pcomparisonNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new9() /* reduce ANeqComparison */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PComparison pcomparisonNode1;
        {
            // Block
        PValue pvalueNode2;
        PValue pvalueNode3;
        pvalueNode2 = (PValue)nodeArrayList1.get(0);
        pvalueNode3 = (PValue)nodeArrayList3.get(0);

        pcomparisonNode1 = new ABopNeqComparison(pvalueNode2, pvalueNode3);
        }
	nodeList.add(pcomparisonNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new10() /* reduce ALtComparison */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PComparison pcomparisonNode1;
        {
            // Block
        PValue pvalueNode2;
        PValue pvalueNode3;
        pvalueNode2 = (PValue)nodeArrayList1.get(0);
        pvalueNode3 = (PValue)nodeArrayList3.get(0);

        pcomparisonNode1 = new ABopLtComparison(pvalueNode2, pvalueNode3);
        }
	nodeList.add(pcomparisonNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new11() /* reduce AGtComparison */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PComparison pcomparisonNode1;
        {
            // Block
        PValue pvalueNode2;
        PValue pvalueNode3;
        pvalueNode2 = (PValue)nodeArrayList1.get(0);
        pvalueNode3 = (PValue)nodeArrayList3.get(0);

        pcomparisonNode1 = new ABopGtComparison(pvalueNode2, pvalueNode3);
        }
	nodeList.add(pcomparisonNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new12() /* reduce ALteqComparison */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PComparison pcomparisonNode1;
        {
            // Block
        PValue pvalueNode2;
        PValue pvalueNode3;
        pvalueNode2 = (PValue)nodeArrayList1.get(0);
        pvalueNode3 = (PValue)nodeArrayList3.get(0);

        pcomparisonNode1 = new ABopLteqComparison(pvalueNode2, pvalueNode3);
        }
	nodeList.add(pcomparisonNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new13() /* reduce AGteqComparison */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PComparison pcomparisonNode1;
        {
            // Block
        PValue pvalueNode2;
        PValue pvalueNode3;
        pvalueNode2 = (PValue)nodeArrayList1.get(0);
        pvalueNode3 = (PValue)nodeArrayList3.get(0);

        pcomparisonNode1 = new ABopGteqComparison(pvalueNode2, pvalueNode3);
        }
	nodeList.add(pcomparisonNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new14() /* reduce APlayCommand */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList4 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PAction pactionNode1;
        {
            // Block
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode2 = new LinkedList();
        listNode2 = (LinkedList)nodeArrayList3.get(0);
	if(listNode2 != null)
	{
	  listNode3.addAll(listNode2);
	}
        }

        pactionNode1 = new APlayAction(listNode3);
        }
	nodeList.add(pactionNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new15() /* reduce AJumpCommand */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList4 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PAction pactionNode1;
        {
            // Block
        TIdentifier tidentifierNode2;
        tidentifierNode2 = (TIdentifier)nodeArrayList3.get(0);

        pactionNode1 = new AJumpAction(tidentifierNode2);
        }
	nodeList.add(pactionNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new16() /* reduce AGameCommand */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList4 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PAction pactionNode1;
        {
            // Block
        TInteger tintegerNode2;
        tintegerNode2 = (TInteger)nodeArrayList3.get(0);

        pactionNode1 = new AGameAction(tintegerNode2);
        }
	nodeList.add(pactionNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new17() /* reduce ATextFileName */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PFileName pfilenameNode1;
        {
            // Block
        TIdentifier tidentifierNode2;
        tidentifierNode2 = (TIdentifier)nodeArrayList1.get(0);

        pfilenameNode1 = new ATextFileName(tidentifierNode2);
        }
	nodeList.add(pfilenameNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new18() /* reduce ANumberFileName */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PFileName pfilenameNode1;
        {
            // Block
        TInteger tintegerNode2;
        tintegerNode2 = (TInteger)nodeArrayList1.get(0);

        pfilenameNode1 = new AOidFileName(tintegerNode2);
        }
	nodeList.add(pfilenameNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new19() /* reduce ASingleFileList */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        LinkedList listNode2 = new LinkedList();
        {
            // Block
        PFileName pfilenameNode1;
        pfilenameNode1 = (PFileName)nodeArrayList1.get(0);
	if(pfilenameNode1 != null)
	{
	  listNode2.add(pfilenameNode1);
	}
        }
	nodeList.add(listNode2);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new20() /* reduce AMultipleFileList */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        PFileName pfilenameNode1;
        LinkedList listNode2 = new LinkedList();
        pfilenameNode1 = (PFileName)nodeArrayList1.get(0);
        listNode2 = (LinkedList)nodeArrayList3.get(0);
	if(pfilenameNode1 != null)
	{
	  listNode3.add(pfilenameNode1);
	}
	if(listNode2 != null)
	{
	  listNode3.addAll(listNode2);
	}
        }
	nodeList.add(listNode3);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new21() /* reduce ASetAssignment */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PAction pactionNode1;
        {
            // Block
        PValue pvalueNode2;
        PValue pvalueNode3;
        pvalueNode2 = (PValue)nodeArrayList1.get(0);
        pvalueNode3 = (PValue)nodeArrayList3.get(0);

        pactionNode1 = new ASetAction(pvalueNode2, pvalueNode3);
        }
	nodeList.add(pactionNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new22() /* reduce APlusAssignment */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PAction pactionNode1;
        {
            // Block
        PValue pvalueNode2;
        PValue pvalueNode3;
        pvalueNode2 = (PValue)nodeArrayList1.get(0);
        pvalueNode3 = (PValue)nodeArrayList3.get(0);

        pactionNode1 = new APlusAction(pvalueNode2, pvalueNode3);
        }
	nodeList.add(pactionNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new23() /* reduce AMinusAssignment */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList3 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PAction pactionNode1;
        {
            // Block
        PValue pvalueNode2;
        PValue pvalueNode3;
        pvalueNode2 = (PValue)nodeArrayList1.get(0);
        pvalueNode3 = (PValue)nodeArrayList3.get(0);

        pactionNode1 = new AMinusAction(pvalueNode2, pvalueNode3);
        }
	nodeList.add(pactionNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new24() /* reduce AValueTerm */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PValue pvalueNode1;
        {
            // Block
        TInteger tintegerNode2;
        tintegerNode2 = (TInteger)nodeArrayList1.get(0);

        pvalueNode1 = new ANumberValue(tintegerNode2);
        }
	nodeList.add(pvalueNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new25() /* reduce AVariableTerm */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PValue pvalueNode1;
        pvalueNode1 = (PValue)nodeArrayList1.get(0);
	nodeList.add(pvalueNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new26() /* reduce AVariableLocation */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PValue pvalueNode1;
        {
            // Block
        TIdentifier tidentifierNode2;
        tidentifierNode2 = (TIdentifier)nodeArrayList2.get(0);

        pvalueNode1 = new AVariableValue(tidentifierNode2);
        }
	nodeList.add(pvalueNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new27() /* reduce ARegisterLocation */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        PValue pvalueNode1;
        {
            // Block
        TInteger tintegerNode2;
        tintegerNode2 = (TInteger)nodeArrayList2.get(0);

        pvalueNode1 = new ARegisterValue(tintegerNode2);
        }
	nodeList.add(pvalueNode1);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new28() /* reduce ATerminal$Action */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        LinkedList listNode2 = new LinkedList();
        {
            // Block
        PAction pactionNode1;
        pactionNode1 = (PAction)nodeArrayList1.get(0);
	if(pactionNode1 != null)
	{
	  listNode2.add(pactionNode1);
	}
        }
	nodeList.add(listNode2);
        return nodeList;
    }



    @SuppressWarnings("unchecked")
    ArrayList new29() /* reduce ANonTerminal$Action */
    {
        @SuppressWarnings("hiding") ArrayList nodeList = new ArrayList();

        @SuppressWarnings("unused") ArrayList nodeArrayList2 = pop();
        @SuppressWarnings("unused") ArrayList nodeArrayList1 = pop();
        LinkedList listNode3 = new LinkedList();
        {
            // Block
        LinkedList listNode1 = new LinkedList();
        PAction pactionNode2;
        listNode1 = (LinkedList)nodeArrayList1.get(0);
        pactionNode2 = (PAction)nodeArrayList2.get(0);
	if(listNode1 != null)
	{
	  listNode3.addAll(listNode1);
	}
	if(pactionNode2 != null)
	{
	  listNode3.add(pactionNode2);
	}
        }
	nodeList.add(listNode3);
        return nodeList;
    }



    private static int[][][] actionTable;
/*      {
			{{-1, ERROR, 0}, {31, SHIFT, 1}, {33, SHIFT, 2}, {34, SHIFT, 3}, {35, SHIFT, 4}, {36, SHIFT, 5}, },
			{{-1, ERROR, 1}, {39, SHIFT, 15}, {40, SHIFT, 16}, },
			{{-1, ERROR, 2}, {20, SHIFT, 17}, },
			{{-1, ERROR, 3}, {20, SHIFT, 18}, },
			{{-1, REDUCE, 7}, },
			{{-1, ERROR, 5}, {20, SHIFT, 19}, },
			{{-1, ERROR, 6}, {41, ACCEPT, -1}, },
			{{-1, REDUCE, 28}, },
			{{-1, ERROR, 8}, {32, SHIFT, 20}, },
			{{-1, REDUCE, 4}, },
			{{-1, REDUCE, 5}, },
			{{-1, REDUCE, 6}, },
			{{-1, REDUCE, 3}, },
			{{-1, ERROR, 13}, {0, SHIFT, 21}, {1, SHIFT, 22}, {5, SHIFT, 23}, {12, SHIFT, 24}, {13, SHIFT, 25}, {14, SHIFT, 26}, {15, SHIFT, 27}, {16, SHIFT, 28}, {17, SHIFT, 29}, },
			{{-1, REDUCE, 2}, {31, SHIFT, 1}, {33, SHIFT, 2}, {34, SHIFT, 3}, {35, SHIFT, 4}, {36, SHIFT, 5}, },
			{{-1, REDUCE, 26}, },
			{{-1, REDUCE, 27}, },
			{{-1, ERROR, 17}, {39, SHIFT, 32}, {40, SHIFT, 33}, },
			{{-1, ERROR, 18}, {39, SHIFT, 36}, },
			{{-1, ERROR, 19}, {40, SHIFT, 37}, },
			{{-1, REDUCE, 1}, {31, SHIFT, 1}, {33, SHIFT, 2}, {34, SHIFT, 3}, {35, SHIFT, 4}, {36, SHIFT, 5}, },
			{{-1, ERROR, 21}, {31, SHIFT, 1}, {40, SHIFT, 39}, },
			{{-1, ERROR, 22}, {31, SHIFT, 1}, {40, SHIFT, 39}, },
			{{-1, ERROR, 23}, {31, SHIFT, 1}, {40, SHIFT, 39}, },
			{{-1, ERROR, 24}, {31, SHIFT, 1}, {40, SHIFT, 39}, },
			{{-1, ERROR, 25}, {31, SHIFT, 1}, {40, SHIFT, 39}, },
			{{-1, ERROR, 26}, {31, SHIFT, 1}, {40, SHIFT, 39}, },
			{{-1, ERROR, 27}, {31, SHIFT, 1}, {40, SHIFT, 39}, },
			{{-1, ERROR, 28}, {31, SHIFT, 1}, {40, SHIFT, 39}, },
			{{-1, ERROR, 29}, {31, SHIFT, 1}, {40, SHIFT, 39}, },
			{{-1, REDUCE, 29}, },
			{{-1, ERROR, 31}, {0, SHIFT, 21}, {1, SHIFT, 22}, {5, SHIFT, 23}, },
			{{-1, REDUCE, 17}, },
			{{-1, REDUCE, 18}, },
			{{-1, REDUCE, 19}, {30, SHIFT, 50}, },
			{{-1, ERROR, 35}, {21, SHIFT, 51}, },
			{{-1, ERROR, 36}, {21, SHIFT, 52}, },
			{{-1, ERROR, 37}, {21, SHIFT, 53}, },
			{{-1, REDUCE, 0}, },
			{{-1, REDUCE, 24}, },
			{{-1, REDUCE, 22}, },
			{{-1, REDUCE, 25}, },
			{{-1, REDUCE, 23}, },
			{{-1, REDUCE, 21}, },
			{{-1, REDUCE, 8}, },
			{{-1, REDUCE, 12}, },
			{{-1, REDUCE, 13}, },
			{{-1, REDUCE, 10}, },
			{{-1, REDUCE, 11}, },
			{{-1, REDUCE, 9}, },
			{{-1, ERROR, 50}, {39, SHIFT, 32}, {40, SHIFT, 33}, },
			{{-1, REDUCE, 14}, },
			{{-1, REDUCE, 15}, },
			{{-1, REDUCE, 16}, },
			{{-1, REDUCE, 20}, },
        };*/
    private static int[][][] gotoTable;
/*      {
			{{-1, 6}, {20, 38}, },
			{{-1, 7}, {14, 30}, },
			{{-1, 8}, },
			{{-1, 9}, },
			{{-1, 10}, },
			{{-1, 11}, },
			{{-1, 34}, },
			{{-1, 35}, {50, 54}, },
			{{-1, 12}, },
			{{-1, 40}, {22, 42}, {23, 43}, {24, 44}, {25, 45}, {26, 46}, {27, 47}, {28, 48}, {29, 49}, },
			{{-1, 41}, {0, 13}, {14, 31}, {20, 13}, },
			{{-1, 14}, },
        };*/
    private static String[] errorMessages;
/*      {
			"expecting: '$', 'P', 'J', 'C', 'G'",
			"expecting: identifier, integer",
			"expecting: '('",
			"expecting: '$', 'P', 'J', 'C', 'G', EOF",
			"expecting: EOF",
			"expecting: '?'",
			"expecting: '+=', '-=', ':=', '==', '<=', '>=', '<', '>', '!='",
			"expecting: '+=', '-=', ':=', '==', '<=', '>=', '<', '>', '!=', '$', '?', 'P', 'J', 'C', 'G', EOF",
			"expecting: identifier",
			"expecting: integer",
			"expecting: '$', integer",
			"expecting: '+=', '-=', ':='",
			"expecting: ')', ','",
			"expecting: ')'",
			"expecting: '$', '?', 'P', 'J', 'C', 'G', EOF",
        };*/
    private static int[] errors;
/*      {
			0, 1, 2, 2, 3, 2, 4, 3, 5, 3, 3, 3, 3, 6, 3, 7, 7, 1, 8, 9, 3, 10, 10, 10, 10, 10, 10, 10, 10, 10, 3, 11, 12, 12, 12, 13, 13, 13, 4, 14, 3, 14, 3, 3, 5, 5, 5, 5, 5, 5, 1, 3, 3, 3, 13, 
        };*/

    static 
    {
        try
        {
            DataInputStream s = new DataInputStream(
                new BufferedInputStream(
                Parser.class.getResourceAsStream("parser.dat")));

            // read actionTable
            int length = s.readInt();
            Parser.actionTable = new int[length][][];
            for(int i = 0; i < Parser.actionTable.length; i++)
            {
                length = s.readInt();
                Parser.actionTable[i] = new int[length][3];
                for(int j = 0; j < Parser.actionTable[i].length; j++)
                {
                for(int k = 0; k < 3; k++)
                {
                    Parser.actionTable[i][j][k] = s.readInt();
                }
                }
            }

            // read gotoTable
            length = s.readInt();
            gotoTable = new int[length][][];
            for(int i = 0; i < gotoTable.length; i++)
            {
                length = s.readInt();
                gotoTable[i] = new int[length][2];
                for(int j = 0; j < gotoTable[i].length; j++)
                {
                for(int k = 0; k < 2; k++)
                {
                    gotoTable[i][j][k] = s.readInt();
                }
                }
            }

            // read errorMessages
            length = s.readInt();
            errorMessages = new String[length];
            for(int i = 0; i < errorMessages.length; i++)
            {
                length = s.readInt();
                StringBuffer buffer = new StringBuffer();

                for(int j = 0; j < length; j++)
                {
                buffer.append(s.readChar());
                }
                errorMessages[i] = buffer.toString();
            }

            // read errors
            length = s.readInt();
            errors = new int[length];
            for(int i = 0; i < errors.length; i++)
            {
                errors[i] = s.readInt();
            }

            s.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException("The file \"parser.dat\" is either missing or corrupted.");
        }
    }
}
