/*
    Copyright (C) 2015   Jesper Zedlitz <jesper@zedlitz.de>
  
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
  
*/
package tingeltangel.core.scripting;

import org.junit.Test;
import tingeltangel.core.Entry;
import tingeltangel.core.Script;

import static org.junit.Assert.assertEquals;

public class DisassemblerTest {

    private Entry entry = new Entry(null, 15001);

    private Disassembler d = new Disassembler();

    @Test
    public void testDisassemble() throws Exception {
        String expectedCode = "set v3,1\n" +
                "playoid 15001\n" +
                "end\n";

        Script script = new Script(expectedCode, entry);

        byte[] binary = script.compile();

        String result = d.disassemble(binary);

        assertEquals("Correctly disassembled code", expectedCode, result);
    }

    @Test
    public void testDisassemble_2() throws Exception {
        String expectedCode = "cmp v3,0\n" +
                "je l1\n" +
                "cmp v3,1\n" +
                "je l2\n" +
                "cmp v3,2\n" +
                "je l3\n" +
                "end\n" +
                "\n" +
                ":l1\n" +
                "playoid 15001\n" +
                "end\n" +
                "\n" +
                ":l2\n" +
                "playoid 15002\n" +
                "end\n" +
                "\n" +
                ":l3\n" +
                "playoid 15004\n" +
                "end\n";

        Script script = new Script(expectedCode, entry);

        byte[] binary = script.compile();

        String result = d.disassemble(binary);

        assertEquals("Correctly disassembled code", expectedCode, result);
    }

    @Test
    public void testDisassemble_3() throws Exception {
        byte[] binary = new byte[] {0x02,0x01,0x00,0x01,0x00,30,0x16,0x01,58,-103,0x17,0x02,0,1,0x16,0x01,58,-102,0,0,0};
        String result = d.disassemble(binary);
    }
    
    @Test
    public void testDisassemble_4() throws Exception {
        // taken from MID=05289
        int[] bin = new int[] {
                0x03, 0x01, 0x00, 0x50, 0x00, 0x0e,     // cmp v80, 14
                0x0a, 0x00, 0x00, 0x18,                 // jne 0x0018
                0x03, 0x01, 0x00, 0x46, 0x00, 0x0e,     // cmp v70, 14
                0x09, 0x00, 0x00, 0x28,                 // je 0x0028
                0x08, 0x00, 0x00, 0x20,                 // jmp 0x0020
                0x01, 0x00,                             // clearver
                0x02, 0x01, 0x00, 0x50, 0x00, 0x0e,     // set v80, 14
                0x16, 0x01, 0xb0, 0xe2,                 // playoid 45282
                0x08, 0x00, 0x01, 0x2a,                 // jmp 0x012a
                0x02, 0x01, 0x00, 0x16, 0x00, 0x01,     // set v22, 1
                0x03, 0x02, 0x00, 0x16, 0x00, 0x02,     // cmp v22, v2
                0x09, 0x00, 0x00, 0x44,                 // je 0x0044
                0x16, 0x01, 0x7d, 0x00,                 // playoid 32000
                0x16, 0x01, 0xb1, 0xbe,                 // playoid 45502
                            0x08, 0x00, 0x01, 0x2a, 0x02, 0x01, 0x00, 0x15, 0x00, 0x00, 0x02, 0x01, 0x00, 0x16, 0x00, 0x00,
                            0x02, 0x01, 0x00, 0x17, 0x00, 0x00, 0x02, 0x01, 0x00, 0x18, 0x00, 0x00, 0x02, 0x01, 0x00, 0x19,
                            0x00, 0x00, 0x02, 0x01, 0x00, 0x1a, 0x00, 0x00, 0x02, 0x01, 0x00, 0x1b, 0x00, 0x00, 0x02, 0x01,
                            0x00, 0x1c, 0x00, 0x00, 0x02, 0x01, 0x00, 0x1d, 0x00, 0x00, 0x02, 0x01, 0x00, 0x1e, 0x00, 0x00,
                            0x02, 0x01, 0x00, 0x1f, 0x00, 0x00, 0x02, 0x01, 0x00, 0x20, 0x00, 0x00, 0x03, 0x01, 0x00, 0x2a,
                            0x00, 0x01, 0x09, 0x00, 0x01, 0x02, 0x02, 0x01, 0x00, 0x2a, 0x00, 0x01, 0x0f, 0x01, 0x00, 0x47,
                            0x00, 0x01, 0x03, 0x01, 0x00, 0x47, 0x00, 0x0c, 0x09, 0x00, 0x00, 0xf4, 0x02, 0x02, 0x00, 0x3c,
                            0x00, 0x62, 0x03, 0x01, 0x00, 0x3c, 0x2e, 0x93, 0x0e, 0x00, 0x00, 0xd0, 0x03, 0x01, 0x00, 0x3c,
                            0x55, 0x56, 0x0e, 0x00, 0x00, 0xdc, 0x03, 0x01, 0x00, 0x3c, 0x80, 0x00, 0x0e, 0x00, 0x00, 0xe8,
                            0x16, 0x01, 0x80, 0xe8, 0x16, 0x01, 0xb1, 0xbb, 0x08, 0x00, 0x01, 0x2a, 0x16, 0x01, 0x80, 0xe8,
                            0x16, 0x01, 0xb1, 0xbc, 0x08, 0x00, 0x01, 0x2a, 0x16, 0x01, 0x80, 0xe8, 0x16, 0x01, 0xb1, 0xbd,
                            0x08, 0x00, 0x01, 0x2a, 0x16, 0x01, 0x80, 0xe8, 0x16, 0x01, 0xb1, 0xc9, 0x01, 0x00, 0x08, 0x00,
                            0x01, 0x2a, 0x02, 0x02, 0x00, 0x3c, 0x00, 0x62, 0x03, 0x01, 0x00, 0x3c, 0x2e, 0x93, 0x0e, 0x00,
                            0x00, 0xd0, 0x03, 0x01, 0x00, 0x3c, 0x55, 0x56, 0x0e, 0x00, 0x00, 0xdc, 0x03, 0x01, 0x00, 0x3c,
                            0x80, 0x00, 0x0e, 0x00, 0x00, 0xe8, 0x08, 0x00, 0x01, 0x2a, 0x00, 0x00, 0x00}; 
        byte[] binary = new byte[bin.length];
        for(int i = 0; i < bin.length; i++) {
            binary[i] = (byte)bin[i];
        }
    
        String result = d.disassemble(binary);
        //System.out.println(result);
    }
    
    @Test
    public void testDisassemble_5() throws Exception {
        String source = "jmp l1\n\n:l2\nend\n\n:l1\njmp l2\n";
        Script script = new Script(source, entry);
        byte[] binary = script.compile();
        String result = d.disassemble(binary);
        assertEquals("Correctly disassembled code", source, result);
    }
}
