/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import tingeltangel.core.Book;
import tingeltangel.core.Entry;
import tingeltangel.core.MP3Player;
import tingeltangel.gui.IndexListEntry;
import tingeltangel.gui.MasterFrame;
import tingeltangel.gui.PushBorderLayout;
import tingeltangel.gui.RegisterPanel;

public final class IndexPanel
extends JPanel {
    private JTextField id = new JTextField();
    private JTextField name = new JTextField();
    private JTextField publisher = new JTextField();
    private JTextField author = new JTextField();
    private JTextField version = new JTextField();
    private JTextField url = new JTextField();
    private JTextField magicValue = new JTextField();
    private JTextField date = new JTextField();
    private final int ICON_SKIP = 0;
    private final int ICON_STOP = 1;
    private final String[] ICONS = new String[]{"skip.png", "stop.png"};
    JTextField[] TEXT_FIELDS = new JTextField[]{this.id, this.name, this.publisher, this.author, this.version, this.url, this.magicValue, this.date};
    String[] TEXT_FIELD_LABELS = new String[]{"ID", "Name", "Verleger", "Autor", "Version", "URL", "?", "Datum"};
    private final JTextField addEntriesCount;
    private final JTextField addEntriesStart;
    private final MasterFrame mainFrame;
    private final JLabel currentTrack = new JLabel();
    private final JPanel list = new JPanel();
    private DocumentListener dl;

    public Book getBook() {
        return this.mainFrame.getBook();
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }

    public IndexPanel(final MasterFrame mainFrame) {
        this.mainFrame = mainFrame;
        JPanel right = new JPanel();
        right.setLayout(new PushBorderLayout());
        JPanel row = new JPanel();
        row.setLayout(new PushBorderLayout());
        this.addEntriesCount = new JTextField(3);
        this.addEntriesCount.setText("1");
        this.addEntriesStart = new JTextField(5);
        this.addEntriesStart.setText("15001");
        row.add((Component)this.addEntriesCount, (Object)PushBorderLayout.LINE_START);
        row.add((Component)new JLabel("Eintr\u00e4ge ab OID"), (Object)PushBorderLayout.LINE_START);
        row.add((Component)this.addEntriesStart, (Object)PushBorderLayout.LINE_START);
        JButton addEntriesButton = new JButton("hinzuf\u00fcgen");
        addEntriesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int i;
                int count;
                int oid;
                String _oid = IndexPanel.this.addEntriesStart.getText().trim();
                String _count = IndexPanel.this.addEntriesCount.getText().trim();
                try {
                    oid = Integer.parseInt(_oid);
                    if (oid < 15001 || oid >= 65536) {
                        JOptionPane.showMessageDialog(mainFrame, "ung\u00fcltige OID angegeben (15001 bis 65535)");
                        return;
                    }
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(mainFrame, "ung\u00fcltige OID angegeben (15001 bis 65535)");
                    return;
                }
                try {
                    count = Integer.parseInt(_count);
                    if (count < 1 || count >= 1000) {
                        JOptionPane.showMessageDialog(mainFrame, "ung\u00fcltige Anzahl angegeben (1-999)");
                        return;
                    }
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(mainFrame, "ung\u00fcltige Anzahl angegeben (1-999)");
                    return;
                }
                int lastOid = oid + count - 1;
                if (lastOid >= 65536) {
                    JOptionPane.showMessageDialog(mainFrame, "ung\u00fcltiges OID Interval angegeben (max 65535)");
                    return;
                }
                for (i = oid; i <= lastOid; ++i) {
                    if (!mainFrame.getBook().entryForTingIDExists(i)) continue;
                    JOptionPane.showMessageDialog(mainFrame, "OID " + i + " schon belegt");
                    return;
                }
                for (i = oid; i <= lastOid; ++i) {
                    mainFrame.getBook().addEntry(i);
                    int rowNr = IndexPanel.this.getPositionInIndex(i);
                    IndexPanel.this.list.add((Component)new IndexListEntry(mainFrame.getBook().getEntryFromTingID(i), IndexPanel.this), rowNr);
                }
                new Thread(){

                    @Override
                    public void run() {
                        IndexPanel.this.list.revalidate();
                        IndexPanel.this.list.repaint();
                    }
                }.start();
            }
        });
        row.add((Component)addEntriesButton, (Object)PushBorderLayout.LINE_START);
        right.add((Component)row, (Object)PushBorderLayout.PAGE_START);
        right.add(PushBorderLayout.pad(10), (Object)PushBorderLayout.PAGE_START);
        row = new JPanel();
        row.setLayout(new PushBorderLayout());
        JButton skip = new JButton(this.getIcon(0));
        skip.setMargin(new Insets(0, 0, 0, 0));
        skip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MP3Player.getPlayer().stop();
            }
        });
        row.add((Component)skip, (Object)PushBorderLayout.LINE_START);
        row.add(PushBorderLayout.pad(5), (Object)PushBorderLayout.LINE_START);
        JButton stop = new JButton(this.getIcon(1));
        stop.setMargin(new Insets(0, 0, 0, 0));
        stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                IndexPanel.this.stopTrack();
            }
        });
        row.add((Component)stop, (Object)PushBorderLayout.LINE_START);
        row.add(PushBorderLayout.pad(5), (Object)PushBorderLayout.LINE_START);
        row.add((Component)new JLabel("Track:"), (Object)PushBorderLayout.LINE_START);
        row.add(PushBorderLayout.pad(5), (Object)PushBorderLayout.LINE_START);
        row.add((Component)this.currentTrack, (Object)PushBorderLayout.LINE_START);
        right.add((Component)row, (Object)PushBorderLayout.PAGE_START);
        right.add(PushBorderLayout.pad(10), (Object)PushBorderLayout.PAGE_START);
        row = new JPanel();
        JPanel labels = new JPanel();
        labels.setLayout(new GridLayout(this.TEXT_FIELD_LABELS.length, 1));
        for (int i = 0; i < this.TEXT_FIELD_LABELS.length; ++i) {
            labels.add(new JLabel(this.TEXT_FIELD_LABELS[i] + ":"));
        }
        JPanel fields = new JPanel();
        fields.setLayout(new GridLayout(this.TEXT_FIELDS.length, 1));
        for (int i = 0; i < this.TEXT_FIELDS.length; ++i) {
            fields.add(this.TEXT_FIELDS[i]);
        }
        row.setLayout(new BorderLayout());
        row.add((Component)labels, "West");
        row.add((Component)fields, "Center");
        row.add((Component)new JLabel("Bucheigenschaften"), "North");
        right.add((Component)row, (Object)PushBorderLayout.PAGE_START);
        right.add(PushBorderLayout.pad(10), (Object)PushBorderLayout.PAGE_START);
        right.add((Component)new JLabel("Register"), (Object)PushBorderLayout.PAGE_START);
        RegisterPanel registerPanel = new RegisterPanel(mainFrame);
        this.getBook().addRegisterListener(registerPanel);
        right.add((Component)registerPanel, (Object)PushBorderLayout.CENTER);
        this.list.setLayout(new BoxLayout(this.list, 1));
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.list), "Center");
        this.add((Component)right, "East");
        this.updateList();
        Book book = mainFrame.getBook();
        this.id.setText(Integer.toString(book.getID()));
        this.name.setText(book.getName());
        this.publisher.setText(book.getPublisher());
        this.author.setText(book.getAuthor());
        this.version.setText(Integer.toString(book.getVersion()));
        this.url.setText(book.getUrl());
        this.magicValue.setText(Long.toString(book.getMagicValue()));
        this.date.setText(Long.toString(book.getDate()));
        this.id.setEditable(false);
        this.dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                IndexPanel.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                IndexPanel.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                IndexPanel.this.update();
            }
        };
        this.enableListeners(true);
    }

    public void stopTrack() {
        String tid = this.currentTrack.getText();
        if (!tid.isEmpty()) {
            Entry entry = this.mainFrame.getBook().getEntryFromTingID(Integer.parseInt(tid));
            if (entry.isCode()) {
                entry.getScript().kill();
            }
            if (entry.isMP3() || entry.isTTS() || entry.isCode()) {
                MP3Player.getPlayer().stop();
            }
        }
    }

    private ImageIcon getIcon(int res) {
        try {
            return new ImageIcon(ImageIO.read(this.getClass().getResource("/icons/" + this.ICONS[res])));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int getPositionInIndex(int oid) {
        int rowNr = -1;
        for (int i = 0; i < this.list.getComponentCount(); ++i) {
            int ioid = ((IndexListEntry)this.list.getComponent(i)).getOID();
            if (ioid <= oid) continue;
            rowNr = i;
            break;
        }
        if (rowNr < 0) {
            return 0;
        }
        return rowNr;
    }

    public int getPositionInIndex(IndexListEntry entry) {
        int rowNr = -1;
        for (int i = 0; i < this.list.getComponentCount(); ++i) {
            if (this.list.getComponent(i) != entry) continue;
            rowNr = i;
            break;
        }
        if (rowNr < 0) {
            throw new Error();
        }
        return rowNr;
    }

    JPanel getListPanel() {
        return this.list;
    }

    private void enableListeners(boolean enable) {
        for (int i = 0; i < this.TEXT_FIELDS.length; ++i) {
            if (enable) {
                this.TEXT_FIELDS[i].getDocument().addDocumentListener(this.dl);
                continue;
            }
            this.TEXT_FIELDS[i].getDocument().removeDocumentListener(this.dl);
        }
    }

    public void refresh() {
        this.enableListeners(false);
        Book book = this.mainFrame.getBook();
        this.id.setText(Integer.toString(book.getID()));
        this.name.setText(book.getName());
        this.publisher.setText(book.getPublisher());
        this.author.setText(book.getAuthor());
        this.version.setText(Integer.toString(book.getVersion()));
        this.url.setText(book.getUrl());
        this.magicValue.setText(Long.toString(book.getMagicValue()));
        this.date.setText(Long.toString(book.getDate()));
        this.enableListeners(true);
    }

    public void update() {
        Book book = this.mainFrame.getBook();
        book.setName(this.name.getText());
        book.setPublisher(this.publisher.getText());
        book.setAuthor(this.author.getText());
        try {
            book.setVersion(Integer.parseInt(this.version.getText()));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        book.setURL(this.url.getText());
        try {
            book.setMagicValue(Long.parseLong(this.magicValue.getText()));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        try {
            book.setDate(Long.parseLong(this.date.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void updateList() {
        this.update();
        Book book = this.mainFrame.getBook();
        this.list.removeAll();
        for (int i = 0; i < book.getSize(); ++i) {
            this.list.add(new IndexListEntry(book.getEntry(i), this));
        }
        Dimension size = this.mainFrame.getSize();
        this.mainFrame.pack();
        this.mainFrame.setSize(size);
    }

    void setCurrentTrack(Entry entry) {
        if (entry == null) {
            this.currentTrack.setText(null);
        } else {
            this.currentTrack.setText(Integer.toString(entry.getTingID()));
        }
    }
}

