/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import tingeltangel.core.Entry;
import tingeltangel.core.MP3Player;
import tingeltangel.core.scripting.SyntaxError;
import tingeltangel.gui.IndexPanel;
import tingeltangel.gui.MultipleChoiceDialog;
import tingeltangel.tools.Callback;
import tingeltangel.tools.Lang;

public class IndexListEntry
extends JPanel {
    private final int ICON_MP3 = 0;
    private final int ICON_SCRIPT = 1;
    private final int ICON_SUB_SCRIPT = 2;
    private final int ICON_TTS = 3;
    private final int ICON_PLAY = 4;
    private final int ICON_EJECT = 5;
    private final int ICON_TEST = 6;
    private final int ICON_DELETE = 7;
    private final int ICON_SAVE_PATTERN = 8;
    private final int ICON_COPY_PATTERN = 9;
    private final String[] ICONS = new String[]{"mp3.png", "code.png", "sub.png", "tts.png", "play.png", "eject.png", "compile.png", "delete.png", "save-code.png", "copy-code.png"};
    private static final String MP3 = "mp3";
    private static final String SCRIPT = "script";
    private static final String SUB = "sub";
    private static final String TTS = "tts";
    private String lastChooseMp3DialogPath = null;
    private JLabel trackInfo = new JLabel(" ");
    private final Entry entry;

    private ImageIcon getIcon(int res) {
        try {
            return new ImageIcon(ImageIO.read(this.getClass().getResource("/icons/" + this.ICONS[res])));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public IndexListEntry(final Entry entry, final IndexPanel frame) {
        this.entry = entry;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel header = new JPanel();
        header.setLayout(new BoxLayout(header, 1));
        JPanel row = new JPanel();
        JButton jboid = new JButton(Integer.toString(entry.getTingID()));
        jboid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
            }
        });
        row.add(jboid);
        int iconRes = -1;
        if (entry.isMP3()) {
            iconRes = 0;
        } else if (entry.isCode()) {
            iconRes = 1;
        } else if (entry.isSub()) {
            iconRes = 2;
        } else if (entry.isTTS()) {
            iconRes = 3;
        }
        JButton icon = new JButton(this.getIcon(iconRes));
        icon.setMargin(new Insets(0, 0, 0, 0));
        icon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String[] options = new String[]{Lang.get("indexFrame.dialog.mp3"), Lang.get("indexFrame.dialog.script"), Lang.get("indexFrame.dialog.sub"), Lang.get("indexFrame.dialog.tts")};
                String[] actions = new String[]{IndexListEntry.MP3, IndexListEntry.SCRIPT, IndexListEntry.SUB, IndexListEntry.TTS};
                Callback<String> callback = new Callback<String>(){

                    @Override
                    public void callback(String s) {
                        if (s.equals(IndexListEntry.MP3)) {
                            entry.setMP3();
                        } else if (s.equals(IndexListEntry.SCRIPT)) {
                            entry.setCode();
                        } else if (s.equals(IndexListEntry.SUB)) {
                            entry.setSub();
                        } else if (s.equals(IndexListEntry.TTS)) {
                            entry.setTTS();
                        }
                        new Thread(){

                            @Override
                            public void run() {
                                JPanel p = frame.getListPanel();
                                int rowNr = -1;
                                for (int i = 0; i < p.getComponentCount(); ++i) {
                                    if (p.getComponent(i) != IndexListEntry.this) continue;
                                    rowNr = i;
                                    break;
                                }
                                if (rowNr < 0) {
                                    throw new Error();
                                }
                                p.remove(IndexListEntry.this);
                                p.add((Component)new IndexListEntry(entry, frame), rowNr);
                                p.revalidate();
                                p.repaint();
                            }
                        }.start();
                    }
                };
                int preselection = -1;
                if (entry.isMP3()) {
                    preselection = 0;
                } else if (entry.isCode()) {
                    preselection = 1;
                } else if (entry.isSub()) {
                    preselection = 2;
                } else if (entry.isTTS()) {
                    preselection = 3;
                } else {
                    throw new Error();
                }
                MultipleChoiceDialog.show(frame.getMainFrame(), "Frage...", "Typ \u00e4ndern", "OK", options, actions, preselection, callback, 300, 300);
            }
        });
        row.add(icon);
        JButton delete = new JButton(this.getIcon(7));
        delete.setMargin(new Insets(0, 0, 0, 0));
        delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                entry.getBook().removeEntryByTingID(entry.getTingID());
                frame.stopTrack();
                new Thread(){

                    @Override
                    public void run() {
                        JPanel p = frame.getListPanel();
                        p.remove(IndexListEntry.this);
                        p.revalidate();
                        p.repaint();
                    }
                }.start();
            }
        });
        row.add(delete);
        JButton play = new JButton(this.getIcon(4));
        play.setMargin(new Insets(0, 0, 0, 0));
        play.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (!entry.isSub()) {
                    frame.setCurrentTrack(entry);
                }
                new Thread(){

                    @Override
                    public void run() {
                        if (entry.isMP3() && entry.getMP3() != null) {
                            try {
                                MP3Player.getPlayer().play(entry.getMP3(), new Callback<Exception>(){

                                    @Override
                                    public void callback(Exception t) {
                                        JOptionPane.showMessageDialog(frame, "Fehler bein Abspielen des MP3 (" + entry.getMP3().getAbsolutePath() + "): " + t.getMessage());
                                    }
                                });
                            }
                            catch (FileNotFoundException ex) {
                                JOptionPane.showMessageDialog(frame, "Fehler bein Abspielen des MP3: Die Datei " + entry.getMP3().getAbsolutePath() + " wurde nicht gefunden");
                            }
                        } else if (entry.isCode()) {
                            try {
                                entry.getScript().execute();
                            }
                            catch (SyntaxError se) {
                                JOptionPane.showMessageDialog(frame, "Syntax Fehler (OID " + se.getTingID() + " Zeile " + se.getRow() + "): " + se.getMessage());
                            }
                        } else if (entry.isTTS()) {
                            try {
                                File tts = entry.getTTS().generateTTS(entry);
                                frame.setCurrentTrack(entry);
                                MP3Player.getPlayer().play(tts, new Callback<Exception>(){

                                    @Override
                                    public void callback(Exception t) {
                                        JOptionPane.showMessageDialog(frame, "Es ist ein Fehelr aufgetreten: " + t.getMessage());
                                    }
                                });
                                frame.setCurrentTrack(null);
                            }
                            catch (IOException ioe) {
                                JOptionPane.showMessageDialog(frame, "Es ist ein Fehelr aufgetreten: " + ioe.getMessage());
                            }
                        }
                        System.out.println("track done");
                        frame.setCurrentTrack(null);
                    }
                }.start();
            }
        });
        row.add(play);
        if (entry.isMP3()) {
            JButton eject = new JButton(this.getIcon(5));
            eject.setMargin(new Insets(0, 0, 0, 0));
            eject.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    MP3Player.getPlayer().stop();
                    JFileChooser fc = new JFileChooser(IndexListEntry.this.lastChooseMp3DialogPath);
                    fc.setFileFilter(new FileNameExtensionFilter(IndexListEntry.MP3, IndexListEntry.MP3));
                    if (fc.showOpenDialog(frame) == 0) {
                        try {
                            File file = fc.getSelectedFile();
                            if (file.getParent() != null) {
                                IndexListEntry.this.lastChooseMp3DialogPath = file.getParent();
                            }
                            entry.setMP3(file);
                            IndexListEntry.this.trackInfo.setText(IndexListEntry.this.getTrackInfo(entry));
                        }
                        catch (FileNotFoundException ex) {
                            JOptionPane.showMessageDialog(frame, "Die Datei '" + fc.getSelectedFile() + "' konnte nicht gefunden werden.");
                            ex.printStackTrace(System.out);
                        }
                        catch (IOException ex) {
                            JOptionPane.showMessageDialog(frame, "Die Datei '" + fc.getSelectedFile() + "' konnte nicht gelesen werden.");
                            ex.printStackTrace(System.out);
                        }
                    }
                }
            });
            row.add(eject);
        } else if (entry.isCode() || entry.isSub()) {
            JButton compile = new JButton(this.getIcon(6));
            compile.setMargin(new Insets(0, 0, 0, 0));
            compile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    try {
                        entry.getScript().compile();
                        JOptionPane.showMessageDialog(frame, "Alles OK");
                    }
                    catch (SyntaxError se) {
                        JOptionPane.showMessageDialog(frame, "Syntax Fehler (OID " + se.getTingID() + " Zeile " + se.getRow() + "): " + se.getMessage());
                    }
                }
            });
            row.add(compile);
        }
        if (entry.isCode() || entry.isMP3() || entry.isTTS()) {
            JButton savePattern = new JButton(this.getIcon(8));
            savePattern.setMargin(new Insets(0, 0, 0, 0));
            savePattern.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                }
            });
            row.add(savePattern);
            JButton copyPattern = new JButton(this.getIcon(9));
            copyPattern.setMargin(new Insets(0, 0, 0, 0));
            copyPattern.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                }
            });
            row.add(copyPattern);
        }
        this.trackInfo.setText(this.getTrackInfo(entry));
        row.add(this.trackInfo);
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)row, "West");
        header.add(p);
        header.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.add((Component)header, "North");
        final JTextArea hint = new JTextArea();
        hint.setRows(1);
        if (entry.isCode() || entry.isSub()) {
            hint.setText(entry.getScript().toString());
        } else if (entry.isTTS()) {
            hint.setText(entry.getTTS().text);
        } else if (entry.isMP3()) {
            hint.setText(entry.getHint());
        }
        hint.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent de) {
                this.changedUpdate(de);
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                this.changedUpdate(de);
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
                if (entry.isCode() || entry.isSub()) {
                    entry.getScript().setCode(hint.getText());
                } else if (entry.isTTS()) {
                    entry.getTTS().text = hint.getText();
                } else if (entry.isMP3()) {
                    entry.setHint(hint.getText());
                }
            }
        });
        this.add((Component)hint, "Center");
    }

    public int getOID() {
        return this.entry.getTingID();
    }

    private String getTrackInfo(Entry entry) {
        if (entry.isMP3()) {
            int min = (int)entry.getLength() / 60;
            int sec = (int)entry.getLength() - min;
            String formatedTime = Integer.toString(sec);
            if (sec < 10) {
                formatedTime = "0" + formatedTime;
            }
            formatedTime = Integer.toString(min) + ":" + formatedTime;
            String trackName = "null";
            if (entry.getMP3() != null) {
                trackName = entry.getMP3().getName();
            } else {
                formatedTime = "-";
            }
            return trackName + " (" + formatedTime + ")";
        }
        return " ";
    }
}

