/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.core.scripting;

import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.LinkedList;
import tingeltangel.core.Book;
import tingeltangel.core.Entry;
import tingeltangel.core.MP3Player;
import tingeltangel.core.scripting.RegisterListener;
import tingeltangel.tools.Callback;

public class Emulator {
    private final LinkedList<RegisterListener> listeners = new LinkedList();
    public static final int REGISTERS = 99;
    private static final int[] register = new int[99];
    private static final String[] hints = new String[99];
    private int leftValue = 0;
    private int rightValue = 0;
    private final Book book;

    public Emulator(Book book) {
        this.book = book;
    }

    public int getLeftValue() {
        return this.leftValue;
    }

    public int getRightValue() {
        return this.rightValue;
    }

    public void setHint(int i, String hint) {
        Emulator.hints[i] = hint;
    }

    public String getHint(int i) {
        return hints[i];
    }

    public void setLeftValue(int value) {
        this.leftValue = value;
    }

    public void setRightValue(int value) {
        this.rightValue = value;
    }

    public int getMaxRegister() {
        return 98;
    }

    public int getRegister(int i) {
        return register[i];
    }

    public void setRegister(int i, int value) {
        int oval = register[i];
        Emulator.register[i] = value;
        if (oval != value) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                ((RegisterListener)it.next()).registerChanged(i, value);
            }
        }
        Emulator.register[i] = value;
    }

    public void play(int oid) {
        Entry entry = this.book.getEntryFromTingID(oid);
        if (entry.isMP3() && entry.getMP3() != null) {
            try {
                MP3Player.getPlayer().play(entry.getMP3(), new Callback<Exception>(){

                    @Override
                    public void callback(Exception t) {
                        t.printStackTrace();
                    }
                });
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void pause(int ms) {
        MP3Player.getPlayer().pause(ms);
    }

    public void addRegisterListener(RegisterListener listener) {
        this.listeners.add(listener);
    }

    static {
        for (int i = 0; i < hints.length; ++i) {
            Emulator.hints[i] = "";
        }
    }
}

