/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import tingeltangel.core.Entry;
import tingeltangel.core.Page;
import tingeltangel.core.Tupel;
import tingeltangel.gui.EntryListener;
import tingeltangel.gui.MasterFrame;
import tingeltangel.tools.FileEnvironment;

public class GfxEditFrame
extends JInternalFrame
implements EntryListener {
    private static final int SHRINK = 12;
    private MasterFrame masterFrame;
    private final JPanel canvas;
    private BufferedImage img = null;
    private int dx = 0;
    private int dy = 0;
    private int w = 0;
    private int h = 0;
    private double scale = 0.0;
    private Entry entry = null;
    private static final Color[] COLORS = new Color[1000];
    private JButton addPageButton;
    private JSpinner brushSizeSpinner;
    private JPanel colorPanel;
    private JToggleButton erasorToggleButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JButton loadImageButton;
    private JComboBox pagesComboBox;
    private JPanel panel;
    private JButton removePageButton;

    public GfxEditFrame(MasterFrame frame) {
        this.masterFrame = frame;
        this.initComponents();
        this.canvas = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (GfxEditFrame.this.img != null) {
                    int[][] raster = ((GfxEditFrame)GfxEditFrame.this).masterFrame.getBook().getPages().get((int)((GfxEditFrame)GfxEditFrame.this).pagesComboBox.getSelectedIndex()).raster;
                    if (raster == null) {
                        return;
                    }
                    g.drawImage(GfxEditFrame.this.img, GfxEditFrame.this.dx, GfxEditFrame.this.dy, GfxEditFrame.this.w, GfxEditFrame.this.h, null);
                    for (int x = 0; x < raster.length; ++x) {
                        for (int y = 0; y < raster[0].length; ++y) {
                            if (raster[x][y] == 0) continue;
                            Color color = COLORS[(raster[x][y] - 15001) % COLORS.length];
                            if (GfxEditFrame.this.entry != null && GfxEditFrame.this.entry.getTingID() == raster[x][y]) {
                                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 176);
                            }
                            g.setColor(color);
                            g.fillRect(GfxEditFrame.this.dx + (int)((double)(x * 12) / GfxEditFrame.this.scale), GfxEditFrame.this.dy + (int)((double)(y * 12) / GfxEditFrame.this.scale), 1, 1);
                        }
                    }
                }
            }
        };
        this.panel.setLayout(new GridLayout(1, 1));
        this.panel.add(this.canvas);
        this.canvas.setSize(this.panel.getWidth(), this.panel.getHeight());
        this.canvas.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (GfxEditFrame.this.entry != null) {
                    int[][] raster = ((GfxEditFrame)GfxEditFrame.this).masterFrame.getBook().getPages().get((int)((GfxEditFrame)GfxEditFrame.this).pagesComboBox.getSelectedIndex()).raster;
                    int x = e.getX() - GfxEditFrame.this.dx;
                    int y = e.getY() - GfxEditFrame.this.dy;
                    if (x >= 0 && x < GfxEditFrame.this.w && y >= 0 && y < GfxEditFrame.this.h) {
                        x = (int)((double)x * GfxEditFrame.this.scale) / 12;
                        y = (int)((double)y * GfxEditFrame.this.scale) / 12;
                        GfxEditFrame.this.circle(x, y, (Integer)GfxEditFrame.this.brushSizeSpinner.getValue(), GfxEditFrame.this.entry.getTingID(), raster);
                        raster[x][y] = GfxEditFrame.this.entry.getTingID();
                        GfxEditFrame.this.canvas.repaint();
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.pagesComboBox.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Tupel tupel = (Tupel)value;
                if (tupel == null) {
                    return new JLabel();
                }
                return new JLabel((Integer)tupel.a + 1 + " - " + (String)tupel.b);
            }
        });
        if (this.masterFrame.getBook().getPages().size() > 0) {
            try {
                this.showPage(this.masterFrame.getBook().getPages().get(0));
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Das Bild konnte nicht geladen werden");
                e.printStackTrace(System.out);
            }
        }
        frame.addEntryListener(this);
    }

    public void update() {
        DefaultComboBoxModel pagesModel = (DefaultComboBoxModel)this.pagesComboBox.getModel();
        pagesModel.removeAllElements();
        Iterator pages = this.masterFrame.getBook().getPages().iterator();
        int i = 0;
        while (pages.hasNext()) {
            Page page = (Page)pages.next();
            pagesModel.addElement(new Tupel<Integer, String>(i, page.image));
            ++i;
        }
    }

    private void circle(int x, int y, int r, int v, int[][] raster) {
        if (this.erasorToggleButton.isSelected()) {
            v = 0;
        }
        int rq = r * r;
        for (int ix = x - r; ix <= x + r; ++ix) {
            int ixq = (ix - x) * (ix - x);
            for (int iy = y - r; iy <= y + r; ++iy) {
                if (ixq + (iy - y) * (iy - y) > rq) continue;
                raster[ix][iy] = v;
            }
        }
    }

    private void showPage(Page page) throws IOException {
        if (page.image != null) {
            File pagesDirectory = FileEnvironment.getPagesDirectory(this.masterFrame.getBook().getID());
            this.img = ImageIO.read(new File(pagesDirectory, page.image));
            double panelAspect = (double)this.panel.getWidth() / (double)this.panel.getHeight();
            double imageAspect = (double)this.img.getWidth() / (double)this.img.getHeight();
            this.dx = 0;
            this.dy = 0;
            this.w = this.panel.getWidth();
            this.h = this.panel.getHeight();
            if (panelAspect > imageAspect) {
                this.w = (int)((double)this.h * imageAspect);
                this.dx = (this.panel.getWidth() - this.w) / 2;
                this.scale = (double)this.img.getHeight() / (double)this.h;
            } else {
                this.h = (int)((double)this.w / imageAspect);
                this.dy = (this.panel.getHeight() - this.h) / 2;
                this.scale = (double)this.img.getWidth() / (double)this.w;
            }
            if (page.raster == null) {
                File rasterFile = new File(pagesDirectory, page.image.substring(0, page.image.lastIndexOf(46)) + ".raster");
                if (rasterFile.canRead()) {
                    DataInputStream in = new DataInputStream(new FileInputStream(rasterFile));
                    int _w = in.readShort();
                    int _h = in.readShort();
                    if (_w != this.img.getWidth() / 12 || _h != this.img.getHeight() / 12) {
                        in.close();
                        throw new IOException("raster size missmatch (perhaps you sould delete '" + rasterFile.getCanonicalPath() + "')");
                    }
                    page.raster = new int[_w][_h];
                    for (int x = 0; x < _w; ++x) {
                        for (int y = 0; y < _h; ++y) {
                            page.raster[x][y] = in.readShort();
                        }
                    }
                    in.close();
                } else {
                    page.raster = new int[this.img.getWidth() / 12][this.img.getHeight() / 12];
                }
            }
        }
    }

    private void loadAndShowImage(File file) throws IOException {
        File pagesDirectory = FileEnvironment.getPagesDirectory(this.masterFrame.getBook().getID());
        File target = new File(pagesDirectory, file.getName());
        if (!file.equals(target)) {
            FileEnvironment.copy(file, target);
        }
        Page page = this.masterFrame.getBook().getPages().get(this.pagesComboBox.getSelectedIndex());
        page.description = "";
        page.image = file.getName();
        page.raster = null;
        File rasterFile = new File(pagesDirectory, file.getName().substring(0, file.getName().lastIndexOf(46)) + ".raster");
        if (rasterFile.exists()) {
            rasterFile.delete();
        }
        this.showPage(page);
    }

    private void repaintCanvas() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GfxEditFrame.this.canvas.repaint();
            }
        });
    }

    private void initComponents() {
        this.pagesComboBox = new JComboBox();
        this.addPageButton = new JButton();
        this.brushSizeSpinner = new JSpinner();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.colorPanel = new JPanel();
        this.loadImageButton = new JButton();
        this.erasorToggleButton = new JToggleButton();
        this.panel = new JPanel();
        this.removePageButton = new JButton();
        this.setClosable(true);
        this.setDefaultCloseOperation(1);
        this.setResizable(true);
        this.setTitle("GFX Editor");
        this.setPreferredSize(new Dimension(920, 520));
        this.pagesComboBox.setModel(new DefaultComboBoxModel());
        this.pagesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GfxEditFrame.this.pagesComboBoxActionPerformed(evt);
            }
        });
        this.addPageButton.setText("hinzuf\u00fcgen");
        this.addPageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GfxEditFrame.this.addPageButtonActionPerformed(evt);
            }
        });
        this.brushSizeSpinner.setModel(new SpinnerNumberModel(10, 2, 100, 2));
        this.jLabel1.setText("Pinselgr\u00f6\u00dfe:");
        this.jLabel2.setText("Seite:");
        this.jLabel3.setText("Farbe:");
        this.colorPanel.setBackground(new Color(153, 0, 51));
        GroupLayout colorPanelLayout = new GroupLayout(this.colorPanel);
        this.colorPanel.setLayout(colorPanelLayout);
        colorPanelLayout.setHorizontalGroup(colorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        colorPanelLayout.setVerticalGroup(colorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 21, Short.MAX_VALUE));
        this.loadImageButton.setText("Bild laden...");
        this.loadImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GfxEditFrame.this.loadImageButtonActionPerformed(evt);
            }
        });
        this.erasorToggleButton.setText("Radieren");
        this.panel.setPreferredSize(new Dimension(570, 320));
        GroupLayout panelLayout = new GroupLayout(this.panel);
        this.panel.setLayout(panelLayout);
        panelLayout.setHorizontalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 748, Short.MAX_VALUE));
        panelLayout.setVerticalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.removePageButton.setText("Seite entfernen");
        this.removePageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GfxEditFrame.this.removePageButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.removePageButton, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel2).addGap(12, 12, 12).addComponent(this.addPageButton).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.pagesComboBox, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(28, 28, 28).addComponent(this.brushSizeSpinner, -2, 46, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.colorPanel, -1, -1, Short.MAX_VALUE))).addComponent(this.erasorToggleButton, -2, 150, -2).addComponent(this.loadImageButton, -2, 150, -2)).addGap(6, 6, 6).addComponent(this.panel, -1, 748, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jLabel2)).addComponent(this.addPageButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pagesComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removePageButton).addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.brushSizeSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.colorPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.erasorToggleButton).addGap(18, 18, 18).addComponent(this.loadImageButton).addContainerGap(258, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.panel, -1, 463, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void addPageButtonActionPerformed(ActionEvent evt) {
        Page p = new Page();
        this.masterFrame.getBook().getPages().add(p);
        this.update();
    }

    private void pagesComboBoxActionPerformed(ActionEvent evt) {
        int index = this.pagesComboBox.getSelectedIndex();
        if (index >= 0) {
            Page p = this.masterFrame.getBook().getPages().get(index);
            try {
                this.showPage(p);
                this.repaintCanvas();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Das Bild konnte nicht geladen werden");
                e.printStackTrace(System.out);
            }
        }
    }

    private void loadImageButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileNameExtensionFilter("Bild (*.png)", "png"));
        if (fc.showOpenDialog(this) == 0) {
            try {
                System.out.println("loading " + fc.getSelectedFile().getCanonicalPath());
                this.loadAndShowImage(fc.getSelectedFile());
                System.out.println("image loaded");
                this.repaintCanvas();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Das Bild konnte nicht geladen werden");
                e.printStackTrace(System.out);
            }
        }
    }

    private void removePageButtonActionPerformed(ActionEvent evt) {
        int index = this.pagesComboBox.getSelectedIndex();
        if (index >= 0) {
            this.masterFrame.getBook().getPages().remove(index);
        }
        this.update();
    }

    @Override
    public void entrySelected(Entry entry) {
        this.entry = entry;
        this.colorPanel.setBackground(COLORS[entry.getTingID() - 15001]);
        this.repaintCanvas();
    }

    static {
        int i = 0;
        for (int r = 0; r < 10; ++r) {
            for (int g = 0; g < 10; ++g) {
                for (int b = 0; b < 10; ++b) {
                    GfxEditFrame.COLORS[i++] = new Color(r * 20 + 25, g * 20 + 25, b * 20 + 25, 128);
                }
            }
        }
        Random random = new Random(12345L);
        for (i = COLORS.length - 1; i > 0; --i) {
            int index = random.nextInt(i + 1);
            Color tmp = COLORS[index];
            GfxEditFrame.COLORS[index] = COLORS[i];
            GfxEditFrame.COLORS[i] = tmp;
        }
    }
}

