/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli.cmds;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import tingeltangel.cli.CliCommand;
import tingeltangel.cli.CliSwitch;
import tingeltangel.core.Book;
import tingeltangel.tools.FileEnvironment;

public class Booklet
extends CliCommand {
    private Book book = null;
    private File file = null;

    @Override
    public String getName() {
        return "booklet";
    }

    @Override
    public String getDescription() {
        return "generiert ein Booklet (ps) aus einem Buch";
    }

    @Override
    public Map<String, CliSwitch> getSwitches() {
        CliSwitch[] list = new CliSwitch[]{new CliSwitch(){

            @Override
            public String getName() {
                return "b";
            }

            @Override
            public String getLabel() {
                return "MID";
            }

            @Override
            public String getDescription() {
                return "Buch ID (MID)";
            }

            @Override
            public boolean isOptional() {
                return false;
            }

            @Override
            public boolean hasArgument() {
                return true;
            }

            @Override
            public String getDefault() {
                return null;
            }

            @Override
            public boolean acceptValue(String value) {
                try {
                    int id = Integer.parseInt(value);
                    if (id < 0 || id >= 15000) {
                        return false;
                    }
                    Booklet.this.book = new Book(id);
                    Book.loadXML(FileEnvironment.getXML(id), Booklet.this.book);
                }
                catch (IOException ex) {
                    return false;
                }
                catch (NumberFormatException e) {
                    return false;
                }
                return true;
            }
        }, new CliSwitch(){

            @Override
            public String getName() {
                return "o";
            }

            @Override
            public String getLabel() {
                return "PS Ausgabe";
            }

            @Override
            public String getDescription() {
                return "PS Ausgabedatei";
            }

            @Override
            public boolean isOptional() {
                return false;
            }

            @Override
            public boolean hasArgument() {
                return true;
            }

            @Override
            public String getDefault() {
                return null;
            }

            @Override
            public boolean acceptValue(String value) {
                Booklet.this.file = new File(value);
                if (!Booklet.this.file.getParentFile().isDirectory()) {
                    return false;
                }
                return !Booklet.this.file.exists() || Booklet.this.file.canWrite();
            }
        }};
        return this.list2map(list);
    }

    @Override
    public void execute(Map<String, String> args) throws Exception {
        PrintWriter out = new PrintWriter(new FileWriter(this.file));
        this.book.generateTestBooklet(out);
        out.close();
    }
}

