/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.util.HashSet;
import java.util.Iterator;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import tingeltangel.core.Book;
import tingeltangel.core.Entry;
import tingeltangel.core.Translator;

class IndexTableModel
implements TableModel {
    private HashSet<TableModelListener> listener = new HashSet();
    private Book book;

    public IndexTableModel(Book book) {
        this.book = book;
    }

    @Override
    public int getRowCount() {
        return this.book.getSize();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "OID";
            }
            case 1: {
                return "Typ";
            }
            case 2: {
                return "Bemerkung";
            }
            case 3: {
                return "Dateiname / TTS";
            }
        }
        throw new Error();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        throw new Error();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public boolean hasWarning(int rowIndex) {
        return Translator.ting2code(this.book.getEntry(rowIndex).getTingID()) < 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Integer.toString(this.book.getEntry(rowIndex).getTingID());
            }
            case 1: {
                Entry entry = this.book.getEntry(rowIndex);
                if (entry.isMP3()) {
                    return "MP3";
                }
                if (entry.isCode()) {
                    return "SKRIPT";
                }
                if (entry.isSub()) {
                    return "METHODE";
                }
                if (entry.isTTS()) {
                    return "TTS";
                }
                return "-";
            }
            case 2: {
                return this.book.getEntry(rowIndex).getHint();
            }
            case 3: {
                Entry entry = this.book.getEntry(rowIndex);
                if (entry.isMP3()) {
                    if (entry.getMP3() == null) {
                        return "kein MP3 ausgew\u00e4hlt";
                    }
                    return this.book.getEntry(rowIndex).getMP3().getName();
                }
                if (entry.isCode() || entry.isSub()) {
                    if (entry.getScript() == null) {
                        return "kein Skript vorhanden";
                    }
                    return "";
                }
                if (entry.isTTS()) {
                    if (entry.getTTS() == null) {
                        return "kein TTS vorhanden";
                    }
                    return entry.getTTS().text;
                }
                return "";
            }
        }
        throw new Error();
    }

    @Override
    public void setValueAt(Object object, int rowIndex, int columnIndex) {
        if (columnIndex == 2) {
            this.book.getEntry(rowIndex).setHint((String)object);
        }
    }

    public void update() {
        TableModelEvent event = new TableModelEvent(this);
        Iterator<TableModelListener> i = this.listener.iterator();
        while (i.hasNext()) {
            i.next().tableChanged(event);
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listener.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listener.remove(l);
    }
}

