/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.tools;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import tingeltangel.core.Properties;
import tingeltangel.tools.OS;

public class Binary {
    public static final String MPG123 = "mpg123";
    public static final String ESPEAK = "espeak";
    public static final String LAME = "lame";
    public static final String AVCONV = "avconv";
    private static final String[] BINARIES = new String[]{"mpg123", "espeak", "lame", "avconv"};
    private static final Map<String, File> binMap = new HashMap<String, File>();

    public static void setBinary(String binary, File file) {
        if (file.canExecute()) {
            try {
                Properties.setProperty(binary, file.getCanonicalPath());
            }
            catch (IOException ioe) {
                throw new Error(ioe);
            }
            binMap.put(binary, file);
        }
    }

    public static File getBinary(String binary) {
        return binMap.get(binary);
    }

    private static File whereis(String binary) {
        String pathEnv;
        if (OS.isWindows()) {
            binary = binary + ".exe";
        }
        if ((pathEnv = System.getenv("PATH")) == null) {
            return null;
        }
        String[] path = pathEnv.split(File.pathSeparator);
        for (int i = 0; i < path.length; ++i) {
            File bf;
            File pf = new File(path[i]);
            if (!pf.isDirectory() || !(bf = new File(pf, binary)).canExecute()) continue;
            return bf;
        }
        return null;
    }

    static {
        for (int i = 0; i < BINARIES.length; ++i) {
            String path = Properties.getStringProperty(BINARIES[i]);
            if (path != null && new File(path).canExecute()) {
                binMap.put(BINARIES[i], new File(path));
                continue;
            }
            File f = Binary.whereis(BINARIES[i]);
            if (f == null || !f.canExecute()) continue;
            try {
                Properties.setProperty(BINARIES[i], f.getCanonicalPath());
            }
            catch (IOException ioe) {
                System.err.println("can't save properties: " + ioe.getMessage());
            }
            binMap.put(BINARIES[i], f);
        }
    }
}

