/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.tiptoireveng;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import tiptoi_reveng.analysis.DepthFirstAdapter;
import tiptoi_reveng.node.ABopEqComparison;
import tiptoi_reveng.node.ABopGtComparison;
import tiptoi_reveng.node.ABopGteqComparison;
import tiptoi_reveng.node.ABopLtComparison;
import tiptoi_reveng.node.ABopLteqComparison;
import tiptoi_reveng.node.ABopNeqComparison;
import tiptoi_reveng.node.AConditionalStatement;
import tiptoi_reveng.node.ANumberValue;
import tiptoi_reveng.node.AOidFileName;
import tiptoi_reveng.node.APlayAction;
import tiptoi_reveng.node.ARegisterValue;
import tiptoi_reveng.node.ASetAction;
import tiptoi_reveng.node.ATextFileName;
import tiptoi_reveng.node.AVariableValue;
import tiptoi_reveng.node.PFileName;
import tiptoi_reveng.node.PValue;

public class Interpreter
extends DepthFirstAdapter {
    private Map<String, Integer> variable2register = new HashMap<String, Integer>();
    private Map<String, Integer> identifier2oid = new HashMap<String, Integer>();
    private Map<String, Integer> filename2oid = new HashMap<String, Integer>();
    private Set<String> variables = new HashSet<String>();
    private Set<String> identifiers = new HashSet<String>();
    private Set<Integer> registers = new HashSet<Integer>();
    private Set<Integer> oids = new HashSet<Integer>();
    private Set<String> fileNames = new HashSet<String>();
    private boolean secondPhase = false;
    private int labelCounter = 1;
    private Stack<Integer> labelStack = new Stack();
    private StringBuffer script = new StringBuffer();

    public Map<String, Integer> getFilename2oid() {
        return this.filename2oid;
    }

    public Map<String, Integer> getIdentifier2oid() {
        return this.identifier2oid;
    }

    public StringBuffer getScript() {
        return this.script;
    }

    public void startSecondPhase() {
        int register = 1;
        for (String variable : this.variables) {
            while (this.registers.contains(register)) {
                ++register;
            }
            this.variable2register.put(variable, register);
            ++register;
        }
        int oid = 15000;
        for (String identifier : this.identifiers) {
            if (this.identifier2oid.containsKey(identifier)) continue;
            while (this.oids.contains(oid)) {
                ++oid;
            }
            this.identifier2oid.put(identifier, oid);
            this.oids.add(oid);
            ++oid;
        }
        for (String fileName : this.fileNames) {
            while (this.oids.contains(oid)) {
                ++oid;
            }
            this.filename2oid.put(fileName, oid);
            this.oids.add(oid);
            ++oid;
        }
        this.secondPhase = true;
    }

    public void addIdentifier(String identifier) {
        this.identifiers.add(identifier);
    }

    public Set<Integer> getOids() {
        return this.oids;
    }

    @Override
    public void outAVariableValue(AVariableValue node) {
        this.variables.add(node.getIdentifier().getText());
    }

    @Override
    public void outARegisterValue(ARegisterValue node) {
        this.registers.add(Integer.parseInt(node.getInteger().getText()));
    }

    @Override
    public void outAOidFileName(AOidFileName node) {
        int oid = Integer.parseInt(node.getInteger().getText());
        if (oid < 15000) {
            oid += 7000;
        }
        this.oids.add(oid);
    }

    @Override
    public void inAConditionalStatement(AConditionalStatement node) {
        if (this.secondPhase) {
            this.labelStack.push(this.labelCounter++);
        }
    }

    @Override
    public void outAConditionalStatement(AConditionalStatement node) {
        if (this.secondPhase) {
            this.script.append(":label").append(this.labelStack.pop()).append("\n");
        }
    }

    private String convertValue(PValue value) {
        String result;
        if (value instanceof AVariableValue) {
            int register = this.variable2register.get(((AVariableValue)value).getIdentifier().getText());
            result = "v" + register;
        } else if (value instanceof ARegisterValue) {
            result = "v" + ((ARegisterValue)value).getInteger();
        } else if (value instanceof ANumberValue) {
            result = ((ANumberValue)value).getInteger().toString();
        } else {
            throw new RuntimeException("Unknown PValue: " + value.getClass());
        }
        return result;
    }

    @Override
    public void inABopEqComparison(ABopEqComparison node) {
        if (this.secondPhase) {
            this.script.append("cmp ").append(this.convertValue(node.getE1())).append(", ").append(this.convertValue(node.getE2())).append("\n");
            this.script.append("jne label").append(this.labelStack.peek()).append("\n");
        }
    }

    @Override
    public void inABopNeqComparison(ABopNeqComparison node) {
        if (this.secondPhase) {
            this.script.append("cmp ").append(this.convertValue(node.getE1())).append(", ").append(this.convertValue(node.getE2())).append("\n");
            this.script.append("je label").append(this.labelStack.peek()).append("\n");
        }
    }

    @Override
    public void inABopGtComparison(ABopGtComparison node) {
        if (this.secondPhase) {
            this.script.append("cmp ").append(this.convertValue(node.getE1())).append(", ").append(this.convertValue(node.getE2())).append("\n");
            this.script.append("jbe label").append(this.labelStack.peek()).append("\n");
        }
    }

    @Override
    public void inABopGteqComparison(ABopGteqComparison node) {
        if (this.secondPhase) {
            this.script.append("cmp ").append(this.convertValue(node.getE1())).append(", ").append(this.convertValue(node.getE2())).append("\n");
            this.script.append("jb label").append(this.labelStack.peek()).append("\n");
        }
    }

    @Override
    public void inABopLtComparison(ABopLtComparison node) {
        if (this.secondPhase) {
            this.script.append("cmp ").append(this.convertValue(node.getE1())).append(", ").append(this.convertValue(node.getE2())).append("\n");
            this.script.append("jge label").append(this.labelStack.peek()).append("\n");
        }
    }

    @Override
    public void inABopLteqComparison(ABopLteqComparison node) {
        if (this.secondPhase) {
            this.script.append("cmp ").append(this.convertValue(node.getE1())).append(", ").append(this.convertValue(node.getE2())).append("\n");
            this.script.append("jg label").append(this.labelStack.peek()).append("\n");
        }
    }

    private int convertFilenameToOid(PFileName fileName) {
        int result;
        if (fileName instanceof ATextFileName) {
            String identifier = ((ATextFileName)fileName).getIdentifier().getText();
            result = this.filename2oid.get(identifier);
        } else if (fileName instanceof AOidFileName) {
            result = Integer.parseInt(((AOidFileName)fileName).getInteger().getText());
            if (result < 15000) {
                result += 7000;
            }
        } else {
            throw new RuntimeException("unknown file name type " + fileName.getClass());
        }
        return result;
    }

    @Override
    public void outAPlayAction(APlayAction node) {
        if (this.secondPhase) {
            this.script.append("playoid ").append(this.convertFilenameToOid(node.getFiles().getFirst())).append("\n");
            if (node.getFiles().size() > 1) {
                System.err.println("More than two file names not supported, yet.");
            }
        }
    }

    @Override
    public void inATextFileName(ATextFileName node) {
        this.fileNames.add(node.getIdentifier().getText());
    }

    @Override
    public void inASetAction(ASetAction node) {
        if (this.secondPhase) {
            this.script.append("set ").append(this.convertValue(node.getLeft())).append(",").append(this.convertValue(node.getRight())).append("\n");
        }
    }
}

