/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tingeltangel.core.TTSEntry;
import tingeltangel.gui.TTSPreferences;
import tingeltangel.tools.TTS;

public class TTSDialog
extends JDialog {
    private final TTSEntry entry;
    private final Runnable callback;
    private String[] voiceIDTable;
    private String[] variantIDTable;
    private JLabel amplitudeLabel;
    private JSlider amplitudeSlider;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JButton okButton;
    private JLabel pitchLabel;
    private JSlider pitchSlider;
    private JButton playButton;
    private JLabel speedLabel;
    private JSlider speedSlider;
    private JTextArea textArea;
    private JComboBox variantComboBox;
    private JComboBox voiceComboBox;

    public TTSDialog(Frame parent, boolean modal, TTSEntry entry, Runnable callback) {
        super(parent, modal);
        this.initComponents();
        this.entry = entry;
        this.callback = callback;
        this.amplitudeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TTSDialog.this.amplitudeLabel.setText(Integer.toString(TTSDialog.this.amplitudeSlider.getValue()));
            }
        });
        this.pitchSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TTSDialog.this.pitchLabel.setText(Integer.toString(TTSDialog.this.pitchSlider.getValue()));
            }
        });
        this.speedSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TTSDialog.this.speedLabel.setText(Integer.toString(TTSDialog.this.speedSlider.getValue()));
            }
        });
        DefaultComboBoxModel voiceModel = (DefaultComboBoxModel)this.voiceComboBox.getModel();
        SortedSet<String> voiceIDs = TTS.getVoiceIDs();
        this.voiceIDTable = new String[voiceIDs.size()];
        int c = 0;
        String defVoiceID = TTSPreferences.getDefaultVoice();
        int currentVoice = -1;
        int currentVoiceDef = 0;
        Iterator i = voiceIDs.iterator();
        while (i.hasNext()) {
            this.voiceIDTable[c] = (String)i.next();
            if (this.voiceIDTable[c].equals(entry.voice)) {
                currentVoice = c;
            }
            if (this.voiceIDTable[c].equals(defVoiceID)) {
                currentVoiceDef = c;
            }
            String name = TTS.getVoiceName(this.voiceIDTable[c]);
            voiceModel.addElement(name);
            ++c;
        }
        if (currentVoice < 0) {
            currentVoice = currentVoiceDef;
        }
        DefaultComboBoxModel variantModel = (DefaultComboBoxModel)this.variantComboBox.getModel();
        SortedSet<String> variantIDs = TTS.getVariantIDs();
        this.variantIDTable = new String[variantIDs.size() + 1];
        this.variantIDTable[0] = "";
        variantModel.addElement("keine Variante");
        c = 1;
        String defVariantID = TTSPreferences.getDefaultVariant();
        int currentVariant = -1;
        int currentVariantDef = 0;
        i = variantIDs.iterator();
        while (i.hasNext()) {
            this.variantIDTable[c] = (String)i.next();
            if (this.variantIDTable[c].equals(entry.variant)) {
                currentVariant = c;
            }
            if (this.variantIDTable[c].equals(defVariantID)) {
                currentVariantDef = c;
            }
            String name = TTS.getVariantName(this.variantIDTable[c]);
            variantModel.addElement(name);
            ++c;
        }
        if (currentVariant < 0) {
            currentVariant = currentVariantDef;
        }
        this.amplitudeSlider.setValue(entry.amplitude);
        this.speedSlider.setValue(entry.speed);
        this.pitchSlider.setValue(entry.pitch);
        this.textArea.setText(entry.text);
        this.voiceComboBox.setSelectedIndex(currentVoice);
        this.variantComboBox.setSelectedIndex(currentVariant);
    }

    private void initComponents() {
        this.voiceComboBox = new JComboBox();
        this.variantComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.speedSlider = new JSlider();
        this.pitchSlider = new JSlider();
        this.amplitudeSlider = new JSlider();
        this.jScrollPane1 = new JScrollPane();
        this.textArea = new JTextArea();
        this.okButton = new JButton();
        this.speedLabel = new JLabel();
        this.pitchLabel = new JLabel();
        this.amplitudeLabel = new JLabel();
        this.playButton = new JButton();
        this.setTitle("Text To Speech (TTS)");
        this.voiceComboBox.setModel(new DefaultComboBoxModel());
        this.variantComboBox.setModel(new DefaultComboBoxModel());
        this.jLabel1.setText("Stimme:");
        this.jLabel2.setText("Variante:");
        this.jLabel3.setText("W\u00f6rter pro Minute:");
        this.jLabel4.setText("Tonh\u00f6he:");
        this.jLabel5.setText("Lautst\u00e4rke:");
        this.speedSlider.setMaximum(450);
        this.speedSlider.setMinimum(80);
        this.speedSlider.setValue(160);
        this.pitchSlider.setMaximum(99);
        this.amplitudeSlider.setMaximum(20);
        this.amplitudeSlider.setValue(10);
        this.textArea.setColumns(20);
        this.textArea.setRows(5);
        this.jScrollPane1.setViewportView(this.textArea);
        this.okButton.setText("ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TTSDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.speedLabel.setText("160");
        this.pitchLabel.setText("50");
        this.amplitudeLabel.setText("10");
        this.playButton.setText("play");
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TTSDialog.this.playButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.amplitudeLabel)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pitchLabel)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.speedLabel))).addGap(0, 17, Short.MAX_VALUE))).addGap(83, 83, 83)).addGroup(layout.createSequentialGroup().addComponent(this.amplitudeSlider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.pitchSlider, GroupLayout.Alignment.LEADING, -2, 0, Short.MAX_VALUE).addComponent(this.speedSlider, GroupLayout.Alignment.LEADING, -2, 0, Short.MAX_VALUE).addComponent(this.variantComboBox, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(this.voiceComboBox, 0, -1, Short.MAX_VALUE)).addGap(18, 18, 18)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.playButton).addGap(18, 18, 18))).addComponent(this.jScrollPane1, -2, 449, -2)).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.voiceComboBox, -2, -1, -2).addGap(12, 12, 12).addComponent(this.jLabel2).addGap(12, 12, 12).addComponent(this.variantComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3, -2, 15, -2).addComponent(this.speedLabel)).addGap(4, 4, 4).addComponent(this.speedSlider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.pitchLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pitchSlider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.amplitudeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.amplitudeSlider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.playButton)).addComponent(this.jScrollPane1, -2, 373, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton).addContainerGap(15, Short.MAX_VALUE)));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.entry.amplitude = this.amplitudeSlider.getValue();
        this.entry.pitch = this.pitchSlider.getValue();
        this.entry.speed = this.speedSlider.getValue();
        this.entry.text = this.textArea.getText();
        this.entry.voice = this.voiceIDTable[this.voiceComboBox.getSelectedIndex()];
        this.entry.variant = this.variantIDTable[this.variantComboBox.getSelectedIndex()];
        this.callback.run();
        this.setVisible(false);
    }

    private void playButtonActionPerformed(ActionEvent evt) {
        try {
            TTS.play(this.textArea.getText(), this.amplitudeSlider.getValue(), this.pitchSlider.getValue(), this.speedSlider.getValue(), this.voiceIDTable[this.voiceComboBox.getSelectedIndex()], this.variantIDTable[this.variantComboBox.getSelectedIndex()]);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(TTSDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(TTSDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(TTSDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(TTSDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TTSDialog dialog = new TTSDialog((Frame)new JFrame(), true, new TTSEntry(""), new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

