/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import tingeltangel.core.Book;
import tingeltangel.core.Entry;
import tingeltangel.core.TTSEntry;
import tingeltangel.gui.IndexTableModel;
import tingeltangel.gui.MasterFrame;
import tingeltangel.gui.MultipleChoiceDialog;
import tingeltangel.gui.TTSDialog;
import tingeltangel.tools.Callback;
import tingeltangel.tools.Lang;

public class IndexFrame
extends JInternalFrame
implements ActionListener {
    private TableModel model;
    private final JTable table;
    private String lastChooseMp3DialogPath = null;
    private static final String MP3 = "MP3";
    private static final String EMPTY = "Leer";
    private static final String SCRIPT = "Skript";
    private static final String T2S = "TTS";
    private static final String SUB = "Skript (Subrutine)";
    private JTextField appendEntries;
    private JTextField newOID;
    private final MasterFrame mainFrame;

    public Book getBook() {
        return this.mainFrame.getBook();
    }

    public IndexFrame(final MasterFrame mainFrame) {
        super("Index", true, true, true, true);
        this.mainFrame = mainFrame;
        this.model = new IndexTableModel(mainFrame.getBook());
        this.table = new JTable(this.model);
        this.table.setAutoResizeMode(0);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(65);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(65);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(220);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(220);
        this.table.setDefaultRenderer(String.class, new MyRenderer());
        this.setVisible(true);
        this.setBounds(5, 5, 600, 590);
        this.setDefaultCloseOperation(1);
        this.appendEntries = new JTextField(3);
        this.appendEntries.setText("10");
        JButton appendNewEntry = new JButton("+");
        appendNewEntry.setActionCommand("append_entry");
        appendNewEntry.addActionListener(this);
        this.newOID = new JTextField(10);
        JButton addNewEntry = new JButton("hinzuf\u00fcgen");
        addNewEntry.setActionCommand("add_entry");
        addNewEntry.addActionListener(this);
        JPanel topLeftBar = new JPanel();
        topLeftBar.setLayout(new FlowLayout());
        topLeftBar.add(this.appendEntries);
        topLeftBar.add(appendNewEntry);
        JPanel topRightBar = new JPanel();
        topRightBar.setLayout(new FlowLayout());
        topRightBar.add(new JLabel("OID:"));
        topRightBar.add(this.newOID);
        topRightBar.add(addNewEntry);
        JPanel topBar = new JPanel();
        topBar.setLayout(new BorderLayout());
        topBar.add((Component)topLeftBar, "West");
        topBar.add((Component)topRightBar, "East");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)new JScrollPane(this.table), "Center");
        panel.add((Component)topBar, "North");
        this.setContentPane(panel);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Book book = mainFrame.getBook();
                JTable target = (JTable)e.getSource();
                int row = target.getSelectedRow();
                int column = target.getSelectedColumn();
                mainFrame.entrySelected(row);
                if (e.getClickCount() == 2) {
                    if (column == 0) {
                        String _id = Integer.toString(book.getEntry(row).getTingID());
                        while (_id.length() < 5) {
                            _id = "0" + _id;
                        }
                        JFileChooser fc = new JFileChooser();
                        fc.setFileFilter(new FileNameExtensionFilter("Tabelle (*.eps)", "eps"));
                        fc.setSelectedFile(new File(_id + ".eps"));
                        if (fc.showSaveDialog(mainFrame) == 0) {
                            try {
                                String file = fc.getSelectedFile().getCanonicalPath();
                                if (!file.toLowerCase().endsWith(".eps")) {
                                    file = file + ".eps";
                                }
                                book.epsSingleExport(new File(file), book.getEntry(row).getTingID());
                            }
                            catch (IOException ex) {
                                JOptionPane.showMessageDialog(mainFrame, "eps-Generierung fehlgeschlagen");
                                ex.printStackTrace(System.out);
                            }
                            catch (IllegalArgumentException ex) {
                                JOptionPane.showMessageDialog(mainFrame, "eps-Generierung fehlgeschlagen: " + ex.getMessage());
                            }
                        }
                    } else if (column == 1) {
                        String[] options = new String[]{Lang.get("indexFrame.dialog.mp3"), Lang.get("indexFrame.dialog.script"), Lang.get("indexFrame.dialog.sub"), Lang.get("indexFrame.dialog.tts"), Lang.get("indexFrame.dialog.empty")};
                        String[] actions = new String[]{IndexFrame.MP3, IndexFrame.SCRIPT, IndexFrame.SUB, IndexFrame.T2S, IndexFrame.EMPTY};
                        final Entry entry = book.getEntry(row);
                        Callback<String> callback = new Callback<String>(){

                            @Override
                            public void callback(String s) {
                                if (s.equals(IndexFrame.MP3)) {
                                    entry.setMP3();
                                } else if (s.equals(IndexFrame.SCRIPT)) {
                                    entry.setCode();
                                } else if (s.equals(IndexFrame.SUB)) {
                                    entry.setSub();
                                } else if (s.equals(IndexFrame.EMPTY)) {
                                    entry.setEmpty();
                                } else if (s.equals(IndexFrame.T2S)) {
                                    entry.setTTS();
                                }
                                IndexFrame.this.update();
                            }
                        };
                        int preselection = -1;
                        if (entry.isMP3()) {
                            preselection = 0;
                        } else if (entry.isCode()) {
                            preselection = 1;
                        } else if (entry.isSub()) {
                            preselection = 2;
                        } else if (entry.isTTS()) {
                            preselection = 3;
                        } else if (entry.isEmpty()) {
                            preselection = 4;
                        } else {
                            throw new Error();
                        }
                        int x = e.getXOnScreen();
                        int y = e.getYOnScreen();
                        MultipleChoiceDialog.show(mainFrame, "Frage...", "Bitte treffe eine Auswahl", "OK", options, actions, preselection, callback, x, y);
                    } else if (column == 3) {
                        if (book.getEntry(row).isMP3()) {
                            JFileChooser fc = new JFileChooser(IndexFrame.this.lastChooseMp3DialogPath);
                            fc.setFileFilter(new FileNameExtensionFilter("mp3", "mp3"));
                            if (fc.showOpenDialog(IndexFrame.this) == 0) {
                                try {
                                    File file = fc.getSelectedFile();
                                    if (file.getParent() != null) {
                                        IndexFrame.this.lastChooseMp3DialogPath = file.getParent();
                                    }
                                    book.getEntry(row).setMP3(file);
                                    IndexFrame.this.update();
                                }
                                catch (FileNotFoundException ex) {
                                    JOptionPane.showMessageDialog(IndexFrame.this, "Die Datei '" + fc.getSelectedFile() + "' konnte nicht gefunden werden.");
                                    ex.printStackTrace(System.out);
                                }
                                catch (IOException ex) {
                                    JOptionPane.showMessageDialog(IndexFrame.this, "Die Datei '" + fc.getSelectedFile() + "' konnte nicht gelesen werden.");
                                    ex.printStackTrace(System.out);
                                }
                            }
                        } else if (book.getEntry(row).isTTS()) {
                            TTSEntry entry = book.getEntry(row).getTTS();
                            if (entry == null) {
                                entry = new TTSEntry("");
                                book.getEntry(row).setTTS(entry);
                            }
                            final TTSEntry _entry = entry;
                            final Book _book = book;
                            final int _row = row;
                            new TTSDialog((Frame)mainFrame, true, entry, new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        _entry.generateTTS(_book.getEntry(_row));
                                    }
                                    catch (IOException ioe) {
                                        ioe.printStackTrace();
                                    }
                                }
                            }).setVisible(true);
                        }
                    }
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("append_entry")) {
            int start;
            int count;
            String _count = this.appendEntries.getText().trim();
            try {
                count = Integer.parseInt(_count);
            }
            catch (NumberFormatException nfe) {
                count = 1;
                this.appendEntries.setText("1");
            }
            for (int i = start = this.mainFrame.getBook().getLastID() + 1; i < start + count; ++i) {
                this.mainFrame.getBook().addEntry(i);
            }
        } else if (action.equals("add_entry")) {
            String _oid = this.newOID.getText().trim();
            try {
                int oid = Integer.parseInt(_oid);
                if (oid < 15001 || oid >= 65536) {
                    JOptionPane.showMessageDialog(this.mainFrame, "ung\u00fcltige OID angegeben (15001 bis 65535)");
                }
                if (!this.mainFrame.getBook().entryForTingIDExists(oid)) {
                    this.mainFrame.getBook().addEntry(oid);
                }
                JOptionPane.showMessageDialog(this.mainFrame, "OID schon belegt");
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this.mainFrame, "ung\u00fcltige OID angegeben");
            }
        }
        this.update();
    }

    public void update() {
        this.model = new IndexTableModel(this.mainFrame.getBook());
        this.table.setModel(this.model);
        ((IndexTableModel)this.model).update();
    }

    private static class MyRenderer
    extends DefaultTableCellRenderer {
        Color backgroundColor = this.getBackground();

        private MyRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            IndexTableModel model = (IndexTableModel)table.getModel();
            if (model.hasWarning(row)) {
                c.setBackground(Color.red);
            } else if (!isSelected) {
                c.setBackground(this.backgroundColor);
            }
            return c;
        }
    }
}

