/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;
import tingeltangel.core.Book;
import tingeltangel.core.Entry;
import tingeltangel.core.Script;
import tingeltangel.tiptoireveng.Interpreter;
import tiptoi_reveng.lexer.Lexer;
import tiptoi_reveng.lexer.LexerException;
import tiptoi_reveng.node.Start;
import tiptoi_reveng.parser.Parser;
import tiptoi_reveng.parser.ParserException;

public class ReadYamlFile {
    boolean ignoreAudioFiles = false;
    private Interpreter interpreter = new Interpreter();
    private Map<Integer, String> usedOidAndIdentifiers = new HashMap<Integer, String>();

    private void convertOgg2Mp3(File oggFile, File mp3File) throws IOException {
        Process p = Runtime.getRuntime().exec("/usr/bin/avconv -i " + oggFile.getCanonicalPath() + " " + mp3File.getCanonicalPath());
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public Map<Integer, String> getUsedOidAndIdentifiers() {
        return this.usedOidAndIdentifiers;
    }

    public Book read(File yamlFile) throws ParserException, IOException, LexerException {
        Yaml yaml = new Yaml();
        Map data = (Map)yaml.load(new FileInputStream(yamlFile));
        Map scripts = (Map)data.get("scripts");
        File dir = yamlFile.getParentFile();
        Book book = new Book(8000 + (Integer)data.get("product-id"));
        Map scriptcodes = (Map)data.get("scriptcodes");
        if (scriptcodes != null) {
            for (Object identifier : scriptcodes.keySet()) {
                int oid = (Integer)scriptcodes.get(identifier);
                if (oid <= 15000) {
                    oid += 8000;
                }
                this.interpreter.getIdentifier2oid().put(identifier.toString(), oid);
            }
        }
        for (Object identifier : scripts.keySet()) {
            if (identifier instanceof Integer) {
                this.interpreter.getOids().add((Integer)identifier);
            } else {
                this.interpreter.addIdentifier(identifier.toString());
            }
            List commands = (List)scripts.get(identifier);
            for (String command : commands) {
                PushbackReader reader = new PushbackReader(new StringReader(command));
                Lexer lexer = new Lexer(reader);
                Parser parser = new Parser(lexer);
                try {
                    Start start = parser.parse();
                    start.apply(this.interpreter);
                }
                catch (ParserException pe) {
                    System.err.println("Could not parse command " + command);
                    pe.printStackTrace();
                    throw pe;
                }
            }
        }
        this.interpreter.startSecondPhase();
        for (String filename : this.interpreter.getFilename2oid().keySet()) {
            int oid = this.interpreter.getFilename2oid().get(filename);
            book.addEntry(oid);
            Entry entry = book.getEntryFromTingID(oid);
            if (this.ignoreAudioFiles) continue;
            File mp3File = new File(dir, "audio_files/" + filename + ".mp3");
            if (!mp3File.exists()) {
                File oggFile = new File(dir, "audio_files/" + filename + ".ogg");
                if (!oggFile.exists()) {
                    throw new RuntimeException("Could not find audio file " + filename);
                }
                this.convertOgg2Mp3(oggFile, mp3File);
            }
            entry.setMP3(mp3File);
        }
        for (Object identifier : scripts.keySet()) {
            int oid;
            if (identifier instanceof Integer) {
                oid = (Integer)identifier;
                if (oid < 15000) {
                    oid += 7000;
                }
                this.usedOidAndIdentifiers.put(oid, null);
            } else {
                oid = this.interpreter.getIdentifier2oid().get(identifier.toString());
                this.usedOidAndIdentifiers.put(oid, identifier.toString());
            }
            List commands = (List)scripts.get(identifier);
            for (String command : commands) {
                PushbackReader reader = new PushbackReader(new StringReader(command));
                Lexer lexer = new Lexer(reader);
                Parser parser = new Parser(lexer);
                try {
                    Start start = parser.parse();
                    start.apply(this.interpreter);
                }
                catch (ParserException pe) {
                    System.err.println("Could not parse command " + command);
                    pe.printStackTrace();
                    throw pe;
                }
            }
            this.interpreter.getScript().append("end\n");
            book.addEntry(oid);
            Entry entry = book.getEntryFromTingID(oid);
            Script script = new Script(this.interpreter.getScript().toString(), entry);
            entry.setScript(script);
            entry.setHint(identifier.toString());
        }
        return book;
    }

    public static void main(String[] args) throws Exception {
        File yaml = new File("C:\\Users\\mdames\\Desktop\\Das-verlorene-Schaf-Rallye-master\\Das-verlorene-Schaf-Rallye-master\\gme\\verlorenes_schaf.yaml");
        Book book = new ReadYamlFile().read(yaml);
        System.out.println("Imported yaml book (mid=" + book.getID() + ")");
        book.save();
    }
}

