/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import tingeltangel.Tingeltangel;
import tingeltangel.core.Book;
import tingeltangel.core.Codes;
import tingeltangel.core.Entry;
import tingeltangel.core.Importer;
import tingeltangel.core.ReadYamlFile;
import tingeltangel.core.Repository;
import tingeltangel.core.Translator;
import tingeltangel.core.scripting.SyntaxError;
import tingeltangel.gui.BinaryLocationsDialog;
import tingeltangel.gui.BookIDChooser;
import tingeltangel.gui.ChooseBook;
import tingeltangel.gui.CodeFrame;
import tingeltangel.gui.EntryListener;
import tingeltangel.gui.IDChooser;
import tingeltangel.gui.ImportDialog;
import tingeltangel.gui.IndexFrame;
import tingeltangel.gui.InfoFrame;
import tingeltangel.gui.MasterFrameMenu;
import tingeltangel.gui.PlayerFrame;
import tingeltangel.gui.PropertyFrame;
import tingeltangel.gui.ReferenceFrame;
import tingeltangel.gui.RegisterFrame;
import tingeltangel.gui.RepositoryManager;
import tingeltangel.gui.StickFrame;
import tingeltangel.gui.TTSPreferences;
import tingeltangel.gui.TranslatorFrame;
import tingeltangel.tools.Callback;
import tingeltangel.tools.FileEnvironment;
import tingeltangel.tools.Progress;
import tingeltangel.tools.ProgressDialog;

public class MasterFrame
extends JFrame
implements Callback<String> {
    private Book book = new Book(15000);
    private JDesktopPane desktop;
    private IndexFrame indexFrame;
    private PlayerFrame playerFrame;
    private RegisterFrame registerFrame;
    private CodeFrame codeFrame;
    private PropertyFrame propertyFrame;
    private StickFrame stickFrame;
    private ReferenceFrame referenceFrame;
    private TranslatorFrame translatorFrame;
    private RepositoryManager repositoryFrame;
    private InfoFrame contactFrame = new InfoFrame("Kontakt", "html/contact.html");
    private InfoFrame licenseFrame = new InfoFrame("Lizenz", "html/license.html");
    private LinkedList<EntryListener> listeners = new LinkedList();

    public MasterFrame() {
        super(Tingeltangel.MAIN_FRAME_TITLE + Tingeltangel.MAIN_FRAME_VERSION);
        this.indexFrame = new IndexFrame(this);
        this.playerFrame = new PlayerFrame(this);
        this.registerFrame = new RegisterFrame(this);
        this.codeFrame = new CodeFrame(this);
        this.propertyFrame = new PropertyFrame(this);
        this.stickFrame = new StickFrame(this);
        this.referenceFrame = new ReferenceFrame(this);
        this.translatorFrame = new TranslatorFrame(this);
        this.repositoryFrame = new RepositoryManager();
        this.book.addRegisterListener(this.registerFrame);
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.setBounds(Tingeltangel.MAIN_FRAME_POS_X, Tingeltangel.MAIN_FRAME_POS_Y, Tingeltangel.MAIN_FRAME_WIDTH + this.getInsets().left + this.getInsets().right, Tingeltangel.MAIN_FRAME_HEIGHT + this.getInsets().top + this.getInsets().bottom);
        this.desktop = new JDesktopPane();
        MasterFrameMenu.setMenuCallback(this);
        this.setMenuBar(MasterFrameMenu.getMenuBar());
        this.desktop.setDragMode(1);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MasterFrame.this.closeMasterFrame();
            }
        });
        this.setVisible(true);
        this.desktop.add(this.indexFrame);
        this.desktop.add(this.playerFrame);
        this.desktop.add(this.registerFrame);
        this.desktop.add(this.codeFrame);
        this.desktop.add(this.propertyFrame);
        this.desktop.add(this.stickFrame);
        this.desktop.add(this.referenceFrame);
        this.desktop.add(this.contactFrame);
        this.desktop.add(this.licenseFrame);
        this.desktop.add(this.translatorFrame);
        this.setContentPane(this.desktop);
    }

    public void showReferenceFrame() {
        this.referenceFrame.setVisible(true);
    }

    public Book getBook() {
        return this.book;
    }

    void addEntryListener(EntryListener listener) {
        this.listeners.add(listener);
    }

    void entrySelected(int i) {
        Entry entry = this.book.getEntry(i);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((EntryListener)it.next()).entrySelected(entry);
        }
    }

    private void closeMasterFrame() {
        if (this.book.unsaved()) {
            int value = JOptionPane.showConfirmDialog(this, "Das aktuelle Buch ist nicht gespeichert. wollen sie trotzdem das Programm beenden?", "Frage...", 0, 2);
            if (value == 0) {
                System.exit(0);
            }
        } else {
            System.exit(0);
        }
    }

    @Override
    public void callback(String id) {
        if (id.equals("buch.exit")) {
            this.closeMasterFrame();
        } else if (id.equals("buch.new")) {
            boolean newBook = false;
            if (this.book.unsaved()) {
                int value = JOptionPane.showConfirmDialog(this, "Das aktuelle Buch ist nicht gespeichert. wollen sie trotzdem ein neues Buch erstellen?", "Frage...", 0, 2);
                if (value == 0) {
                    newBook = true;
                }
            } else {
                newBook = true;
            }
            if (newBook) {
                IDChooser ic = new IDChooser((Frame)this, new Callback<Integer>(){

                    @Override
                    public void callback(Integer id) {
                        String _id = Integer.toString(id);
                        while (_id.length() < 5) {
                            _id = "0" + _id;
                        }
                        if (new File(FileEnvironment.getBooksDirectory(), _id).exists()) {
                            JOptionPane.showMessageDialog(MasterFrame.this, "Dieses Buch existiert schon");
                            return;
                        }
                        MasterFrame.this.book.clear();
                        MasterFrame.this.book.setID(id);
                        MasterFrame.this.propertyFrame.refresh();
                        MasterFrame.this.indexFrame.update();
                    }
                });
            }
        } else if (id.equals("buch.import.repo")) {
            boolean loadBook = false;
            if (this.book.unsaved()) {
                int value = JOptionPane.showConfirmDialog(this, "Das aktuelle Buch ist nicht gespeichert. wollen sie trotzdem ein Buch importieren?", "Frage...", 0, 2);
                if (value == 0) {
                    loadBook = true;
                }
            } else {
                loadBook = true;
            }
            if (loadBook) {
                BookIDChooser bidc = new BookIDChooser((Frame)this, new Callback<Integer>(){

                    @Override
                    public void callback(final Integer id) {
                        if (!Repository.exists(id)) {
                            new Progress(MasterFrame.this, "Buch wird heruntergeladen"){

                                @Override
                                public void action(ProgressDialog progressDialog) {
                                    try {
                                        Repository.download(id, progressDialog);
                                        new Progress(MasterFrame.this, "Buch wird importiert"){

                                            @Override
                                            public void action(ProgressDialog progressDialog) {
                                                try {
                                                    MasterFrame.this.book = new Book(id);
                                                    File ouf = Repository.getBookOuf(id);
                                                    HashMap<String, String> txt = Repository.getBookTxt(id);
                                                    File src = Repository.getBookSrc(id);
                                                    Importer.importBook(ouf, txt, src, MasterFrame.this.book, progressDialog);
                                                    MasterFrame.this.propertyFrame.refresh();
                                                    MasterFrame.this.indexFrame.update();
                                                }
                                                catch (SyntaxError ex) {
                                                    JOptionPane.showMessageDialog(MasterFrame.this, "Fehler beim Importieren des Buches");
                                                    ex.printStackTrace(System.out);
                                                }
                                                catch (IOException ex) {
                                                    JOptionPane.showMessageDialog(MasterFrame.this, "Fehler beim Importieren des Buches");
                                                    ex.printStackTrace(System.out);
                                                }
                                            }
                                        };
                                    }
                                    catch (IOException ex) {
                                        JOptionPane.showMessageDialog(MasterFrame.this, "Fehler beim Herunterladen des Buches");
                                        ex.printStackTrace(System.out);
                                    }
                                }
                            };
                        } else {
                            new Progress(MasterFrame.this, "Buch wird importiert"){

                                @Override
                                public void action(ProgressDialog progressDialog) {
                                    try {
                                        MasterFrame.this.book = new Book(id);
                                        File ouf = Repository.getBookOuf(id);
                                        HashMap<String, String> txt = Repository.getBookTxt(id);
                                        File src = Repository.getBookSrc(id);
                                        Importer.importBook(ouf, txt, src, MasterFrame.this.book, progressDialog);
                                        MasterFrame.this.propertyFrame.refresh();
                                        MasterFrame.this.indexFrame.update();
                                    }
                                    catch (SyntaxError ex) {
                                        JOptionPane.showMessageDialog(MasterFrame.this, "Fehler beim Importieren des Buches");
                                        ex.printStackTrace(System.out);
                                    }
                                    catch (IOException ex) {
                                        JOptionPane.showMessageDialog(MasterFrame.this, "Fehler beim Importieren des Buches");
                                        ex.printStackTrace(System.out);
                                    }
                                }
                            };
                        }
                    }
                });
            }
        } else if (id.equals("buch.import.yaml")) {
            boolean loadBook = false;
            if (this.book.unsaved()) {
                int value = JOptionPane.showConfirmDialog(this, "Das aktuelle Buch ist nicht gespeichert. wollen sie trotzdem ein Buch importieren?", "Frage...", 0, 2);
                if (value == 0) {
                    loadBook = true;
                }
            } else {
                loadBook = true;
            }
            if (loadBook) {
                JFileChooser fc = new JFileChooser();
                fc.setFileFilter(new FileNameExtensionFilter("tiptoi Buch (*.yaml)", "yaml"));
                if (fc.showOpenDialog(this) == 0) {
                    try {
                        new ReadYamlFile().read(fc.getSelectedFile()).save();
                        this.propertyFrame.refresh();
                        this.indexFrame.update();
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this, "Die yaml Datei konnte nicht importiert werden");
                        e.printStackTrace(System.out);
                    }
                }
            }
        } else if (id.equals("buch.import.ouf")) {
            boolean loadBook = false;
            if (this.book.unsaved()) {
                int value = JOptionPane.showConfirmDialog(this, "Das aktuelle Buch ist nicht gespeichert. wollen sie trotzdem ein Buch importieren?", "Frage...", 0, 2);
                if (value == 0) {
                    loadBook = true;
                }
            } else {
                loadBook = true;
            }
            if (loadBook) {
                Callback<Map> callback = new Callback<Map>(){

                    @Override
                    public void callback(final Map data) {
                        int id = -1;
                        if (data.get("id") != null) {
                            id = (Integer)data.get("id");
                        }
                        if (id < 0) {
                            try {
                                DataInputStream in = new DataInputStream(new FileInputStream((File)data.get("ouf")));
                                in.skipBytes(20);
                                id = in.readInt();
                                in.close();
                            }
                            catch (IOException e) {
                                JOptionPane.showMessageDialog(MasterFrame.this, "Fehler beim lesen der ouf Datei");
                                e.printStackTrace(System.out);
                                return;
                            }
                        }
                        final int _id = id;
                        MasterFrame.this.setEnabled(false);
                        Progress pr = new Progress(MasterFrame.this, "importiere Buch"){

                            @Override
                            public void action(ProgressDialog progressDialog) {
                                try {
                                    MasterFrame.this.book = new Book(_id);
                                    Importer.importBook((File)data.get("ouf"), Repository.getBook((File)data.get("txt")), (File)data.get("src"), MasterFrame.this.book, progressDialog);
                                }
                                catch (IOException e) {
                                    JOptionPane.showMessageDialog(MasterFrame.this, "Import ist fehlgeschlagen");
                                    e.printStackTrace(System.out);
                                }
                                catch (SyntaxError se) {
                                    JOptionPane.showMessageDialog(MasterFrame.this, "Import ist fehlgeschlagen");
                                    se.printStackTrace(System.out);
                                }
                                MasterFrame.this.propertyFrame.refresh();
                                MasterFrame.this.indexFrame.update();
                            }
                        };
                    }
                };
                new ImportDialog((Frame)this, true, callback).setVisible(true);
            }
        } else if (id.equals("buch.load")) {
            boolean loadBook = false;
            if (this.book.unsaved()) {
                int value = JOptionPane.showConfirmDialog(this, "Das aktuelle Buch ist nicht gespeichert. wollen sie trotzdem ein Buch laden?", "Frage...", 0, 2);
                if (value == 0) {
                    loadBook = true;
                }
            } else {
                loadBook = true;
            }
            if (loadBook) {
                ChooseBook cb = new ChooseBook((Frame)this, new Callback<Integer>(){

                    @Override
                    public void callback(Integer _id) {
                        try {
                            MasterFrame.this.book.clear();
                            MasterFrame.this.book.setID(_id);
                            Book.loadXML(FileEnvironment.getXML(_id), MasterFrame.this.book);
                        }
                        catch (IOException ex) {
                            ex.printStackTrace(System.err);
                        }
                        MasterFrame.this.propertyFrame.refresh();
                        MasterFrame.this.indexFrame.update();
                    }
                });
            }
        } else if (id.equals("buch.save")) {
            try {
                this.book.save();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Das Buch konnte nicht gespeichert werden");
                e.printStackTrace(System.out);
            }
        } else if (id.equals("buch.generate")) {
            new Progress(this, "erzeuge Codes"){

                @Override
                public void action(ProgressDialog progressDialog) {
                    try {
                        MasterFrame.this.book.export(FileEnvironment.getDistDirectory(MasterFrame.this.book.getID()), progressDialog);
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(MasterFrame.this, "Buchgenerierung fehlgeschlagen");
                        e.printStackTrace(System.out);
                    }
                    catch (IllegalArgumentException e) {
                        JOptionPane.showMessageDialog(MasterFrame.this, "Buchgenerierung fehlgeschlagen: " + e.getMessage());
                    }
                    catch (SyntaxError e) {
                        e.printStackTrace(System.out);
                        JOptionPane.showMessageDialog(MasterFrame.this, "Buchgenerierung fehlgeschlagen: Syntax Error in Skript " + e.getTingID() + " in Zeile " + e.getRow() + " (" + e.getMessage() + ")");
                    }
                }
            };
        } else if (id.startsWith("buch.generateEpsCodes.")) {
            if (id.endsWith(".600")) {
                Codes.setResolution(0);
            } else {
                Codes.setResolution(1);
            }
            new Progress(this, "erzeuge Codes"){

                @Override
                public void action(ProgressDialog progressDialog) {
                    try {
                        MasterFrame.this.book.epsExport(FileEnvironment.getCodesDirectory(MasterFrame.this.book.getID()), progressDialog);
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(MasterFrame.this, "eps-Generierung fehlgeschlagen");
                        e.printStackTrace(System.out);
                    }
                }
            };
        } else if (id.startsWith("buch.booklet")) {
            JFileChooser fc = new JFileChooser();
            fc.setFileFilter(new FileNameExtensionFilter("Code Tabelle (*.ps)", "ps"));
            if (fc.showSaveDialog(this) == 0) {
                try {
                    String file = fc.getSelectedFile().getCanonicalPath();
                    if (!file.toLowerCase().endsWith(".ps")) {
                        file = file + ".ps";
                    }
                    PrintWriter out = new PrintWriter(new FileWriter(file));
                    this.book.generateTestBooklet(out);
                    out.close();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Die Codetabelle konnte nicht gespeichert werden");
                    e.printStackTrace(System.out);
                }
            }
        } else if (id.startsWith("buch.generatePngCodes.")) {
            if (id.endsWith(".600")) {
                Codes.setResolution(0);
            } else {
                Codes.setResolution(1);
            }
            new Progress(this, "erzeuge Codes"){

                @Override
                public void action(ProgressDialog progressDialog) {
                    try {
                        MasterFrame.this.book.pngExport(FileEnvironment.getCodesDirectory(MasterFrame.this.book.getID()), progressDialog);
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(MasterFrame.this, "eps-Generierung fehlgeschlagen");
                        e.printStackTrace(System.out);
                    }
                }
            };
        } else if (id.equals("about.binary")) {
            new BinaryLocationsDialog((Frame)this, true).setVisible(true);
        } else if (id.equals("about.tts_prefs")) {
            new TTSPreferences().setVisible(true);
        } else if (id.equals("windows.stick")) {
            this.stickFrame.setVisible(true);
        } else if (id.equals("windows.player")) {
            this.playerFrame.setVisible(true);
        } else if (id.equals("windows.properties")) {
            this.propertyFrame.setVisible(true);
        } else if (id.equals("windows.code")) {
            this.codeFrame.setVisible(true);
        } else if (id.equals("windows.register")) {
            this.registerFrame.setVisible(true);
        } else if (id.equals("windows.index")) {
            this.indexFrame.setVisible(true);
        } else if (id.equals("windows.reference")) {
            this.referenceFrame.setVisible(true);
        } else if (id.equals("windows.translator")) {
            this.translatorFrame.setVisible(true);
        } else if (id.equals("windows.repository")) {
            this.repositoryFrame.setVisible(true);
        } else if (id.startsWith("codes.raw.")) {
            id = id.substring("codes.raw.".length());
            int start = Integer.parseInt(id.substring(0, 1)) * 10000 + Integer.parseInt(id.substring(2)) * 1000;
            JFileChooser fc = new JFileChooser();
            fc.setFileFilter(new FileNameExtensionFilter("Code Tabelle (*.ps)", "ps"));
            if (fc.showSaveDialog(this) == 0) {
                try {
                    String file = fc.getSelectedFile().getCanonicalPath();
                    if (!file.toLowerCase().endsWith(".ps")) {
                        file = file + ".ps";
                    }
                    PrintWriter out = new PrintWriter(new FileWriter(file));
                    Codes.drawPage(start, out);
                    out.close();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Die Codetabelle konnte nicht gespeichert werden");
                    e.printStackTrace(System.out);
                }
            }
        } else if (id.startsWith("codes.ting.")) {
            if (!this.genTingCodes(Integer.parseInt(id.substring(id.lastIndexOf(".") + 1)))) {
                JOptionPane.showMessageDialog(this, "Die Ting-Codetabelle konnte nicht erstellt werden, da die gew\u00e4hlten Codes noch unbekannt sind.");
            }
        } else if (id.equals("codes.tabular.ting2code")) {
            this.generateTabular(true);
        } else if (id.equals("codes.tabular.code2ting")) {
            this.generateTabular(false);
        } else if (id.equals("books.search")) {
            Repository.search(null);
        } else if (id.equals("books.update")) {
            try {
                Repository.update(null);
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.out);
                JOptionPane.showMessageDialog(this, "Update der bekannten B\u00fccher fehlgeschlagen: " + ioe.getMessage());
            }
        } else if (id.equals("about.contact")) {
            this.contactFrame.setVisible(true);
        } else if (id.equals("about.license")) {
            this.licenseFrame.setVisible(true);
        }
    }

    private void generateTabular(boolean ting2code) {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileNameExtensionFilter("Tabelle (*.txt)", "txt"));
        if (fc.showSaveDialog(this) == 0) {
            try {
                String file = fc.getSelectedFile().getCanonicalPath();
                if (!file.toLowerCase().endsWith(".txt")) {
                    file = file + ".txt";
                }
                PrintWriter out = new PrintWriter(new FileWriter(file));
                for (int i = 0; i < 65536; ++i) {
                    int t = Translator.code2ting(i);
                    if (ting2code) {
                        t = Translator.ting2code(i);
                    }
                    if (t == -1) continue;
                    out.println(i + "\t" + t);
                }
                out.close();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Die Tabelle konnte nicht gespeichert werden");
                e.printStackTrace(System.out);
            }
        }
    }

    private boolean genTingCodes(int start) {
        boolean found = false;
        for (int i = start; i < start + 1000; ++i) {
            if (Translator.ting2code(i) == -1) continue;
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileNameExtensionFilter("PostScript Datei (*.ps)", "ps"));
        fc.setDialogTitle("Zieldatei ausw\u00e4hlen");
        if (fc.showSaveDialog(this) == 0) {
            try {
                String file = fc.getSelectedFile().getCanonicalPath();
                if (!file.toLowerCase().endsWith(".ps")) {
                    file = file + ".ps";
                }
                int[] idx = new int[1000];
                String[] lbs = new String[idx.length];
                for (int i = start; i < start + 1000; ++i) {
                    int code;
                    idx[i - start] = code = Translator.ting2code(i);
                    lbs[i - start] = "" + i;
                }
                PrintWriter out = new PrintWriter(new FileWriter(file));
                Codes.drawPage(idx, lbs, out);
                out.close();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "Codegenerierung fehlgeschlagen");
                ioe.printStackTrace(System.out);
            }
        }
        return true;
    }
}

