/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class GfxEditFrame
extends JFrame {
    private static final int SHRINK = 12;
    private BufferedImage img = null;
    private int[][] raster = null;
    private int dx = 0;
    private int dy = 0;
    private int w = 0;
    private int h = 0;
    private double scale = 0.0;
    private JPanel panel;

    public GfxEditFrame() {
        this.initComponents();
        final JPanel canvas = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (GfxEditFrame.this.img != null) {
                    g.drawImage(GfxEditFrame.this.img, GfxEditFrame.this.dx, GfxEditFrame.this.dy, GfxEditFrame.this.w, GfxEditFrame.this.h, null);
                    for (int x = 0; x < GfxEditFrame.this.raster.length; ++x) {
                        for (int y = 0; y < GfxEditFrame.this.raster[0].length; ++y) {
                            if (GfxEditFrame.this.raster[x][y] == 0) continue;
                            g.setColor(Color.red);
                            g.fillRect(GfxEditFrame.this.dx + (int)((double)(x * 12) / GfxEditFrame.this.scale), GfxEditFrame.this.dy + (int)((double)(y * 12) / GfxEditFrame.this.scale), 1, 1);
                        }
                    }
                }
            }
        };
        canvas.setSize(this.panel.getWidth(), this.panel.getHeight());
        this.panel.add(canvas);
        canvas.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int x = e.getX() - GfxEditFrame.this.dx;
                int y = e.getY() - GfxEditFrame.this.dy;
                if (x >= 0 && x < GfxEditFrame.this.w && y >= 0 && y < GfxEditFrame.this.h) {
                    x = (int)((double)x * GfxEditFrame.this.scale) / 12;
                    y = (int)((double)y * GfxEditFrame.this.scale) / 12;
                    GfxEditFrame.this.circle(x, y, 5, 1);
                    ((GfxEditFrame)GfxEditFrame.this).raster[x][y] = 1;
                    canvas.repaint();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.loadImage(new File("/home/martin/tingeltangel.png"));
    }

    private void circle(int x, int y, int r, int v) {
        int rq = r * r;
        for (int ix = x - r; ix <= x + r; ++ix) {
            int ixq = (ix - x) * (ix - x);
            for (int iy = y - r; iy <= y + r; ++iy) {
                if (ixq + (iy - y) * (iy - y) > rq) continue;
                this.raster[ix][iy] = v;
            }
        }
    }

    private void loadImage(File file) {
        try {
            this.img = ImageIO.read(file);
            double panelAspect = (double)this.panel.getWidth() / (double)this.panel.getHeight();
            double imageAspect = (double)this.img.getWidth() / (double)this.img.getHeight();
            this.dx = 0;
            this.dy = 0;
            this.w = this.panel.getWidth();
            this.h = this.panel.getHeight();
            if (panelAspect > imageAspect) {
                this.w = (int)((double)this.h * imageAspect);
                this.dx = (this.panel.getWidth() - this.w) / 2;
                this.scale = (double)this.img.getHeight() / (double)this.h;
            } else {
                this.h = (int)((double)this.w / imageAspect);
                this.dy = (this.panel.getHeight() - this.h) / 2;
                this.scale = (double)this.img.getWidth() / (double)this.w;
            }
            this.raster = new int[this.img.getWidth() / 12][this.img.getHeight() / 12];
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void initComponents() {
        this.panel = new JPanel();
        this.setDefaultCloseOperation(3);
        GroupLayout panelLayout = new GroupLayout(this.panel);
        this.panel.setLayout(panelLayout);
        panelLayout.setHorizontalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1193, Short.MAX_VALUE));
        panelLayout.setVerticalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 761, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.panel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.panel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(GfxEditFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(GfxEditFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(GfxEditFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(GfxEditFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new GfxEditFrame().setVisible(true);
            }
        });
    }
}

