/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.core;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import tingeltangel.core.Book;
import tingeltangel.core.Entry;
import tingeltangel.core.IndexTableCalculator;
import tingeltangel.core.Script;
import tingeltangel.core.scripting.Command;
import tingeltangel.core.scripting.Commands;
import tingeltangel.core.scripting.SyntaxError;
import tingeltangel.tools.FileEnvironment;
import tingeltangel.tools.ProgressDialog;

public class Importer {
    /*
     * Enabled aggressive block sorting
     */
    public static void importBook(File oufFile, Map<String, String> txt, File scriptFile, Book book, ProgressDialog progress) throws IOException, SyntaxError {
        int k;
        boolean foundFirstEntryCode;
        boolean firstEntryTypeIsScript;
        int firstEntryLength;
        int firstEntryN;
        int firstEntryCode;
        LinkedList<int[]> index;
        boolean firstTingIdCorrected;
        int lastTingID;
        int firstTingID;
        int startOfIndex;
        DataInputStream ouf;
        HashMap<Integer, Boolean> scriptEntryIsMP3;
        HashMap<Integer, String> notes;
        HashMap<Integer, String> scripts;
        block74: {
            String row;
            if (txt != null) {
                book.setAuthor(txt.get("Author"));
                book.setName(txt.get("Name"));
                book.setPublisher(txt.get("Publisher"));
                book.setURL(txt.get("URL"));
                book.setVersion(Integer.parseInt(txt.get("Book Version")));
            } else {
                book.setAuthor("unknown");
                book.setName("unknown");
                book.setPublisher("unknown");
                book.setURL("unknown");
                book.setVersion(1);
            }
            scripts = new HashMap<Integer, String>();
            notes = new HashMap<Integer, String>();
            scriptEntryIsMP3 = new HashMap<Integer, Boolean>();
            if (scriptFile == null) break block74;
            BufferedReader in = new BufferedReader(new FileReader(scriptFile));
            boolean inScript = true;
            boolean inNote = false;
            int precode = -1;
            String script = "";
            String note = "";
            while ((row = in.readLine()) != null) {
                block71: {
                    block75: {
                        if (!inNote) break block75;
                        if (row.startsWith("[Content]")) {
                            notes.put(precode, note);
                            note = "";
                            inNote = false;
                            inScript = true;
                            break block71;
                        } else if (row.startsWith("Precode=")) {
                            if (precode != -1) {
                                notes.put(precode, note);
                            }
                            note = "";
                            inNote = false;
                            precode = Integer.parseInt(row.substring("Precode=".length()).trim());
                            break block71;
                        } else {
                            note = note + row + "\n";
                        }
                        break block71;
                    }
                    if (inScript) {
                        if (row.startsWith("Precode=")) {
                            if (precode != -1) {
                                scripts.put(precode, script);
                            }
                            script = "";
                            inScript = false;
                            precode = Integer.parseInt(row.substring("Precode=".length()).trim());
                        } else {
                            script = script + row + "\n";
                        }
                    } else if (row.startsWith("[Content]")) {
                        inScript = true;
                    } else if (row.toUpperCase().startsWith("TYPE=")) {
                        String type = row.substring("TYPE=".length()).trim();
                        if (type.equals("1")) {
                            scriptEntryIsMP3.put(precode, true);
                        } else {
                            scriptEntryIsMP3.put(precode, false);
                        }
                    } else if (row.startsWith("[Note]")) {
                        inNote = true;
                    }
                }
                if (inNote) {
                    notes.put(precode, note);
                    continue;
                }
                if (!inScript || precode == -1) continue;
                scripts.put(precode, script);
            }
            in.close();
        }
        if (oufFile != null || scriptFile == null) {
            ouf = new DataInputStream(new FileInputStream(oufFile));
            startOfIndex = ouf.readInt();
            if (startOfIndex != 102) {
                ouf.readInt();
            }
            firstTingID = ouf.readInt();
            lastTingID = ouf.readInt();
            int tingIDCount = ouf.readInt();
            ouf.readInt();
            book.setMagicValue(ouf.readInt());
            book.setDate(ouf.readInt());
            ouf.readInt();
            ouf.readInt();
            firstTingIdCorrected = false;
            ouf.skipBytes(startOfIndex - 40);
            if (firstTingID != 15001) {
                if (firstTingID == 15000) {
                    System.out.println("WARNING: first ting id is 15000. Trying auto correction...");
                    ouf.readInt();
                    ouf.readInt();
                    int type15000 = ouf.readInt();
                    if (type15000 == 0) {
                        System.out.println("Auto correction successfull");
                        firstTingIdCorrected = true;
                        firstTingID = 15001;
                        --tingIDCount;
                    } else {
                        System.out.println("Auto correction failed. The import is expected to fail.");
                    }
                } else {
                    System.out.println("WARNING: first ting id is neither 15001 nor 15000. The import is expected to fail.");
                }
            }
            if (tingIDCount != lastTingID - firstTingID + 1) {
                System.out.println("WARNING: index count missmatch (first=" + firstTingID + ", last=" + lastTingID + ", count=" + tingIDCount + ")");
            }
            index = new LinkedList<int[]>();
            firstEntryCode = 0;
            firstEntryN = 0;
            firstEntryLength = 0;
            firstEntryTypeIsScript = false;
            foundFirstEntryCode = false;
        } else {
            Iterator ids = scripts.keySet().iterator();
            while (true) {
                String note;
                if (!ids.hasNext()) {
                    book.save();
                    return;
                }
                int id = (Integer)ids.next();
                book.addEntry(id);
                Entry entry = book.getEntryByID(id);
                if (((Boolean)scriptEntryIsMP3.get(id)).booleanValue()) {
                    entry.setMP3();
                } else {
                    Script script = new Script((String)scripts.get(id), entry);
                    entry.setScript(script);
                    if (script.isSub()) {
                        entry.setSub();
                    } else {
                        entry.setCode();
                    }
                }
                if ((note = (String)notes.get(id)) == null) continue;
                entry.setHint(note);
            }
        }
        for (int i = firstTingID; i <= lastTingID; ++i) {
            int[] e = new int[4];
            for (int k2 = 0; k2 < 3; ++k2) {
                e[k2] = ouf.readInt();
            }
            System.out.println(e[0] + " " + e[1] + " " + e[2]);
            if (e[2] == 0) continue;
            e[3] = i;
            if (!foundFirstEntryCode && e[1] > 0) {
                firstEntryCode = e[0];
                firstEntryN = i - 15001;
                if (e[2] == 2) {
                    firstEntryTypeIsScript = true;
                }
                firstEntryLength = e[1];
                foundFirstEntryCode = true;
            }
            index.add(e);
        }
        if (progress != null) {
            progress.setMax(index.size());
        }
        int counter = 0;
        int pos = 12 * (lastTingID - firstTingID + 1) + startOfIndex;
        System.out.println("end of index table: 0x" + Integer.toHexString(pos));
        int diff = (256 - pos % 256) % 256;
        pos += diff;
        if (firstTingIdCorrected) {
            diff -= 12;
        }
        ouf.skipBytes(diff);
        System.out.println("possible start of first entry: 0x" + Integer.toHexString(pos));
        System.out.println("firstEntryCode: " + firstEntryCode);
        System.out.println("firstEntryLength: " + firstEntryLength);
        byte[] buffer = new byte[Math.min(firstEntryLength, 50)];
        for (k = 0; k != buffer.length; k += ouf.read(buffer, k, buffer.length - k)) {
        }
        if (firstEntryTypeIsScript) {
            System.out.println("searching for script...");
            while (!Importer.isScriptData(buffer)) {
                pos += 256;
                ouf.skipBytes(256 - buffer.length);
                for (k = 0; k != buffer.length; k += ouf.read(buffer, k, buffer.length - k)) {
                }
            }
        } else {
            System.out.println("searching for mp3...");
            while (!Importer.isMp3Data(buffer)) {
                pos += 256;
                ouf.skipBytes(256 - buffer.length);
                for (k = 0; k != buffer.length; k += ouf.read(buffer, k, buffer.length - k)) {
                }
            }
        }
        System.out.println("start of first entry: 0x" + Integer.toHexString(pos));
        int entryOffset = pos - IndexTableCalculator.getPositionInFileFromCode(firstEntryCode, firstEntryN);
        System.out.println("offset: " + entryOffset);
        ouf.close();
        Iterator indexIterator = index.iterator();
        buffer = new byte[4096];
        while (true) {
            if (!indexIterator.hasNext()) {
                book.save();
                return;
            }
            int[] e = (int[])indexIterator.next();
            if (progress != null) {
                progress.setVal(counter++);
            }
            int epos = IndexTableCalculator.getPositionInFileFromCode(e[0], e[3] - 15001) + entryOffset;
            ouf = new DataInputStream(new FileInputStream(oufFile));
            ouf.skipBytes(epos);
            String _eid = Integer.toString(e[3]);
            while (_eid.length() < 5) {
                _eid = "0" + _eid;
            }
            book.addEntry(e[3]);
            Entry entry = book.getEntryByID(e[3]);
            if (e[2] == 1) {
                FileOutputStream out = new FileOutputStream(new File(FileEnvironment.getAudioDirectory(book.getID()), _eid + ".mp3"));
                for (int len = e[1]; len > 0; len -= k) {
                    k = ouf.read(buffer, 0, Math.min(buffer.length, len));
                    if (k <= 0) {
                        System.err.println("error reading mp3 with id=" + _eid);
                        len = -1;
                        throw new IOException("error reading mp3 with id=" + _eid);
                    }
                    ((OutputStream)out).write(buffer, 0, k);
                }
                ((OutputStream)out).close();
                FileInputStream in = new FileInputStream(new File(FileEnvironment.getAudioDirectory(book.getID()), _eid + ".mp3"));
                byte[] _buffer = new byte[Math.min(10, e[1])];
                for (int j = 0; j < _buffer.length; j += ((InputStream)in).read(_buffer, j, _buffer.length - j)) {
                }
                ((InputStream)in).close();
                if (!Importer.isMp3Data(_buffer)) {
                    if (e[1] == 0) {
                        System.err.println("extracted no data for oid=" + _eid + " (file is empty)");
                    } else {
                        System.err.println("extracted data for oid=" + _eid + " seems to be not an mp3 or is corrupted");
                    }
                }
                entry.setMP3(new File(FileEnvironment.getAudioDirectory(book.getID()), _eid + ".mp3"));
                entry.setMP3();
            } else if (scriptFile != null) {
                if (scripts.get(e[3]) == null) {
                    System.err.println("\tid " + _eid + " not found in script");
                    throw new IOException("id " + _eid + " not found in script");
                }
                Script script = new Script((String)scripts.get(e[3]), entry);
                entry.setScript(script);
                if (script.isSub()) {
                    entry.setSub();
                } else {
                    entry.setCode();
                }
            } else {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                FileOutputStream bin = new FileOutputStream(FileEnvironment.getBinObjectFile(book.getID(), entry.getTingID()));
                for (int len = e[1]; len > 0; len -= k) {
                    k = ouf.read(buffer, 0, Math.min(buffer.length, len));
                    if (k <= 0) {
                        System.err.println("error reading bin with id=" + _eid);
                        len = -1;
                        throw new IOException("error reading bin with id=" + _eid);
                    }
                    bout.write(buffer, 0, k);
                    ((OutputStream)bin).write(buffer, 0, k);
                }
                ((OutputStream)bin).close();
                Script script = new Script(bout.toByteArray(), entry);
                entry.setScript(script);
                if (script.isSub()) {
                    entry.setSub();
                } else {
                    entry.setCode();
                }
            }
            String note = (String)notes.get(e[3]);
            if (note != null) {
                entry.setHint(note);
            }
            ouf.close();
        }
    }

    private static boolean isMp3Data(byte[] data) {
        if (data.length <= 3) {
            return false;
        }
        if (data[0] == 73 && data[1] == 68 && data[2] == 51) {
            return true;
        }
        return data[0] == 73 && data[1] == 68 && data[2] == 51 || (data[0] & 0xFF) == 255 && (data[1] & 0xFF) == 242 || (data[0] & 0xFF) == 255 && (data[1] & 0xFF) == 243 || (data[0] & 0xFF) == 255 && (data[1] & 0xFF) == 250 || (data[0] & 0xFF) == 255 && (data[1] & 0xFF) == 251 || (data[0] & 0xFF) == 255 && (data[1] & 0xFF) == 0;
    }

    private static boolean isScriptData(byte[] data) {
        if (data.length > 3 && data[0] == 0 && data[1] == 0 && data[2] == 0 && data[3] == 0) {
            return false;
        }
        int p = 0;
        while (p + 1 < data.length) {
            int opcode = data[p + 1] & 0xFF | (data[p] & 0xFF) << 8;
            Command command = Commands.getCommand(opcode);
            if (command == null) {
                return false;
            }
            p += command.getNumberOfArguments() * 2 + 2;
        }
        return true;
    }
}

