/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListDataListener;
import tingeltangel.core.Repository;
import tingeltangel.tools.Progress;
import tingeltangel.tools.ProgressDialog;

public class RepositoryManager
extends JFrame {
    private MyListModel model = new MyListModel();
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JScrollPane jScrollPane1;
    private JList list;
    private JMenuItem search;
    private JMenuItem update;

    public RepositoryManager() {
        this.initComponents();
        this.list.setModel(this.model);
        this.list.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Map txt = (Map)value;
                JLabel label = new JLabel((String)txt.get("ID") + ": " + (String)txt.get("Name") + " (" + (String)txt.get("Author") + ")");
                if (Repository.exists(Integer.parseInt((String)txt.get("ID")))) {
                    label.setBackground(Color.green);
                    label.setOpaque(true);
                }
                return label;
            }
        });
        this.update();
        final JList _list = this.list;
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(final MouseEvent evt) {
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() == 2) {
                    new Progress(RepositoryManager.this, "Suche nach Aktualisierungen"){

                        @Override
                        public void action(ProgressDialog progressDialog) {
                            try {
                                int index = _list.locationToIndex(evt.getPoint());
                                Map txt = (Map)RepositoryManager.this.model.getElementAt(index);
                                int id = Integer.parseInt((String)txt.get("ID"));
                                if (Repository.exists(id)) {
                                    Repository.update(id, progressDialog);
                                } else {
                                    Repository.download(id, progressDialog);
                                }
                            }
                            catch (IOException e) {
                                JOptionPane.showMessageDialog(RepositoryManager.this, "Download fehlgeschlagen: " + e.toString());
                                e.printStackTrace(System.out);
                            }
                            RepositoryManager.this.update();
                        }
                    };
                    int index = list.locationToIndex(evt.getPoint());
                    Map txt = (Map)RepositoryManager.this.model.getElementAt(index);
                    int id = Integer.parseInt((String)txt.get("ID"));
                    try {
                        if (Repository.exists(id)) {
                            Repository.download(id, null);
                        } else {
                            Repository.update(id, null);
                        }
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(RepositoryManager.this, "Download fehlgeschlagen: " + ioe.getMessage());
                    }
                }
            }
        });
    }

    private void update() {
        this.model.update();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.list = new JList();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.update = new JMenuItem();
        this.search = new JMenuItem();
        this.list.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.list);
        this.jMenu1.setText("Aktionen");
        this.update.setText("aktualisieren");
        this.update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepositoryManager.this.updateActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.update);
        this.search.setText("neue B\u00fccher suchen");
        this.search.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepositoryManager.this.searchActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.search);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 380, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 257, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void updateActionPerformed(ActionEvent evt) {
        new Progress(this, "Suche nach Aktualisierungen"){

            @Override
            public void action(ProgressDialog progressDialog) {
                try {
                    Repository.update(progressDialog);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(RepositoryManager.this, "Suche nach Aktualisierungen fehlgeschlagen");
                    e.printStackTrace(System.out);
                }
                catch (IllegalArgumentException e) {
                    JOptionPane.showMessageDialog(RepositoryManager.this, "Suche nach Aktualisierungen fehlgeschlagen: " + e.getMessage());
                }
                RepositoryManager.this.update();
            }
        };
    }

    private void searchActionPerformed(ActionEvent evt) {
        new Progress(this, "Suche nach neuen B\u00fcchern"){

            @Override
            public void action(ProgressDialog progressDialog) {
                try {
                    Repository.search(progressDialog);
                }
                catch (IllegalArgumentException e) {
                    JOptionPane.showMessageDialog(RepositoryManager.this, "Suche nach neuen B\u00fcchern fehlgeschlagen: " + e.getMessage());
                }
                RepositoryManager.this.update();
            }
        };
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(RepositoryManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(RepositoryManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(RepositoryManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(RepositoryManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new RepositoryManager().setVisible(true);
            }
        });
    }

    class MyListModel
    implements ListModel {
        private Set<ListDataListener> listeners = new HashSet<ListDataListener>();

        MyListModel() {
        }

        @Override
        public int getSize() {
            Integer[] ids = Repository.getIDs();
            return ids.length;
        }

        public Object getElementAt(int index) {
            int id = Repository.getIDs()[index];
            HashMap<String, String> txt = Repository.getBookTxt(id);
            String _id = Integer.toString(id);
            while (_id.length() < 5) {
                _id = "0" + _id;
            }
            txt.put("ID", _id);
            return txt;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        void update() {
            Iterator<ListDataListener> i = this.listeners.iterator();
            while (i.hasNext()) {
                i.next().contentsChanged(null);
            }
        }
    }
}

