/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import tingeltangel.core.Book;
import tingeltangel.core.SortedIntList;
import tingeltangel.core.scripting.RegisterListener;
import tingeltangel.gui.MasterFrame;

public class RegisterFrame
extends JInternalFrame
implements RegisterListener {
    private SortedIntList registers = new SortedIntList();
    private JTable table;
    private RegisterTableModel model;
    private final MasterFrame frame;

    public RegisterFrame(MasterFrame frame) {
        super("Register", true, true, true, true);
        this.setVisible(true);
        this.setBounds(610, 345, 300, 250);
        this.setDefaultCloseOperation(1);
        this.frame = frame;
        this.model = new RegisterTableModel();
        this.table = new JTable(this.model);
        this.setContentPane(new JScrollPane(this.table));
    }

    @Override
    public void registerChanged(int register, int value) {
        this.registers.add(register);
        this.model.pushEvent(new TableModelEvent(this.model));
    }

    class RegisterTableModel
    implements TableModel {
        private HashSet<TableModelListener> listeners = new HashSet();

        RegisterTableModel() {
        }

        @Override
        public int getRowCount() {
            return RegisterFrame.this.registers.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Register";
                }
                case 1: {
                    return "Bemerkung";
                }
                case 2: {
                    return "Wert";
                }
            }
            throw new Error();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return true;
                }
            }
            throw new Error();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Book book = RegisterFrame.this.frame.getBook();
            switch (columnIndex) {
                case 0: {
                    return RegisterFrame.this.registers.get(rowIndex);
                }
                case 1: {
                    return book.getEmulator().getHint(RegisterFrame.this.registers.get(rowIndex));
                }
                case 2: {
                    return book.getEmulator().getRegister(RegisterFrame.this.registers.get(rowIndex));
                }
            }
            throw new Error();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Book book = RegisterFrame.this.frame.getBook();
            switch (columnIndex) {
                case 1: {
                    book.getEmulator().setHint(RegisterFrame.this.registers.get(rowIndex), (String)aValue);
                    this.pushEvent(new TableModelEvent(this, rowIndex, rowIndex, 1));
                    break;
                }
                case 2: {
                    int value = 0;
                    try {
                        value = Integer.parseInt((String)aValue);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    book.getEmulator().setRegister(RegisterFrame.this.registers.get(rowIndex), value);
                    this.pushEvent(new TableModelEvent(this, rowIndex, rowIndex, 1));
                }
            }
        }

        private void pushEvent(TableModelEvent event) {
            Iterator<TableModelListener> i = this.listeners.iterator();
            while (i.hasNext()) {
                i.next().tableChanged(event);
            }
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }
    }
}

