/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import tingeltangel.core.Entry;
import tingeltangel.core.Script;
import tingeltangel.core.scripting.SyntaxError;
import tingeltangel.gui.EntryListener;
import tingeltangel.gui.MasterFrame;

public class CodeFrame
extends JInternalFrame
implements EntryListener,
ActionListener {
    private JTextArea text = new JTextArea();
    private Script currentScript = null;
    private DocumentListener docListener;
    private MasterFrame frame;

    public CodeFrame(MasterFrame frame) {
        super("Code Editor", true, true, true, true);
        this.frame = frame;
        this.setVisible(true);
        this.setBounds(915, 5, 260, 590);
        this.setDefaultCloseOperation(1);
        this.text.setEnabled(false);
        this.docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (CodeFrame.this.currentScript != null) {
                    CodeFrame.this.currentScript.setCode(CodeFrame.this.text.getText());
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (CodeFrame.this.currentScript != null) {
                    CodeFrame.this.currentScript.setCode(CodeFrame.this.text.getText());
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.text.getDocument().addDocumentListener(this.docListener);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(2, 1));
        JButton syntaxCheck = new JButton("Syntax Check (alle)");
        syntaxCheck.setActionCommand("check_all");
        syntaxCheck.addActionListener(this);
        buttons.add(syntaxCheck);
        JButton reference = new JButton("Syntax Check (nur dieses Skript)");
        reference.setActionCommand("check");
        reference.addActionListener(this);
        buttons.add(reference);
        panel.add((Component)buttons, "North");
        panel.add((Component)new JScrollPane(this.text), "Center");
        this.setContentPane(panel);
        frame.addEntryListener(this);
    }

    @Override
    public void entrySelected(Entry entry) {
        if (entry.isCode() || entry.isSub()) {
            this.text.setEnabled(true);
            this.currentScript = entry.getScript();
            if (this.currentScript == null) {
                this.currentScript = new Script("", entry);
                entry.setScript(this.currentScript);
            }
            this.text.setText(this.currentScript.toString());
        } else {
            this.text.getDocument().removeDocumentListener(this.docListener);
            this.text.setText("-");
            this.text.getDocument().addDocumentListener(this.docListener);
            this.text.setEnabled(false);
            this.currentScript = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("check")) {
            if (this.currentScript != null) {
                try {
                    this.currentScript.compile();
                    JOptionPane.showMessageDialog(this.frame, "Keine Syntax Fehler gefunden", "Syntax Test", 1);
                }
                catch (SyntaxError se) {
                    JOptionPane.showMessageDialog(this.frame, "Syntax Fehler in Zeile " + se.getRow() + ": " + se.getMessage(), "Syntax Fehler", 0);
                }
            }
        } else if (e.getActionCommand().equals("check_all")) {
            StringBuilder sb = new StringBuilder();
            for (int id = 15001; id <= this.frame.getBook().getLastID(); ++id) {
                Entry entry = this.frame.getBook().getEntryFromTingID(id);
                if (!entry.isCode() && !entry.isSub()) continue;
                Script script = entry.getScript();
                try {
                    script.compile();
                    continue;
                }
                catch (SyntaxError se) {
                    sb.append("Skript ").append(id).append(" Zeile ").append(se.getRow()).append(": ").append(se.getMessage()).append("\n");
                }
            }
            if (sb.length() > 0) {
                JOptionPane.showMessageDialog(this.frame, sb.toString(), "Syntax Fehler", 0);
            } else {
                JOptionPane.showMessageDialog(this.frame, "Keine Syntax Fehler gefunden", "Syntax Test", 1);
            }
        }
    }
}

