/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.core;

import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import tingeltangel.core.PlaylistEntry;
import tingeltangel.tools.Binary;

public class MP3Player {
    private Process process = null;
    private LinkedList<PlaylistEntry> playlist = new LinkedList();
    private PlaylistEntry current = null;
    private HashSet<ActionListener> listeners = new HashSet();
    private static MP3Player _player = new MP3Player();

    private MP3Player() {
    }

    public static MP3Player getPlayer() {
        return _player;
    }

    private synchronized void _add(PlaylistEntry x) {
        this.playlist.add(x);
    }

    private synchronized void _clear() {
        this.playlist.clear();
    }

    private synchronized PlaylistEntry _poll() {
        return this.playlist.poll();
    }

    private synchronized boolean _isEmpty() {
        return this.playlist.isEmpty();
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    private void playlistChanged() {
        Iterator<ActionListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().actionPerformed(null);
        }
    }

    public void add(File file, String hint, float length) {
        System.out.println("mp3 player: add to playlist " + file.getAbsolutePath());
        this._add(new PlaylistEntry(file, hint, length));
        this.playlistChanged();
        new Thread(){

            @Override
            public void run() {
                MP3Player.this.play();
            }
        }.start();
    }

    public void addPause(int ms) {
        this._add(new PlaylistEntry(ms));
        this.playlistChanged();
        new Thread(){

            @Override
            public void run() {
                MP3Player.this.play();
            }
        }.start();
    }

    public void stopAndClean() {
        if (this.process != null) {
            this.process.destroy();
            this._clear();
            this.playlistChanged();
        }
    }

    public String getCurrent() {
        if (this.current == null) {
            return "";
        }
        return this.current.toString();
    }

    public String getPlaylist() {
        String s = "";
        Iterator iterator = this.playlist.iterator();
        while (iterator.hasNext()) {
            s = s + ((PlaylistEntry)iterator.next()).toString();
            if (!iterator.hasNext()) continue;
            s = s + "\n";
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void play() {
        block23: {
            if (this.process != null) {
                try {
                    this.process.exitValue();
                }
                catch (IllegalThreadStateException e) {
                    return;
                }
                catch (IllegalStateException e) {
                    return;
                }
            }
            File mpg123 = Binary.getBinary("mpg123");
            this.current = this._poll();
            this.playlistChanged();
            if (this.current != null) {
                if (this.current.isPause()) {
                    MP3Player mP3Player = this;
                    synchronized (mP3Player) {
                        try {
                            System.out.println("mp3 player: pause " + this.current.getPause() + "ms");
                            this.wait(this.current.getPause());
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                    }
                }
                try {
                    System.out.println("mp3 player: " + this.current.getMP3().getAbsolutePath());
                    if (mpg123 != null) {
                        this.process = new ProcessBuilder(mpg123.getCanonicalPath(), this.current.getMP3().getAbsolutePath()).start();
                        try {
                            this.process.waitFor();
                        }
                        catch (InterruptedException ex) {}
                        break block23;
                    }
                    MP3Player ex = this;
                    synchronized (ex) {
                        try {
                            System.out.println("pause " + (int)(this.current.getLength() * 1000.0f) + "ms");
                            this.wait((int)(this.current.getLength() * 1000.0f));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(System.out);
                }
            }
        }
        this.current = null;
        if (!this._isEmpty()) {
            this.play();
        } else {
            this.playlistChanged();
        }
    }
}

