/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import tingeltangel.core.Book;
import tingeltangel.core.Mp3Utils;
import tingeltangel.core.Script;
import tingeltangel.core.TTSEntry;
import tingeltangel.core.scripting.SyntaxError;
import tingeltangel.tools.FileEnvironment;
import tingeltangel.tools.TTS;

public class Entry {
    private static final int EMPTY = 0;
    private static final int MP3 = 1;
    private static final int CODE = 2;
    private static final int SUB = 3;
    private static final int T2S = 4;
    private File mp3 = null;
    private Script script = null;
    private TTSEntry tts = null;
    private float mp3length = -1.0f;
    private int size = -1;
    private Book book;
    private String hint = "";
    private int type = 0;
    private int tingID = -1;

    public Entry(Book book, int tingID) {
        this.book = book;
        this.tingID = tingID;
    }

    public Book getBook() {
        return this.book;
    }

    public int getTingID() {
        return this.tingID;
    }

    public int getSize() throws SyntaxError {
        if (this.isMP3() || this.isTTS()) {
            return this.size;
        }
        if ((this.isCode() || this.isSub()) && this.script != null) {
            return this.script.getSize(false);
        }
        return 0;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint.trim();
        this.changeMade();
    }

    void changeMade() {
        this.book.changeMade();
    }

    public File getMP3() {
        if (this.type == 1) {
            return this.mp3;
        }
        File ttsMp3 = new File(FileEnvironment.getAudioDirectory(this.book.getID()), "tts_" + this.tingID + ".mp3");
        if (!ttsMp3.canRead()) {
            try {
                TTS.generate(this.tts.text, this.tts.amplitude, this.tts.pitch, this.tts.speed, this.tts.voice, this.tts.variant, ttsMp3);
                if (!ttsMp3.canRead()) {
                    return null;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return null;
            }
        }
        this.size = (int)ttsMp3.length();
        return ttsMp3;
    }

    public boolean isMP3() {
        return this.type == 1;
    }

    public boolean isTTS() {
        return this.type == 4;
    }

    public boolean isCode() {
        return this.type == 2;
    }

    public boolean isEmpty() {
        return this.type == 0;
    }

    public boolean isSub() {
        return this.type == 3;
    }

    public void setEmpty() {
        this.type = 0;
        this.changeMade();
    }

    public void setMP3() {
        this.type = 1;
        this.changeMade();
    }

    public void setTTS() {
        this.type = 4;
        this.changeMade();
    }

    public void setCode() {
        this.type = 2;
        this.changeMade();
    }

    public void setSub() {
        this.type = 3;
        this.changeMade();
    }

    public float getLength() {
        return this.mp3length;
    }

    public boolean hasCode() {
        return !this.isEmpty();
    }

    public void setScript(Script script) {
        this.script = script;
        this.mp3 = null;
        this.tts = null;
        this.type = 2;
        this.changeMade();
    }

    public void setTTS(TTSEntry tts) {
        this.tts = tts;
        this.mp3 = null;
        this.script = null;
        this.type = 4;
        this.getMP3();
        this.changeMade();
    }

    public TTSEntry getTTS() {
        return this.tts;
    }

    public Script getScript() {
        return this.script;
    }

    public void setMP3(File mp3) throws IOException {
        this.changeMade();
        String name = mp3.getAbsolutePath();
        if (!mp3.isFile()) {
            this.mp3 = null;
            this.mp3length = -1.0f;
            throw new FileNotFoundException(name);
        }
        if (!mp3.canRead()) {
            this.mp3 = null;
            this.mp3length = -1.0f;
            throw new FileNotFoundException(name);
        }
        File target = new File(FileEnvironment.getAudioDirectory(this.book.getID()), mp3.getName());
        if (!mp3.equals(target)) {
            FileEnvironment.copy(mp3, target);
        }
        this.mp3 = target;
        try {
            this.mp3length = (float)Mp3Utils.getDuration(this.mp3) / 1000.0f;
        }
        catch (IOException e) {
            this.mp3 = null;
            throw e;
        }
        this.size = (int)mp3.length();
        this.script = null;
        this.tts = null;
        this.type = 1;
    }
}

