/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.tools;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import tingeltangel.core.Tupel;
import tingeltangel.tools.MyComparator;

public class TTS {
    private static final String ESPEAK_DATA;
    private static final String ESPEAK_BIN;
    private static final String LAME;
    private static final SortedSet<Tupel<String, String>> eVoices;
    private static final SortedSet<Tupel<String, String>> mVoices;
    private static final SortedSet<Tupel<String, String>> variants;

    private static String getLangName(File langFile) throws IOException {
        String r;
        BufferedReader in = new BufferedReader(new FileReader(langFile));
        while ((r = in.readLine()) != null) {
            if (!r.trim().toLowerCase().startsWith("name ")) continue;
            in.close();
            return r.trim().substring("name ".length()).trim();
        }
        in.close();
        return "unknown";
    }

    private static void addLanguageFiles(File dir, String prefix, SortedSet<Tupel<String, String>> set) throws IOException {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getName().startsWith(".")) continue;
            set.add(new Tupel<String, String>(prefix + files[i].getName(), TTS.getLangName(files[i])));
        }
    }

    public static void generate(final String text, int amplitude, int pitch, int speed, String voice, String variant, final File mp3) throws IOException {
        speed = Math.max(Math.min(speed, 450), 80);
        amplitude = Math.max(Math.min(amplitude, 200), 0);
        pitch = Math.max(Math.min(pitch, 99), 0);
        variant = variant == null || variant.isEmpty() ? "" : "+" + variant;
        String[] cmd1 = new String[]{ESPEAK_BIN, "--stdin", "--stdout", "-b", "1", "-z", "-a", Integer.toString(amplitude), "-p", Integer.toString(pitch), "-s", Integer.toString(speed), "-v", voice + variant};
        String[] cmd2 = new String[]{LAME, "-", "-"};
        final Process p1 = new ProcessBuilder(cmd1).start();
        final Process p2 = new ProcessBuilder(cmd2).start();
        new Thread(){

            @Override
            public void run() {
                try {
                    InputStream in = p2.getInputStream();
                    InputStream err = p2.getErrorStream();
                    FileOutputStream out = new FileOutputStream(mp3);
                    TTS.copyStream(in, err, out);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }.start();
        new Thread(){

            @Override
            public void run() {
                try {
                    InputStream in = p1.getInputStream();
                    InputStream err = p1.getErrorStream();
                    OutputStream out = p2.getOutputStream();
                    TTS.copyStream(in, err, out);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }.start();
        new Thread(){

            @Override
            public void run() {
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(text.getBytes(Charset.forName("UTF-8")));
                    OutputStream out = p1.getOutputStream();
                    TTS.copyStream(in, null, out);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }.start();
        try {
            p2.waitFor();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    private static void copyStream(InputStream in, final InputStream err, OutputStream out) throws IOException {
        if (err != null) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        int i;
                        byte[] b = new byte[4096];
                        while ((i = err.read(b)) >= 0) {
                        }
                        return;
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        return;
                    }
                }
            }.start();
        }
        byte[] buffer = new byte[4096];
        int c = 0;
        while (true) {
            int i;
            if ((i = in.read(buffer)) < 0) {
                out.close();
                return;
            }
            c += i;
            out.write(buffer, 0, i);
            out.flush();
        }
    }

    public static void main(String[] args) throws IOException {
        System.out.println("eSpeak voices:");
        for (Tupel tupel : eVoices) {
            System.out.println("\t" + (String)tupel.a + "\t" + (String)tupel.b);
        }
        System.out.println("mbrola voices:");
        for (Tupel tupel : mVoices) {
            System.out.println("\t" + (String)tupel.a + "\t" + (String)tupel.b);
        }
        System.out.println("variants:");
        for (Tupel tupel : variants) {
            System.out.println("\t" + (String)tupel.a + "\t" + (String)tupel.b);
        }
        TTS.generate("Hallo, ich bin Tingeltangel.", 100, 50, 100, "mb/mb-de2", "", new File("c:\\Users\\mdames\\Desktop\\test.mp3"));
    }

    static {
        eVoices = new TreeSet<Tupel<String, String>>(new MyComparator());
        mVoices = new TreeSet<Tupel<String, String>>(new MyComparator());
        variants = new TreeSet<Tupel<String, String>>(new MyComparator());
        try {
            if (System.getProperty("os.name").startsWith("Windows")) {
                ESPEAK_BIN = "c:\\Program Files (x86)\\eSpeak\\command_line\\espeak.exe";
                ESPEAK_DATA = "c:\\Program Files (x86)\\eSpeak\\espeak-data";
                LAME = "c:\\Users\\mdames\\Desktop\\lame3.99.5\\lame.exe";
            } else {
                ESPEAK_BIN = "espeak";
                ESPEAK_DATA = "/usr/lib/i386-linux-gnu/espeak-data";
                LAME = "lame";
            }
            File voices = new File(new File(ESPEAK_DATA), "voices");
            File[] files = voices.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].getName().startsWith(".")) continue;
                if (files[i].isDirectory()) {
                    String dir = files[i].getName();
                    if (dir.equals("!v")) {
                        TTS.addLanguageFiles(files[i], "", variants);
                        continue;
                    }
                    if (dir.equals("mb")) {
                        TTS.addLanguageFiles(files[i], dir + "/", mVoices);
                        continue;
                    }
                    TTS.addLanguageFiles(files[i], dir + "/", eVoices);
                    continue;
                }
                eVoices.add(new Tupel<String, String>(files[i].getName(), TTS.getLangName(files[i])));
            }
            Iterator i = mVoices.iterator();
            File mbrola = new File(new File(ESPEAK_DATA), "mbrola");
            while (i.hasNext()) {
                String langName = ((String)((Tupel)i.next()).a).substring("mb/mb-".length());
                if (new File(mbrola, langName).exists()) continue;
                i.remove();
            }
        }
        catch (IOException ioe) {
            throw new Error(ioe);
        }
    }
}

