/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.core;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import tingeltangel.core.Entry;
import tingeltangel.core.scripting.Command;
import tingeltangel.core.scripting.Commands;
import tingeltangel.core.scripting.Disassembler;
import tingeltangel.core.scripting.Instance;
import tingeltangel.core.scripting.SyntaxError;

public class Script {
    private Entry entry;
    private String code;
    private LinkedList<Instance> script = null;
    private HashMap<String, Integer> instanceLabelsSI = null;
    private HashMap<Integer, Integer> instanceLabelsII = null;
    private int labelCounter = 0;

    public Script(String code, Entry entry) {
        this.entry = entry;
        this.code = code;
    }

    public Script(byte[] binary, Entry entry) throws SyntaxError {
        this.entry = entry;
        this.code = new Disassembler().disassemble(binary);
    }

    void changeMade() {
        this.entry.changeMade();
    }

    public void setCode(String code) {
        this.code = code;
        this.changeMade();
    }

    public String toString() {
        return this.code;
    }

    public int getSize(boolean calledFromScript) throws SyntaxError {
        int rc = 0;
        int size = 0;
        try {
            String row;
            BufferedReader in = new BufferedReader(new StringReader(this.code));
            while ((row = in.readLine()) != null) {
                ++rc;
                if ((row = row.trim()).isEmpty() || row.startsWith("//") || row.startsWith(":")) continue;
                int p = row.indexOf(" ");
                String args = "";
                if (p != -1) {
                    args = row.substring(p + 1).trim();
                    row = row.substring(0, p);
                }
                if (row.startsWith(":")) continue;
                if (row.startsWith("call")) {
                    System.out.println(args);
                    try {
                        Script sub = this.entry.getBook().getEntryByID(Integer.parseInt(args)).getScript();
                        if (sub == null) {
                            throw new SyntaxError("methode nicht gefunden (oid=" + args + ")");
                        }
                        size += sub.getSize(true);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new SyntaxError("call ben\u00f6tigt als Argument eine OID");
                    }
                }
                if (row.equals("return") && calledFromScript) {
                    size += 4;
                    continue;
                }
                size += Commands.getSize(row);
            }
        }
        catch (IOException ioe) {
            throw new Error(ioe);
        }
        catch (SyntaxError se) {
            se.setRow(rc);
            se.setTingID(this.entry.getTingID());
            throw se;
        }
        return size + 1;
    }

    public boolean isSub() {
        try {
            String row;
            BufferedReader in = new BufferedReader(new StringReader(this.code));
            while ((row = in.readLine()) != null) {
                if (!row.trim().startsWith("return")) continue;
                in.close();
                return true;
            }
            in.close();
        }
        catch (IOException e) {
            throw new Error(e);
        }
        return false;
    }

    public void execute() throws SyntaxError {
        this.compile();
        int p = 0;
        while (true) {
            if (p >= this.script.size()) {
                SyntaxError error = new SyntaxError("missing 'end' command");
                error.setTingID(this.entry.getTingID());
                error.setRow(-1);
                throw error;
            }
            Instance instance = this.script.get(p);
            if (instance.getCommand().getAsm().equals("end")) {
                return;
            }
            if (instance.getCommand().getAsm().equals("call")) {
                int oid = instance.getFirstArgument();
                this.entry.getBook().getEntryByID(oid).getScript().execute();
                continue;
            }
            if (instance.getCommand().getAsm().equals("return")) {
                return;
            }
            boolean doJump = instance.execute(this.entry.getBook().getEmulator());
            if (doJump) {
                p = this.instanceLabelsII.get(instance.getLabel());
                continue;
            }
            ++p;
        }
    }

    private String mergeCodeOnCalls() throws IOException, SyntaxError {
        String row;
        String returnLabel = "return_" + this.labelCounter++;
        StringBuilder mergedCode = new StringBuilder();
        BufferedReader in = new BufferedReader(new StringReader(this.code));
        int rc = 0;
        while ((row = in.readLine()) != null) {
            ++rc;
            if ((row = row.trim()).isEmpty() || row.startsWith("//")) continue;
            if (row.startsWith("call")) {
                try {
                    int oid = Integer.parseInt(row.substring("code".length()).trim());
                    String subCode = this.entry.getBook().getEntryByID(oid).getScript().mergeCodeOnCalls();
                    mergedCode.append(subCode);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    SyntaxError error = new SyntaxError("call needs a value as argument");
                    error.setRow(rc);
                    error.setTingID(this.entry.getTingID());
                    throw error;
                }
            }
            if (row.equals("return")) {
                mergedCode.append("jmp ").append(returnLabel).append("\n");
                continue;
            }
            mergedCode.append(row).append("\n");
        }
        in.close();
        mergedCode.append(":").append(returnLabel).append("\n");
        return mergedCode.toString();
    }

    public byte[] compile() throws SyntaxError {
        HashMap<String, Integer> labels = new HashMap<String, Integer>();
        this.instanceLabelsSI = new HashMap();
        this.instanceLabelsII = new HashMap();
        this.script = new LinkedList();
        int rc = 0;
        try {
            String cmd;
            int p;
            String row;
            String mergedCode = this.mergeCodeOnCalls();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bout);
            BufferedReader in = new BufferedReader(new StringReader(mergedCode.toString()));
            int position = 0;
            int instancePos = 0;
            while ((row = in.readLine()) != null) {
                ++rc;
                if ((row = row.trim()).isEmpty() || row.startsWith("//")) continue;
                if ((row = row.trim()).startsWith(":")) {
                    labels.put(row.substring(1).trim(), position);
                    this.instanceLabelsSI.put(row.substring(1).trim(), instancePos);
                    continue;
                }
                p = row.indexOf(" ");
                cmd = row;
                if (p != -1) {
                    cmd = row.substring(0, p);
                }
                position += Commands.getSize(cmd);
                ++instancePos;
            }
            in.close();
            in = new BufferedReader(new StringReader(mergedCode.toString()));
            rc = 0;
            while ((row = in.readLine()) != null) {
                ++rc;
                if ((row = row.trim()).isEmpty() || row.startsWith("//") || row.startsWith(":")) continue;
                p = row.indexOf(" ");
                cmd = row;
                String args = null;
                if (p != -1) {
                    cmd = row.substring(0, p).trim();
                    args = row.substring(p).trim();
                }
                Command command = null;
                String arg1 = null;
                String arg2 = null;
                switch (Commands.getArguments(cmd)) {
                    case 0: {
                        command = Commands.getCommand(cmd);
                        break;
                    }
                    case 1: {
                        arg1 = args;
                        command = Commands.getCommand(cmd, arg1);
                        break;
                    }
                    case 2: {
                        p = args.indexOf(",");
                        arg1 = args.substring(0, p).trim();
                        arg2 = args.substring(p + 1).trim();
                        command = Commands.getCommand(cmd, arg1, arg2);
                    }
                }
                Instance instance = new Instance(command);
                if (command.firstArgumentIsLabel()) {
                    instance.setLabel((Integer)labels.get(arg1));
                    this.instanceLabelsII.put(instance.getLabel(), this.instanceLabelsSI.get(arg1));
                } else {
                    if (Commands.getArguments(cmd) > 0) {
                        instance.setFirstArgument(arg1);
                    }
                    if (Commands.getArguments(cmd) > 1) {
                        instance.setSecondArgument(arg2);
                    }
                }
                instance.compile(out);
                this.script.add(instance);
            }
            in.close();
            out.write(0);
            out.flush();
            byte[] result = bout.toByteArray();
            out.close();
            return result;
        }
        catch (IOException ioe) {
            throw new Error(ioe);
        }
        catch (SyntaxError se) {
            if (se.getRow() < 0) {
                se.setRow(rc);
                se.setTingID(this.entry.getTingID());
            }
            throw se;
        }
    }
}

