/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;

public class Properties {
    private static final String PROPERTY_FILE = "tt.properties";
    private static final HashMap<String, String> PROPERTIES = new HashMap();
    public static final String WIN_MPG123 = "win_mpg123";
    public static final String _PATH = ".path";
    public static final String _ENABLED = ".enabled";

    public static void setProperty(String name, String value) {
        name = name.trim();
        if (value == null) {
            PROPERTIES.remove(name);
        } else {
            PROPERTIES.put(name, value.trim());
        }
        try {
            PrintWriter out = new PrintWriter(new FileWriter(PROPERTY_FILE));
            for (String key : PROPERTIES.keySet()) {
                out.println(key + " = " + PROPERTIES.get(key));
            }
            out.close();
        }
        catch (IOException ioe) {
            System.err.println("property file can not be saved. Your changes will be lost on next start.");
            ioe.printStackTrace(System.err);
        }
    }

    public static void setProperty(String name, int value) {
        Properties.setProperty(name, Integer.toString(value));
    }

    public static String getProperty(String name) {
        return PROPERTIES.get(name.trim());
    }

    public static int getPropertyAsInteger(String name) {
        try {
            return Integer.parseInt(PROPERTIES.get(name));
        }
        catch (NumberFormatException nfe) {
            throw new Error("property '" + name.trim() + "' is not of type int");
        }
    }

    static {
        try {
            String row;
            File propertyFile = new File(PROPERTY_FILE);
            if (propertyFile.createNewFile()) {
                // empty if block
            }
            BufferedReader in = new BufferedReader(new FileReader(propertyFile));
            while ((row = in.readLine()) != null) {
                if ((row = row.trim()).isEmpty() || row.startsWith("#")) continue;
                int p = row.indexOf("=");
                if (p == -1) {
                    throw new IOException();
                }
                PROPERTIES.put(row.substring(0, p).trim(), row.substring(p + 1).trim());
            }
            in.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.out);
            throw new Error(ioe);
        }
    }
}

