/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.core;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import tingeltangel.core.Book;
import tingeltangel.core.Mp3Utils;
import tingeltangel.core.Script;
import tingeltangel.core.scripting.SyntaxError;
import tingeltangel.tools.FileEnvironment;

public class Entry {
    private static final int EMPTY = 0;
    private static final int MP3 = 1;
    private static final int CODE = 2;
    private static final int SUB = 3;
    private File mp3 = null;
    private Script script = null;
    private float mp3length = -1.0f;
    private int size = -1;
    private Book book;
    private String hint = "";
    private int type = 0;
    private int tingID = -1;

    public Entry(Book book, int tingID) {
        this.book = book;
        this.tingID = tingID;
    }

    public Book getBook() {
        return this.book;
    }

    public int getTingID() {
        return this.tingID;
    }

    void save(DataOutputStream out) throws IOException {
        out.writeInt(this.tingID);
        if (this.mp3 == null) {
            out.writeUTF("");
        } else {
            out.writeUTF(this.mp3.getName());
        }
        if (this.script == null) {
            Entry.writeLongUTF(out, "");
        } else {
            Entry.writeLongUTF(out, this.script.toString());
        }
        out.writeInt(this.type);
        out.writeUTF(this.hint);
    }

    public int getSize() throws SyntaxError {
        if (this.isMP3()) {
            return this.size;
        }
        if ((this.isCode() || this.isSub()) && this.script != null) {
            return this.script.getSize(false);
        }
        return 0;
    }

    public static void writeLongUTF(DataOutputStream out, String s) throws IOException {
        byte[] b = s.getBytes(Charset.forName("UTF8"));
        out.writeInt(b.length);
        out.write(b);
    }

    public static String readLongUTF(DataInputStream in) throws IOException {
        int length = in.readInt();
        byte[] b = new byte[length];
        for (int off = 0; off < length; off += in.read(b, off, length - off)) {
        }
        return new String(b, Charset.forName("UTF8"));
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint.trim();
        this.changeMade();
    }

    static Entry load(DataInputStream in, Book book) throws IOException {
        String sScript;
        Entry entry = new Entry(book, in.readInt());
        String sMp3 = in.readUTF();
        if (!sMp3.isEmpty()) {
            entry.mp3 = new File(FileEnvironment.getAudioDirectory(book.getID()), sMp3);
            if (!entry.mp3.canRead()) {
                entry.mp3 = null;
            } else {
                entry.size = (int)entry.mp3.length();
            }
            entry.mp3length = (float)Mp3Utils.getDuration(entry.mp3) / 1000.0f;
        }
        if (!(sScript = Entry.readLongUTF(in)).isEmpty()) {
            entry.script = new Script(sScript, entry);
        }
        entry.type = in.readInt();
        entry.hint = in.readUTF();
        return entry;
    }

    void changeMade() {
        this.book.changeMade();
    }

    public File getMP3() {
        return this.mp3;
    }

    public boolean isMP3() {
        return this.type == 1;
    }

    public boolean isCode() {
        return this.type == 2;
    }

    public boolean isEmpty() {
        return this.type == 0;
    }

    public boolean isSub() {
        return this.type == 3;
    }

    public void setEmpty() {
        this.type = 0;
        this.changeMade();
    }

    public void setMP3() {
        this.type = 1;
        this.changeMade();
    }

    public void setCode() {
        this.type = 2;
        this.changeMade();
    }

    public void setSub() {
        this.type = 3;
        this.changeMade();
    }

    public float getLength() {
        return this.mp3length;
    }

    public boolean hasCode() {
        return !this.isEmpty();
    }

    public void setScript(Script script) {
        this.script = script;
        this.mp3 = null;
        this.type = 2;
        this.changeMade();
    }

    public Script getScript() {
        return this.script;
    }

    public void setMP3(File mp3) throws IOException {
        this.changeMade();
        String name = mp3.getAbsolutePath();
        if (!mp3.isFile()) {
            this.mp3 = null;
            this.mp3length = -1.0f;
            throw new FileNotFoundException(name);
        }
        if (!mp3.canRead()) {
            this.mp3 = null;
            this.mp3length = -1.0f;
            throw new FileNotFoundException(name);
        }
        File target = new File(FileEnvironment.getAudioDirectory(this.book.getID()), mp3.getName());
        if (!mp3.equals(target)) {
            FileEnvironment.copy(mp3, target);
        }
        this.mp3 = target;
        try {
            this.mp3length = (float)Mp3Utils.getDuration(this.mp3) / 1000.0f;
        }
        catch (IOException e) {
            this.mp3 = null;
            throw e;
        }
        this.size = (int)mp3.length();
        this.script = null;
        this.type = 1;
    }
}

