/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.tools;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import tingeltangel.core.Properties;
import tingeltangel.gui.MultipleChoiceDialog;
import tingeltangel.tools.Callback;

public class ExternalBinary {
    public static void getBinaryPath(final String propertyName, final String winExeName, final String linuxExeName, final Callback<String> binaryCallback, final String name, final String question, final String installMessage) {
        if (System.getProperty("os.name").startsWith("Windows")) {
            if (Properties.getProperty(propertyName + ".path") != null) {
                if (Properties.getPropertyAsInteger(propertyName + ".enabled") == 0) {
                    binaryCallback.callback(null);
                } else {
                    File f = new File(Properties.getProperty(propertyName + ".path"));
                    if (f.getName().equals(winExeName) && f.canExecute()) {
                        binaryCallback.callback(f.getAbsolutePath());
                    } else {
                        JOptionPane.showMessageDialog(null, name + " konnte nicht gefunden werden", "Fehler", 2);
                        Properties.setProperty(propertyName + ".path", null);
                        Properties.setProperty(propertyName + ".enabled", null);
                        ExternalBinary.getBinaryPath(propertyName, winExeName, linuxExeName, binaryCallback, name, question, installMessage);
                    }
                }
            } else {
                Callback<String> callback = new Callback<String>(){

                    @Override
                    public void callback(String s) {
                        if (s.equals("install")) {
                            JOptionPane.showMessageDialog(null, installMessage, "Hinweis", 1);
                            ExternalBinary.getBinaryPath(propertyName, winExeName, linuxExeName, binaryCallback, name, question, installMessage);
                        } else if (s.equals("path")) {
                            JFileChooser fc = new JFileChooser();
                            fc.setCurrentDirectory(new File("."));
                            fc.setDialogTitle("Installationsverzeichniss von " + name);
                            fc.setFileFilter(new FileNameExtensionFilter("windows Executable (*.exe)", "exe"));
                            if (fc.showOpenDialog(null) == 0) {
                                File f = fc.getSelectedFile();
                                if (f.getName().equals(winExeName) && f.canExecute()) {
                                    ExternalBinary.setBinaryPath(propertyName, f.getAbsolutePath());
                                    binaryCallback.callback(f.getAbsolutePath());
                                } else {
                                    JOptionPane.showMessageDialog(null, name + " konnte nicht gefunden werden", "Fehler", 2);
                                    ExternalBinary.getBinaryPath(propertyName, winExeName, linuxExeName, binaryCallback, name, question, installMessage);
                                }
                            } else {
                                ExternalBinary.getBinaryPath(propertyName, winExeName, linuxExeName, binaryCallback, name, question, installMessage);
                            }
                        } else if (s.equals("disable")) {
                            ExternalBinary.setBinaryPath(propertyName, null);
                            binaryCallback.callback(null);
                        }
                    }
                };
                String[] options = new String[]{"Ich m\u00f6chte " + name + " installieren", name + " ist installiert. Ich m\u00f6chte den Pfad zu " + name + " angeben.", "Ich verzichte auf " + name + "."};
                String[] actions = new String[]{"install", "path", "disable"};
                MultipleChoiceDialog.show(null, name + " nicht gefunden", question, "OK", options, actions, 0, callback);
            }
        } else {
            String[] path = System.getenv("PATH").split(":");
            for (int i = 0; i < path.length; ++i) {
                File file = new File(new File(path[i]), linuxExeName);
                if (!file.exists() || !file.canExecute()) continue;
                binaryCallback.callback(file.getAbsolutePath());
                return;
            }
            JOptionPane.showMessageDialog(null, "Warnung", name + " konnte nicht gefunden werden", 2);
            binaryCallback.callback(null);
        }
    }

    private static void setBinaryPath(String propertyName, String path) {
        if (path == null) {
            Properties.setProperty(propertyName + ".path", "");
            Properties.setProperty(propertyName + ".enabled", 0);
        } else {
            Properties.setProperty(propertyName + ".path", path);
            Properties.setProperty(propertyName + ".enabled", 1);
        }
    }
}

