/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileNameExtensionFilter;
import tingeltangel.core.Repository;
import tingeltangel.core.Stick;
import tingeltangel.core.scripting.SyntaxError;
import tingeltangel.gui.MasterFrame;
import tingeltangel.gui.MultipleChoiceDialog;
import tingeltangel.tools.Callback;

public class StickFrame
extends JInternalFrame
implements ActionListener {
    private final MasterFrame frame;
    private File stick = null;
    private JPanel mainPanel = new JPanel();
    private JPanel activePanel = new JPanel();
    private JLabel inactivePanel = new JLabel("Kein Ting-Stift gefunden");
    private JLabel spaceLabel = new JLabel();
    private JLabel debugLabel = new JLabel();
    private JTextArea stickBookContent = new JTextArea();
    private JTextArea stickTBDContent = new JTextArea();

    public StickFrame(MasterFrame frame) {
        super("Ting-Stift", true, true, true, true);
        this.frame = frame;
        this.setVisible(false);
        this.setBounds(300, 100, 300, 400);
        this.setDefaultCloseOperation(1);
        JButton refresh = new JButton("aktualisieren");
        refresh.setActionCommand("refresh");
        refresh.addActionListener(this);
        JPanel barPanel = new JPanel();
        barPanel.setLayout(new BorderLayout());
        barPanel.add((Component)refresh, "East");
        this.mainPanel.setLayout(new GridLayout(1, 1));
        this.mainPanel.add(this.inactivePanel);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)barPanel, "North");
        panel.add((Component)this.mainPanel, "Center");
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new GridLayout(2, 2));
        infoPanel.add(new JLabel("freier Speicher"));
        infoPanel.add(this.spaceLabel);
        infoPanel.add(new JLabel("Debug-Modus"));
        infoPanel.add(this.debugLabel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(0, 1));
        JButton currentBookToStickButton = new JButton("aktuelles Buch auf den Stift kopieren");
        currentBookToStickButton.setActionCommand("current2stick");
        currentBookToStickButton.addActionListener(this);
        buttonPanel.add(currentBookToStickButton);
        JButton manualBookDownloadButton = new JButton("manueller Buchdownload");
        manualBookDownloadButton.setActionCommand("official2stick");
        manualBookDownloadButton.addActionListener(this);
        buttonPanel.add(manualBookDownloadButton);
        JButton toBeDownloadedButton = new JButton("automatischer Buchdownload");
        toBeDownloadedButton.setActionCommand("tbd2stick");
        toBeDownloadedButton.addActionListener(this);
        buttonPanel.add(toBeDownloadedButton);
        JButton toggleDebugButton = new JButton("Debugmodus an/aus");
        toggleDebugButton.setActionCommand("debug");
        toggleDebugButton.addActionListener(this);
        buttonPanel.add(toggleDebugButton);
        JButton deleteBookButton = new JButton("Buch vom Stift l\u00f6schen");
        deleteBookButton.setActionCommand("delete");
        deleteBookButton.addActionListener(this);
        buttonPanel.add(deleteBookButton);
        JButton deleteFromTbdButton = new JButton("Buch aus TBD Liste l\u00f6schen");
        deleteFromTbdButton.setActionCommand("deleteFromTbd");
        deleteFromTbdButton.addActionListener(this);
        buttonPanel.add(deleteFromTbdButton);
        JButton updateBooksButton = new JButton("B\u00fccher updaten");
        updateBooksButton.setActionCommand("update");
        updateBooksButton.addActionListener(this);
        buttonPanel.add(updateBooksButton);
        JButton saveButton = new JButton("Stift sichern");
        saveButton.setActionCommand("saveStick");
        saveButton.addActionListener(this);
        buttonPanel.add(saveButton);
        JButton restoreButton = new JButton("Stift wiederherstellen");
        restoreButton.setActionCommand("restoreStick");
        restoreButton.addActionListener(this);
        buttonPanel.add(restoreButton);
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab("B\u00fccher", new JScrollPane(this.stickBookContent));
        tabs.addTab("TBD", new JScrollPane(this.stickTBDContent));
        tabs.addTab("Aktionen", buttonPanel);
        this.activePanel.setLayout(new BorderLayout());
        this.activePanel.add((Component)infoPanel, "North");
        this.activePanel.add((Component)tabs, "Center");
        this.setContentPane(panel);
        this.refresh();
    }

    private static File[] getMountPoints() throws IOException {
        String row;
        if (System.getProperty("os.name").startsWith("Windows")) {
            return File.listRoots();
        }
        LinkedList<File> mounts = new LinkedList<File>();
        Process process = new ProcessBuilder("/bin/mount").start();
        BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((row = in.readLine()) != null) {
            if (!(row = row.trim()).startsWith("/dev/")) continue;
            int p = row.indexOf(" on ");
            row = row.substring(p + " on ".length());
            p = row.indexOf(" ");
            row = row.substring(0, p);
            mounts.add(new File(row));
        }
        return mounts.toArray(new File[0]);
    }

    private void refresh() {
        this.stick = null;
        File[] mounts = new File[]{};
        try {
            mounts = StickFrame.getMountPoints();
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.out);
        }
        for (int i = 0; i < mounts.length; ++i) {
            if (!Stick.checkForStick(mounts[i])) continue;
            this.stick = mounts[i];
        }
        this.mainPanel.removeAll();
        if (this.stick == null) {
            this.mainPanel.add(this.inactivePanel);
            this.pack();
        } else {
            try {
                HashMap<String, String> settings = Stick.getSettings(this.stick);
                boolean debug = false;
                if (settings.get("testpen").equals("yes")) {
                    debug = true;
                }
                this.spaceLabel.setText(Stick.getFreeSpace(this.stick) / 0x100000L + " MB");
                if (debug) {
                    this.debugLabel.setText("an");
                } else {
                    this.debugLabel.setText("aus");
                }
                this.mainPanel.add(this.activePanel);
                this.stickBookContent.setText(Stick.getBookContent(this.stick));
                this.stickTBDContent.setText(Stick.getTBDContent(this.stick));
                this.pack();
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.out);
                this.mainPanel.add(this.inactivePanel);
                JOptionPane.showMessageDialog(this.frame, "Fehler: " + ioe.getMessage());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        try {
            if (action.equals("refresh")) {
                this.refresh();
            } else if (action.equals("current2stick")) {
                this.current2stick();
                this.refresh();
            } else if (action.equals("official2stick")) {
                this.official2stick();
                this.refresh();
            } else if (action.equals("tbd2stick")) {
                this.tbd2stick();
                this.refresh();
            } else if (action.equals("debug")) {
                this.debug();
                this.refresh();
            } else if (action.equals("delete")) {
                this.delete();
                this.refresh();
            } else if (action.equals("deleteFromTbd")) {
                this.deleteFromTbd();
                this.refresh();
            } else if (action.equals("update")) {
                this.updateBooks();
                this.refresh();
            } else if (action.equals("saveStick")) {
                this.saveStick();
            } else if (action.equals("restoreStick")) {
                this.restoreStick();
                this.refresh();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.out);
            JOptionPane.showMessageDialog(this.frame, "Aktion fehlgeschlagen: " + ioe.getMessage());
        }
        catch (SyntaxError se) {
            se.printStackTrace(System.out);
            JOptionPane.showMessageDialog(this.frame, "Aktion fehlgeschlagen: " + se.getMessage());
        }
    }

    private void saveStick() {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileNameExtensionFilter("Tabelle (*.zip)", "zip"));
        if (fc.showSaveDialog(this.frame) == 0) {
            try {
                String file = fc.getSelectedFile().getCanonicalPath();
                if (!file.toLowerCase().endsWith(".zip")) {
                    file = file + ".zip";
                }
                Stick.saveStick(this.stick, new File(file));
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.frame, "Sicherung fehlgeschlagen");
                ex.printStackTrace(System.out);
            }
        }
    }

    private void restoreStick() {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileNameExtensionFilter("Tabelle (*.zip)", "zip"));
        if (fc.showOpenDialog(this.frame) == 0) {
            try {
                String file = fc.getSelectedFile().getCanonicalPath();
                if (!file.toLowerCase().endsWith(".zip")) {
                    file = file + ".zip";
                }
                Stick.restoreStick(this.stick, new File(file));
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.frame, "wiederherstellen der Sicherung fehlgeschlagen");
                ex.printStackTrace(System.out);
            }
        }
    }

    private void current2stick() throws IOException, SyntaxError {
        this.frame.getBook().export(Stick.getBookDir(this.stick), null);
    }

    private void official2stick() {
        Integer[] ids = Repository.getIDs();
        String[] options = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            String m = Integer.toString(ids[i]);
            while (m.length() < 5) {
                m = "0" + m;
            }
            m = m + " " + Repository.getBookTxt(ids[i]).get("Name");
            options[i] = m = m + " (" + Repository.getBookTxt(ids[i]).get("Author") + ")";
        }
        Callback<String> cb = new Callback<String>(){

            @Override
            public void callback(String s) {
                int p = s.indexOf(" ");
                if (p >= 0) {
                    s = s.substring(0, p);
                }
                try {
                    Stick.downloadOfficial(Stick.getBookDir(StickFrame.this.stick), Integer.parseInt(s));
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(System.out);
                    JOptionPane.showMessageDialog(StickFrame.this.frame, "Fehler beim Herunterladen des Buchs: " + ioe.getMessage());
                }
            }
        };
        MultipleChoiceDialog.showDropdown(this.frame, "Buch ausw\u00e4hlen", "Bitte w\u00e4hle ein Buch aus", "OK", options, 0, cb);
    }

    private void debug() throws IOException {
        HashMap<String, String> settings = Stick.getSettings(this.stick);
        if (settings.get("testpen").equals("yes")) {
            settings.put("testpen", "no");
        } else {
            settings.put("testpen", "yes");
        }
        Stick.setSettings(this.stick, settings);
    }

    private void tbd2stick() throws IOException {
        Iterator tbd = Stick.getTBD(this.stick).iterator();
        LinkedList<Integer> newTbd = new LinkedList<Integer>();
        while (tbd.hasNext()) {
            int id = (Integer)tbd.next();
            if (Repository.getBookTxt(id) != null) {
                Stick.downloadOfficial(Stick.getBookDir(this.stick), id);
                continue;
            }
            newTbd.add(id);
        }
        Stick.setTBD(this.stick, newTbd);
    }

    private void updateBooks() throws IOException {
        Iterator books = Stick.getBooks(this.stick).iterator();
        while (books.hasNext()) {
            int id = (Integer)books.next();
            int currentVersion = Stick.getBookVersion(this.stick, id);
            int onlineVersion = Stick.getOnlineBookVersion(id);
            if (onlineVersion <= currentVersion) continue;
            Stick.downloadOfficial(Stick.getBookDir(this.stick), id);
        }
    }

    private void delete() throws IOException {
        Iterator ids = Stick.getBooks(this.stick).iterator();
        String[] options = new String[Stick.getBooks(this.stick).size()];
        int i = 0;
        while (ids.hasNext()) {
            int id = (Integer)ids.next();
            String m = Integer.toString(id);
            while (m.length() < 5) {
                m = "0" + m;
            }
            m = m + " " + Repository.getBookTxt(id).get("Name");
            m = m + " (" + Repository.getBookTxt(id).get("Author") + ")";
            options[i++] = m;
        }
        Callback<String> cb = new Callback<String>(){

            @Override
            public void callback(String s) {
                int p = s.indexOf(" ");
                if (p >= 0) {
                    s = s.substring(0, p);
                }
                Stick.delete(StickFrame.this.stick, Integer.parseInt(s));
            }
        };
        MultipleChoiceDialog.showDropdown(this.frame, "Buch ausw\u00e4hlen", "Bitte w\u00e4hle ein Buch zum L\u00f6schen aus", "OK", options, 0, cb);
    }

    private void deleteFromTbd() throws IOException {
        final LinkedList<Integer> tbd = Stick.getTBD(this.stick);
        Iterator ids = tbd.iterator();
        String[] options = new String[tbd.size()];
        int i = 0;
        while (ids.hasNext()) {
            int id = (Integer)ids.next();
            String m = Integer.toString(id);
            while (m.length() < 5) {
                m = "0" + m;
            }
            m = m + " " + Repository.getBookTxt(id).get("Name");
            m = m + " (" + Repository.getBookTxt(id).get("Author") + ")";
            options[i++] = m;
        }
        Callback<String> cb = new Callback<String>(){

            @Override
            public void callback(String s) {
                int p = s.indexOf(" ");
                if (p >= 0) {
                    s = s.substring(0, p);
                }
                int id = Integer.parseInt(s);
                tbd.remove(id);
                try {
                    Stick.setTBD(StickFrame.this.stick, tbd);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(System.out);
                    JOptionPane.showMessageDialog(StickFrame.this.frame, "Fehler beim L\u00f6schen des Buchs aus der TBD Liste: " + ioe.getMessage());
                }
            }
        };
        MultipleChoiceDialog.showDropdown(this.frame, "Buch ausw\u00e4hlen", "Bitte w\u00e4hle ein Buch zum L\u00f6schen aus", "OK", options, 0, cb);
    }
}

