/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import tingeltangel.core.Book;
import tingeltangel.gui.MasterFrame;

public class PropertyFrame
extends JInternalFrame {
    private JTextField id = new JTextField();
    private JTextField name = new JTextField();
    private JTextField publisher = new JTextField();
    private JTextField author = new JTextField();
    private JTextField version = new JTextField();
    private JTextField url = new JTextField();
    private JTextField magicValue = new JTextField();
    private JTextField date = new JTextField();
    private final MasterFrame masterFrame;
    JTextField[] TEXT_FIELDS = new JTextField[]{this.id, this.name, this.publisher, this.author, this.version, this.url, this.magicValue, this.date};
    String[] TEXT_FIELD_LABELS = new String[]{"ID", "Name", "Verleger", "Autor", "Version", "URL", "unbekannter Wert", "Datum"};
    private DocumentListener dl;

    public PropertyFrame(MasterFrame masterFrame) {
        super("Eigenschaften", true, true, true, true);
        this.setVisible(true);
        this.setBounds(610, 5, 300, 150);
        this.setDefaultCloseOperation(1);
        this.masterFrame = masterFrame;
        Book book = masterFrame.getBook();
        this.id.setText(Integer.toString(book.getID()));
        this.name.setText(book.getName());
        this.publisher.setText(book.getPublisher());
        this.author.setText(book.getAuthor());
        this.version.setText(Integer.toString(book.getVersion()));
        this.url.setText(book.getUrl());
        this.magicValue.setText(Long.toString(book.getMagicValue()));
        this.date.setText(Long.toString(book.getDate()));
        this.id.setEditable(false);
        this.dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PropertyFrame.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PropertyFrame.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PropertyFrame.this.update();
            }
        };
        this.enableListeners(true);
        JPanel labels = new JPanel();
        labels.setLayout(new GridLayout(this.TEXT_FIELD_LABELS.length, 1));
        for (int i = 0; i < this.TEXT_FIELD_LABELS.length; ++i) {
            labels.add(new JLabel(this.TEXT_FIELD_LABELS[i] + ":"));
        }
        JPanel fields = new JPanel();
        fields.setLayout(new GridLayout(this.TEXT_FIELDS.length, 1));
        for (int i = 0; i < this.TEXT_FIELDS.length; ++i) {
            fields.add(this.TEXT_FIELDS[i]);
        }
        JPanel main = new JPanel();
        main.setLayout(new BorderLayout());
        main.add((Component)labels, "West");
        main.add((Component)fields, "Center");
        this.setContentPane(main);
    }

    private void enableListeners(boolean enable) {
        for (int i = 0; i < this.TEXT_FIELDS.length; ++i) {
            if (enable) {
                this.TEXT_FIELDS[i].getDocument().addDocumentListener(this.dl);
                continue;
            }
            this.TEXT_FIELDS[i].getDocument().removeDocumentListener(this.dl);
        }
    }

    public void refresh() {
        this.enableListeners(false);
        Book book = this.masterFrame.getBook();
        this.id.setText(Integer.toString(book.getID()));
        this.name.setText(book.getName());
        this.publisher.setText(book.getPublisher());
        this.author.setText(book.getAuthor());
        this.version.setText(Integer.toString(book.getVersion()));
        this.url.setText(book.getUrl());
        this.magicValue.setText(Long.toString(book.getMagicValue()));
        this.date.setText(Long.toString(book.getDate()));
        this.enableListeners(true);
    }

    public void update() {
        Book book = this.masterFrame.getBook();
        book.setName(this.name.getText());
        book.setPublisher(this.publisher.getText());
        book.setAuthor(this.author.getText());
        try {
            book.setVersion(Integer.parseInt(this.version.getText()));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        book.setURL(this.url.getText());
        try {
            book.setMagicValue(Long.parseLong(this.magicValue.getText()));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        try {
            book.setDate(Long.parseLong(this.date.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

