/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import tingeltangel.core.Entry;
import tingeltangel.core.Translator;
import tingeltangel.core.scripting.SyntaxError;
import tingeltangel.gui.EntryListener;
import tingeltangel.gui.MasterFrame;

public class PlayerFrame
extends JInternalFrame
implements EntryListener,
ActionListener {
    private final MasterFrame frame;
    private Entry entry = null;
    private JLabel description = new JLabel();
    private JLabel length = new JLabel();
    private JLabel tingID = new JLabel();
    private JLabel codeID = new JLabel();
    private JTextArea playlist = new JTextArea();

    public PlayerFrame(final MasterFrame frame) {
        super("Player", true, true, true, true);
        this.frame = frame;
        this.setVisible(true);
        this.setBounds(610, 160, 300, 180);
        this.setDefaultCloseOperation(1);
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(1, 3));
        JButton play = new JButton("PLAY");
        play.setActionCommand("play");
        play.addActionListener(this);
        buttons.add(play);
        JButton stop = new JButton("STOP");
        stop.setActionCommand("stop");
        stop.addActionListener(this);
        buttons.add(stop);
        JPanel props = new JPanel();
        props.setLayout(new GridLayout(4, 2));
        props.add(new JLabel("Bemerkung:"));
        props.add(this.description);
        props.add(new JLabel("Trackl\u00e4nge:"));
        props.add(this.length);
        props.add(new JLabel("Ting ID:"));
        props.add(this.tingID);
        props.add(new JLabel("Code ID:"));
        props.add(this.codeID);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)props, "North");
        panel.add((Component)new JScrollPane(this.playlist), "Center");
        panel.add((Component)buttons, "South");
        this.setContentPane(panel);
        frame.getMP3Player().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayerFrame.this.playlist.setText(frame.getMP3Player().getCurrent() + "\n" + frame.getMP3Player().getPlaylist());
            }
        });
        frame.addEntryListener(this);
    }

    @Override
    public void entrySelected(Entry entry) {
        this.entry = entry;
        this.description.setText(entry.getHint());
        if (entry.isMP3() && entry.getLength() >= 0.0f) {
            this.length.setText(Float.toString(entry.getLength()));
        } else {
            this.length.setText("-");
        }
        this.tingID.setText(Integer.toString(entry.getTingID()));
        int _codeID = Translator.ting2code(entry.getTingID());
        if (_codeID >= 0) {
            this.codeID.setText(Integer.toString(_codeID));
        } else {
            this.codeID.setText("unbekannt");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("play")) {
            if (this.entry != null) {
                if (this.entry.isMP3() && this.entry.getMP3() != null) {
                    String hint = Integer.toString(this.entry.getTingID());
                    String indexHint = this.entry.getHint();
                    if (!indexHint.isEmpty()) {
                        hint = hint + " (" + indexHint + ")";
                    }
                    this.frame.getMP3Player().add(this.entry.getMP3(), hint);
                } else if ((this.entry.isCode() || this.entry.isSub()) && this.entry.getScript() != null) {
                    try {
                        this.entry.getScript().execute();
                    }
                    catch (SyntaxError se) {
                        JOptionPane.showMessageDialog(this, "Syntax Fehler in Zeile " + se.getRow() + " (" + se.getTingID() + ") (" + se.getMessage() + ")", "Syntax Fehler", -1);
                    }
                }
            }
        } else if (e.getActionCommand().equals("stop") && this.entry != null) {
            this.frame.getMP3Player().stopAndClean();
        }
    }
}

