/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.cli;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import tingeltangel.cli.CliCommand;
import tingeltangel.cli.CliSwitch;
import tingeltangel.cli.cmds.Assemble;
import tingeltangel.cli.cmds.BooksScan;
import tingeltangel.cli.cmds.BooksUpdate;
import tingeltangel.cli.cmds.GenerateCode;
import tingeltangel.cli.cmds.GenerateRawCode;
import tingeltangel.cli.cmds.Help;
import tingeltangel.cli.cmds.Import;
import tingeltangel.cli.cmds.OidCode;
import tingeltangel.core.scripting.SyntaxError;

public class CLI {
    private static final Class[] COMMAND_CLASSES = new Class[]{Help.class, GenerateCode.class, GenerateRawCode.class, BooksScan.class, BooksUpdate.class, Import.class, Assemble.class, OidCode.class};
    private static final Map<String, CliCommand> COMMANDS = new HashMap<String, CliCommand>();

    public static Collection<CliCommand> getCommands() {
        return COMMANDS.values();
    }

    public static boolean cli(String[] args) throws SyntaxError, Exception {
        if (args.length == 0) {
            return false;
        }
        CliCommand command = COMMANDS.get(args[0].toLowerCase().trim());
        if (command == null) {
            throw new SyntaxError("unbekanntes Kommando: " + args[0].toLowerCase().trim());
        }
        HashMap<String, String> argsMap = new HashMap<String, String>();
        for (int i = 1; i < args.length; ++i) {
            if (!args[i].startsWith("-")) continue;
            String option = args[i].substring(1).toLowerCase().trim();
            CliSwitch sw = command.getSwitches().get(option);
            if (sw == null) {
                throw new SyntaxError("unbekannte Option: -" + option);
            }
            if (sw.hasArgument()) {
                if (i + 1 == args.length) {
                    throw new SyntaxError("fehlendes Argument zur Option: " + sw.getLabel());
                }
                argsMap.put(sw.getName(), args[++i].trim());
                continue;
            }
            argsMap.put(sw.getName(), "");
        }
        for (CliSwitch sw : command.getSwitches().values()) {
            if (argsMap.containsKey(sw.getName())) continue;
            if (sw.isOptional()) {
                String def = sw.getDefault();
                if (def == null) continue;
                argsMap.put(sw.getName(), def);
                continue;
            }
            throw new SyntaxError("fehlende nicht optionale Option: " + sw.getLabel());
        }
        for (CliSwitch sw : command.getSwitches().values()) {
            String arg = (String)argsMap.get(sw.getName());
            if (arg == null || !sw.hasArgument() || sw.acceptValue(arg)) continue;
            throw new SyntaxError("fehlerhafter Wert ('" + arg + "') f\u00fcr die Option: " + sw.getLabel());
        }
        command.execute(argsMap);
        return true;
    }

    static {
        try {
            for (int i = 0; i < COMMAND_CLASSES.length; ++i) {
                CliCommand command = (CliCommand)COMMAND_CLASSES[i].newInstance();
                COMMANDS.put(command.getName(), command);
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

