/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel;

import java.io.IOException;
import javax.swing.SwingUtilities;
import tingeltangel.cli.CLI;
import tingeltangel.core.Repository;
import tingeltangel.gui.MasterFrame;
import tingeltangel.tools.Callback;
import tingeltangel.tools.ExternalBinary;

public class Tingeltangel {
    public static int MAIN_FRAME_POS_X = 50;
    public static int MAIN_FRAME_POS_Y = 50;
    public static int MAIN_FRAME_WIDTH = 1200;
    public static int MAIN_FRAME_HEIGHT = 700;
    public static String MAIN_FRAME_TITLE = "Tingeltangel";
    public static String MAIN_FRAME_VERSION = " v0.1";
    public static final String BASE_URL = "http://system.ting.eu/book-files";
    public static final String DEFAULT_AREA_CODE = "en";
    private static String mpg123Path;

    public static void main(String[] args) throws Exception {
        if (!CLI.cli(args)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String INSTALL_MPG123 = "MPG123 kann unter http://www.mpg123.de/download.shtml heruntergeladen werden";
                    Callback<String> callbackMpg123 = new Callback<String>(){

                        @Override
                        public void callback(String path) {
                            mpg123Path = path;
                            Tingeltangel.startup();
                        }
                    };
                    ExternalBinary.getBinaryPath("win_mpg123", "mpg123.exe", "mpg123", callbackMpg123, "MPG123", "Um MP3s abspielen zu k\u00f6nnen muss MPG123 installiert sein. Bitte triff eine Wahl.", "MPG123 kann unter http://www.mpg123.de/download.shtml heruntergeladen werden");
                }
            });
        }
    }

    private static void startup() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Repository.initialUpdate(new Thread(){

                        @Override
                        public void run() {
                            new MasterFrame();
                        }
                    });
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(System.out);
                }
            }
        });
    }

    public static String mpg123Path() {
        return mpg123Path;
    }
}

