/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import tingeltangel.core.Book;
import tingeltangel.core.Entry;
import tingeltangel.core.IndexTableCalculator;
import tingeltangel.core.Script;
import tingeltangel.core.scripting.SyntaxError;

public class ExtractOuf {
    public static void main(String[] args) throws Exception {
        ExtractOuf self = new ExtractOuf();
        File targetDir = new File("/tmp/dump");
        Book book = self.extract(new File("/tmp/bauernhof/05045_en.ouf"), targetDir);
        book.generateScriptFile(new File(targetDir, "0" + book.getID() + "_en.src"));
    }

    Book extract(File ouf, File targetDir) throws IOException, SyntaxError {
        RandomAccessFile in = new RandomAccessFile(ouf, "r");
        int startOfIndexTable = in.readInt();
        in.readInt();
        int smallestTingId = in.readInt();
        in.readInt();
        int numberOfTingCodes = in.readInt();
        int bookId = in.readInt();
        in.seek(startOfIndexTable);
        HashMap<Integer, IndexTableEntry> code2entry = new HashMap<Integer, IndexTableEntry>();
        for (int i = 0; i < numberOfTingCodes; ++i) {
            IndexTableEntry ite = new IndexTableEntry();
            ite.position = IndexTableCalculator.getPositionInFileFromCode(in.readInt(), i);
            ite.size = in.readInt();
            ite.type = in.readInt();
            code2entry.put(i + smallestTingId, ite);
        }
        Book book = new Book(bookId, null);
        for (Integer code : code2entry.keySet()) {
            byte[] data;
            IndexTableEntry ite = (IndexTableEntry)code2entry.get(code);
            book.addEntry(code);
            Entry entry = book.getEntryFromTingID(code);
            if (ite.type == 1) {
                in.seek(ite.position);
                data = new byte[ite.size];
                in.read(data);
                File mp3file = new File(targetDir, code + ".mp3");
                FileOutputStream out = new FileOutputStream(mp3file);
                out.write(data);
                out.close();
                entry.setMP3();
                entry.setMP3(mp3file);
                continue;
            }
            if (ite.type != 2) continue;
            in.seek(ite.position);
            data = new byte[ite.size];
            in.read(data);
            entry.setCode();
            entry.setScript(new Script(data, entry));
        }
        in.close();
        return book;
    }

    private static class IndexTableEntry {
        int position;
        int size;
        int type;

        private IndexTableEntry() {
        }
    }
}

