/*
 * Decompiled with CFR 0.152.
 */
package tingeltangel.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import tingeltangel.core.Repository;

public class Stick {
    private static final String STICK_DIR = "$ting";
    private static final String SETTINGS_FILE = "SETTINGS.INI";
    private static final String TBD_FILE = "TBD.TXT";
    private static final String[] STICK_FILES = new String[]{"TBD.TXT", "SETTINGS.INI", "SETTING.DAT", "BOOK.SYS"};

    public static boolean checkForStick(File path) {
        File[] content = path.listFiles();
        if (content != null) {
            for (int i = 0; i < content.length; ++i) {
                if (!content[i].isDirectory() || !content[i].getName().equals(STICK_DIR)) continue;
                content = content[i].listFiles();
                for (int f = 0; f < STICK_FILES.length; ++f) {
                    boolean found = false;
                    for (int j = 0; j < content.length; ++j) {
                        if (!content[j].getName().equals(STICK_FILES[f])) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static long getFreeSpace(File path) {
        return path.getUsableSpace();
    }

    public static LinkedList<Integer> getTBD(File path) throws IOException {
        String row;
        File file = new File(new File(path, STICK_DIR), TBD_FILE);
        if (!file.canRead()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        LinkedList<Integer> tbd = new LinkedList<Integer>();
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((row = in.readLine()) != null) {
            if ((row = row.trim()).isEmpty()) continue;
            try {
                tbd.add(Integer.parseInt(row));
            }
            catch (NumberFormatException nfe) {
                System.out.println("invalid row in " + file.getAbsolutePath() + ": " + row);
            }
        }
        in.close();
        return tbd;
    }

    public static LinkedList<Integer> getBooks(File path) throws IOException {
        File file = new File(path, STICK_DIR);
        if (!file.canRead()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        LinkedList<Integer> books = new LinkedList<Integer>();
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].getName().endsWith("_en.ouf") || files[i].getName().length() != "_en.ouf".length() + 5) continue;
            books.add(Integer.parseInt(files[i].getName().substring(0, 5)));
        }
        return books;
    }

    public static String getBookContent(File path) throws IOException {
        StringBuilder buffer = new StringBuilder();
        Iterator i = Stick.getBooks(path).iterator();
        while (i.hasNext()) {
            int id = (Integer)i.next();
            String bookID = Integer.toString(id);
            while (bookID.length() < 5) {
                bookID = "0" + bookID;
            }
            HashMap<String, String> book = Repository.getBookTxt(id);
            if (book == null) {
                buffer.append(bookID).append("\n");
                continue;
            }
            buffer.append(bookID).append(" (").append(book.get("Name")).append(")\n");
        }
        return buffer.toString();
    }

    public static String getTBDContent(File path) throws IOException {
        StringBuilder buffer = new StringBuilder();
        Iterator i = Stick.getTBD(path).iterator();
        while (i.hasNext()) {
            int id = (Integer)i.next();
            String bookID = Integer.toString(id);
            while (bookID.length() < 5) {
                bookID = "0" + bookID;
            }
            HashMap<String, String> book = Repository.getBookTxt(id);
            if (book == null) {
                buffer.append(bookID).append("\n");
                continue;
            }
            buffer.append(bookID).append(" (").append(book.get("Name")).append(")\n");
        }
        return buffer.toString();
    }

    public static File getBookDir(File path) {
        return new File(path, STICK_DIR);
    }

    public static void setSettings(File path, HashMap<String, String> settings) throws IOException {
        File file = new File(new File(path, STICK_DIR), SETTINGS_FILE);
        if (!file.canWrite()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-16");
        TreeSet<String> sortedKeys = new TreeSet<String>();
        sortedKeys.addAll(settings.keySet());
        for (String key : sortedKeys) {
            out.append(key + "=" + settings.get(key) + "\r\n");
        }
        out.close();
    }

    public static HashMap<String, String> getSettings(File path) throws IOException {
        String row;
        File file = new File(new File(path, STICK_DIR), SETTINGS_FILE);
        if (!file.canRead()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        HashMap<String, String> settings = new HashMap<String, String>();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-16")));
        while ((row = in.readLine()) != null) {
            if ((row = row.trim()).isEmpty()) continue;
            int p = row.indexOf("=");
            if (p == -1) {
                throw new IOException("bad row in " + file.getAbsolutePath() + ": " + row);
            }
            String key = row.substring(0, p).trim();
            String value = row.substring(p + 1).trim();
            settings.put(key, value);
        }
        in.close();
        return settings;
    }

    public static int getBookVersion(File path, int id) throws IOException {
        String row;
        String _id = Integer.toString(id);
        while (_id.length() < 5) {
            _id = "0" + _id;
        }
        File txt = new File(Stick.getBookDir(path), _id + "_en.txt");
        BufferedReader in = new BufferedReader(new FileReader(txt));
        while ((row = in.readLine()) != null) {
            if (!(row = row.trim()).startsWith("Book Version:")) continue;
            row = row.substring("Book Version:".length()).trim();
            in.close();
            return Integer.parseInt(row);
        }
        in.close();
        return -1;
    }

    public static void delete(File path, int id) {
        String _id = Integer.toString(id);
        while (_id.length() < 5) {
            _id = "0" + _id;
        }
        File txt = new File(Stick.getBookDir(path), _id + "_en.txt");
        File png = new File(Stick.getBookDir(path), _id + "_en.png");
        File ouf = new File(Stick.getBookDir(path), _id + "_en.ouf");
        File src = new File(Stick.getBookDir(path), _id + "_en.src");
        txt.delete();
        png.delete();
        ouf.delete();
        if (src.exists()) {
            src.delete();
        }
    }

    public static int getOnlineBookVersion(int id) throws IOException {
        String row;
        if (Repository.getBookTxt(id) == null) {
            return -1;
        }
        String _id = Integer.toString(id);
        while (_id.length() < 5) {
            _id = "0" + _id;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(new URL("http://system.ting.eu/book-files/get-description/id/" + _id + "/area/en").openStream()));
        while ((row = in.readLine()) != null) {
            if (!(row = row.trim()).startsWith("Book Version:")) continue;
            row = row.substring("Book Version:".length()).trim();
            in.close();
            return Integer.parseInt(row);
        }
        in.close();
        return -1;
    }

    private static void fileCopy(File source, File target) throws IOException {
        int k;
        System.out.println("copy file from: " + source.getAbsolutePath() + " to " + target.getAbsolutePath());
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(target);
        byte[] buffer = new byte[4096];
        while ((k = ((InputStream)in).read(buffer)) != -1) {
            ((OutputStream)out).write(buffer, 0, k);
        }
        ((OutputStream)out).close();
        ((InputStream)in).close();
    }

    private static void downloadBookLocally(String url, File target) throws IOException {
        int k;
        System.out.println("opening url: http://system.ting.eu/book-files" + url);
        URLConnection connection = new URL("http://system.ting.eu/book-files" + url).openConnection();
        InputStream in = connection.getInputStream();
        FileOutputStream out = new FileOutputStream(target);
        byte[] buffer = new byte[4096];
        int s = 0;
        while ((k = in.read(buffer)) != -1) {
            ((OutputStream)out).write(buffer, 0, k);
            s += k;
        }
        ((OutputStream)out).close();
        in.close();
    }

    public static void downloadOfficial(File path, int id) throws IOException {
        String _id = Integer.toString(id);
        while (_id.length() < 5) {
            _id = "0" + _id;
        }
        File txtOut = File.createTempFile("ting_txt_", null);
        Stick.downloadBookLocally("/get-description/id/" + _id + "/area/en", txtOut);
        File pngOut = File.createTempFile("ting_png_", null);
        Stick.downloadBookLocally("/get/id/" + _id + "/area/en/type/thumb", pngOut);
        File oufOut = File.createTempFile("ting_ouf_", null);
        Stick.downloadBookLocally("/get/id/" + _id + "/area/en/type/archive", oufOut);
        File srcOut = null;
        if (Repository.getBookTxt(id).containsKey("ScriptMD5")) {
            srcOut = File.createTempFile("ting_src_", null);
            Stick.downloadBookLocally("/get/id/" + _id + "/area/en/type/script", srcOut);
        }
        Stick.getBookDir(path).mkdir();
        Stick.fileCopy(txtOut, new File(path, _id + "_en.txt"));
        Stick.fileCopy(pngOut, new File(path, _id + "_en.png"));
        Stick.fileCopy(oufOut, new File(path, _id + "_en.ouf"));
        if (srcOut != null) {
            Stick.fileCopy(srcOut, new File(path, _id + "_en.src"));
        }
        txtOut.delete();
        pngOut.delete();
        oufOut.delete();
        if (srcOut != null) {
            srcOut.delete();
        }
    }

    public static void setTBD(File path, LinkedList<Integer> newTbd) throws IOException {
        File file = new File(new File(path, STICK_DIR), TBD_FILE);
        if (!file.canWrite()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        PrintWriter out = new PrintWriter(new FileWriter(file));
        Iterator i = newTbd.iterator();
        while (i.hasNext()) {
            String id = Integer.toString((Integer)i.next());
            while (id.length() < 5) {
                id = "0" + id;
            }
            out.println(id);
        }
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zip(ZipOutputStream zos, File file, LinkedList<String> stack) throws IOException {
        FileInputStream fis = null;
        if (file.isDirectory()) {
            stack.addLast(file.getName());
            File[] childs = file.listFiles();
            for (int i = 0; i < childs.length; ++i) {
                Stick.zip(zos, childs[i], stack);
            }
            stack.pollLast();
        } else {
            try {
                int len;
                String prefix = "";
                Iterator stackIt = stack.iterator();
                stackIt.next();
                while (stackIt.hasNext()) {
                    prefix = prefix + (String)stackIt.next() + "/";
                }
                zos.putNextEntry(new ZipEntry(prefix + file.getName()));
                byte[] buffer = new byte[4096];
                fis = new FileInputStream(file);
                while ((len = fis.read(buffer, 0, buffer.length)) > 0) {
                    zos.write(buffer, 0, len);
                }
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveStick(File stick, File target) throws IOException {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(target));
            LinkedList<String> stack = new LinkedList<String>();
            Stick.zip(zos, stick, stack);
        }
        finally {
            if (zos != null) {
                try {
                    zos.closeEntry();
                    zos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void restoreStick(File stick, File source) throws IOException {
        ZipFile zipFile = new ZipFile(source);
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        TreeSet<String> files = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() < o2.length()) {
                    return -1;
                }
                if (o1.length() > o2.length()) {
                    return 1;
                }
                return o1.compareTo(o2);
            }
        });
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            files.add(zipEntry.getName());
        }
        for (String fileName : files) {
            int len;
            int p = fileName.lastIndexOf("/");
            if (p != -1) {
                new File(stick, fileName.substring(0, p)).mkdirs();
            }
            FileOutputStream out = new FileOutputStream(new File(stick, fileName));
            InputStream in = zipFile.getInputStream(zipFile.getEntry(fileName));
            byte[] buffer = new byte[4096];
            while ((len = in.read(buffer, 0, buffer.length)) > 0) {
                ((OutputStream)out).write(buffer, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
        }
        zipFile.close();
    }
}

