/*
 * Decompiled with CFR 0.152.
 */
package ting;

import java.io.BufferedReader;
import java.io.FileReader;

public class Translator {
    private static final String ID_TRANS_FILE = "id_trans.data";
    private static final int[] code2ting = new int[65537];
    private static final int[] ting2code = new int[65537];
    private static final int min_object_code = 15001;
    private static int max_object_code;
    private static final int min_book_code = 8001;
    private static int max_book_code;

    public static int getMinObjectCode() {
        return 15001;
    }

    public static int getMaxObjectCode() {
        return max_object_code;
    }

    public static int getMinBookCode() {
        return 8001;
    }

    public static int getMaxBookCode() {
        return max_book_code;
    }

    public static int code2ting(int c) {
        return code2ting[c];
    }

    public static int ting2code(int t) {
        return ting2code[t];
    }

    public static void main(String[] args) {
        int i;
        int COLS = 5;
        int c = 0;
        System.out.println("<html><head><title>Ting IDs vs. Code IDs</title></head>");
        System.out.println("<body><h3>Ting IDs vs. Code IDs</h3><table border='0'><tr>");
        for (i = 0; i < COLS; ++i) {
            if (i > 0) {
                System.out.println("<th></th>");
            }
            System.out.println("<th>Ting ID</th><th>Code ID</th>");
        }
        System.out.println("<tr>");
        for (i = 0; i < 65536; ++i) {
            if (ting2code[i] < 0) continue;
            if (c == 0) {
                System.out.println("<tr>");
            } else {
                System.out.println("<td>&nbsp;</td>");
            }
            System.out.println("<td align='right' style='background-color:#aaa'>" + i);
            System.out.println("</td><td align='right' style='background-color:#aaa'>");
            System.out.println(ting2code[i] + "</td>");
            ++c;
            if ((c %= COLS) != 0) continue;
            System.out.println("</tr>");
        }
        System.out.println("</table></body></html>");
    }

    public static int getMaxTingCodeFrom(int start) {
        while (start < 65536) {
            if (ting2code[start] == -1) {
                return start - 1;
            }
            ++start;
        }
        return 65535;
    }

    static {
        for (int i = 0; i < code2ting.length; ++i) {
            Translator.code2ting[i] = -1;
            Translator.ting2code[i] = -1;
        }
        int r = 0;
        int lastCodeID = -1;
        int lastTingID = -1;
        try {
            int t;
            String row;
            BufferedReader in = new BufferedReader(new FileReader(ID_TRANS_FILE));
            while ((row = in.readLine()) != null) {
                ++r;
                if ((row = row.trim()).isEmpty() || row.startsWith("#")) continue;
                if (row.startsWith("-")) {
                    if (lastCodeID != -1) {
                        Translator.code2ting[lastCodeID] = lastTingID;
                    }
                    lastCodeID = -1;
                    lastTingID = -1;
                    continue;
                }
                int p = row.indexOf(" ");
                if (p == -1) {
                    throw new Error("error in 'id_trans.data' on line " + r);
                }
                int codeID = Integer.parseInt(row.substring(0, p).trim());
                if (lastCodeID != -1) {
                    int tc = 0;
                    for (int c = lastCodeID; c < codeID; ++c) {
                        Translator.code2ting[c] = lastTingID + tc++;
                    }
                }
                lastCodeID = codeID;
                lastTingID = Integer.parseInt(row.substring(p + 1).trim());
            }
            for (int c = 0; c < 65536; ++c) {
                if (code2ting[c] == -1) continue;
                if (ting2code[code2ting[c]] == -1) {
                    Translator.ting2code[Translator.code2ting[c]] = c;
                    continue;
                }
                throw new Error();
            }
            for (t = 15001; t <= 65536; ++t) {
                if (ting2code[t] != -1) continue;
                max_object_code = t - 1;
                break;
            }
            for (t = 8001; t < 9000; ++t) {
                if (ting2code[t] != -1) continue;
                max_book_code = t - 1;
                break;
            }
        }
        catch (Exception e) {
            System.out.println("error on row " + r);
            throw new Error(e);
        }
    }
}

