/*
 * Decompiled with CFR 0.152.
 */
package ting;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import ting.Book;
import ting.Codes;
import ting.MenuListener;
import ting.MyMenuListener;
import ting.Translator;

public class MainFrame
extends JFrame
implements MenuListener {
    private Book book = null;
    private TableModel dataModel = null;
    private JTable table = null;
    private JTextField headId = new JTextField();
    private JTextField headName = new JTextField();
    private JTextField headPublisher = new JTextField();
    private JTextField headAuthor = new JTextField();
    private JTextField headVersion = new JTextField();
    private JTextField headUrl = new JTextField();
    private String lastChooseMp3DialogPath = "~/";

    public MainFrame() {
        this.setTitle("Ting");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                MainFrame.this.menu("book.exit");
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        this.getContentPane().add((Component)this.createContent(), "Center");
        this.pack();
        this.setMenuBar(this.createMenuBar());
        this.setBounds(200, 200, 300, 500);
        this.setVisible(true);
        this.newBook();
    }

    private void newBook() {
        this.book = new Book();
        ((AbstractTableModel)this.dataModel).fireTableDataChanged();
        this.headId.setText("");
        this.headName.setText("");
        this.headPublisher.setText("");
        this.headAuthor.setText("");
        this.headVersion.setText("");
        this.headUrl.setText("");
    }

    @Override
    public void menu(String action) {
        JFileChooser fc = new JFileChooser();
        if (action.equals("book.new")) {
            this.newBook();
        } else if (action.equals("book.open")) {
            fc.setFileFilter(new FileNameExtensionFilter("Ting Buch Projekt", "tbu"));
            if (fc.showOpenDialog(this) == 0) {
                try {
                    this.book = Book.load(fc.getSelectedFile());
                    this.headId.setText("" + this.book.getID());
                    this.headName.setText(this.book.getName());
                    this.headPublisher.setText(this.book.getPublisher());
                    this.headAuthor.setText(this.book.getAuthor());
                    this.headVersion.setText("" + this.book.getVersion());
                    this.headUrl.setText(this.book.getUrl());
                    ((AbstractTableModel)this.dataModel).fireTableDataChanged();
                }
                catch (FileNotFoundException e) {
                    JOptionPane.showMessageDialog(this, "Das Buch konnte nicht gefunden werden");
                    e.printStackTrace(System.out);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "Das Buch konnte nicht geladen werden");
                    e.printStackTrace(System.out);
                }
            }
        } else if (action.equals("book.save")) {
            fc.setFileFilter(new FileNameExtensionFilter("Ting Buch Projekt (*.tbu)", "tbu"));
            if (fc.showSaveDialog(this) == 0) {
                int id = -1;
                try {
                    id = Integer.parseInt(this.headId.getText());
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                int version = 0;
                try {
                    version = Integer.parseInt(this.headVersion.getText());
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                this.book.setID(id);
                this.book.setName(this.headName.getText());
                this.book.setPublisher(this.headPublisher.getText());
                this.book.setAuthor(this.headAuthor.getText());
                this.book.setVersion(version);
                this.book.setURL(this.headUrl.getText());
                try {
                    String file = fc.getSelectedFile().getCanonicalPath();
                    if (!file.toLowerCase().endsWith(".tbu")) {
                        file = file + ".tbu";
                    }
                    this.book.save(new File(file));
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Das Buch konnte nicht gespeichert werden");
                    e.printStackTrace(System.out);
                }
            }
        } else if (action.equals("book.eps")) {
            fc.setFileSelectionMode(1);
            fc.setAcceptAllFileFilterUsed(false);
            fc.setDialogTitle("Speicherverzeichniss ausw\u00e4hlen (eps Dateien)");
            if (fc.showSaveDialog(this) == 0) {
                int id = -1;
                try {
                    id = Integer.parseInt(this.headId.getText());
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                int version = 0;
                try {
                    version = Integer.parseInt(this.headVersion.getText());
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                this.book.setID(id);
                this.book.setName(this.headName.getText());
                this.book.setPublisher(this.headPublisher.getText());
                this.book.setAuthor(this.headAuthor.getText());
                this.book.setVersion(version);
                this.book.setURL(this.headUrl.getText());
                File dir = fc.getSelectedFile();
                if (!dir.exists()) {
                    JOptionPane.showMessageDialog(this, "Das Verzeichniss konnte nicht gefunden werden");
                } else if (!dir.isDirectory()) {
                    JOptionPane.showMessageDialog(this, "Kein Verzeichniss ausgew\u00e4hlt");
                } else {
                    try {
                        this.book.epsExport(dir);
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(this, "eps-Generierung fehlgeschlagen");
                        e.printStackTrace(System.out);
                    }
                    catch (IllegalArgumentException e) {
                        JOptionPane.showMessageDialog(this, "eps-Generierung fehlgeschlagen: " + e.getMessage());
                    }
                }
            }
        } else if (action.equals("book.export")) {
            fc.setFileSelectionMode(1);
            fc.setAcceptAllFileFilterUsed(false);
            fc.setDialogTitle("Speicherverzeichniss ausw\u00e4hlen (Ting Dateien)");
            if (fc.showSaveDialog(this) == 0) {
                File dir = fc.getSelectedFile();
                if (!dir.exists()) {
                    JOptionPane.showMessageDialog(this, "Das Verzeichniss konnte nicht gefunden werden");
                } else if (!dir.isDirectory()) {
                    JOptionPane.showMessageDialog(this, "Kein Verzeichniss ausgew\u00e4hlt");
                } else {
                    try {
                        int id = -1;
                        try {
                            id = Integer.parseInt(this.headId.getText());
                        }
                        catch (NumberFormatException nfe) {
                            // empty catch block
                        }
                        int version = 0;
                        try {
                            version = Integer.parseInt(this.headVersion.getText());
                        }
                        catch (NumberFormatException nfe) {
                            // empty catch block
                        }
                        this.book.setID(id);
                        this.book.setName(this.headName.getText());
                        this.book.setPublisher(this.headPublisher.getText());
                        this.book.setAuthor(this.headAuthor.getText());
                        this.book.setVersion(version);
                        this.book.setURL(this.headUrl.getText());
                        this.book.export(dir);
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(this, "Buchgenerierung fehlgeschlagen");
                        e.printStackTrace(System.out);
                    }
                    catch (IllegalArgumentException e) {
                        JOptionPane.showMessageDialog(this, "Buchgenerierung fehlgeschlagen: " + e.getMessage());
                    }
                }
            }
        } else if (action.equals("book.exit")) {
            System.exit(0);
        } else if (action.equals("entry.new")) {
            if (this.book != null) {
                this.book.addEntry();
                ((AbstractTableModel)this.dataModel).fireTableDataChanged();
            }
        } else if (action.equals("entry.delete")) {
            int row;
            if (this.book != null && (row = this.table.getSelectedRow()) != -1) {
                this.book.removeEntry(row);
                ((AbstractTableModel)this.dataModel).fireTableDataChanged();
            }
        } else if (action.equals("codes.ting.15001")) {
            this.genTingCodes(15001);
        } else if (action.equals("codes.ting.16001")) {
            this.genTingCodes(16001);
        } else if (action.equals("codes.ting.8000")) {
            this.genTingCodes(8000);
        } else if (action.startsWith("codes.code.")) {
            int nr = Integer.parseInt(action.substring("codes.code.".length())) * 1000;
            this.genCodeCodes(nr);
        }
    }

    private void genTingCodes(int start) {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileNameExtensionFilter("PostScript Datei (*.ps)", "ps"));
        fc.setDialogTitle("Zieldatei ausw\u00e4hlen");
        if (fc.showSaveDialog(this) == 0) {
            try {
                String file = fc.getSelectedFile().getCanonicalPath();
                if (!file.toLowerCase().endsWith(".ps")) {
                    file = file + ".ps";
                }
                int max = Math.min(start + 1000, Translator.getMaxTingCodeFrom(start));
                int[] idx = new int[max - start];
                System.out.println(idx.length);
                String[] lbs = new String[idx.length];
                for (int i = start; i < max; ++i) {
                    idx[i - start] = Translator.ting2code(i);
                    lbs[i - start] = "" + i;
                }
                PrintWriter out = new PrintWriter(new FileWriter(file));
                Codes.drawPage(idx, lbs, out);
                out.close();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "Codegenerierung fehlgeschlagen");
                ioe.printStackTrace(System.out);
            }
        }
    }

    private void genCodeCodes(int start) {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileNameExtensionFilter("PostScript Datei (*.ps)", "ps"));
        fc.setDialogTitle("Zieldatei ausw\u00e4hlen");
        if (fc.showSaveDialog(this) == 0) {
            try {
                String file = fc.getSelectedFile().getCanonicalPath();
                if (!file.toLowerCase().endsWith(".ps")) {
                    file = file + ".ps";
                }
                PrintWriter out = new PrintWriter(new FileWriter(file));
                Codes.drawPage(start, out);
                out.close();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "Codegenerierung fehlgeschlagen");
                ioe.printStackTrace(System.out);
            }
        }
    }

    private MenuBar createMenuBar() {
        MenuBar bar = new MenuBar();
        Menu bookMenu = new Menu("Buch");
        MenuItem bookNew = new MenuItem("Neu");
        bookNew.addActionListener(new MyMenuListener("book.new", this));
        bookMenu.add(bookNew);
        MenuItem bookOpen = new MenuItem("\u00d6ffnen");
        bookOpen.addActionListener(new MyMenuListener("book.open", this));
        bookMenu.add(bookOpen);
        MenuItem bookSave = new MenuItem("Speichern");
        bookSave.addActionListener(new MyMenuListener("book.save", this));
        bookMenu.add(bookSave);
        MenuItem bookExport = new MenuItem("Generieren (Ting Dateien)");
        bookExport.addActionListener(new MyMenuListener("book.export", this));
        bookMenu.add(bookExport);
        MenuItem epsExport = new MenuItem("Generieren (eps Dateien)");
        epsExport.addActionListener(new MyMenuListener("book.eps", this));
        bookMenu.add(epsExport);
        MenuItem bookExit = new MenuItem("Beenden");
        bookExit.addActionListener(new MyMenuListener("book.exit", this));
        bookMenu.add(bookExit);
        Menu entryMenu = new Menu("Track");
        MenuItem entryNew = new MenuItem("Neu");
        entryNew.addActionListener(new MyMenuListener("entry.new", this));
        entryMenu.add(entryNew);
        MenuItem entryRemove = new MenuItem("L\u00f6schen");
        entryRemove.addActionListener(new MyMenuListener("entry.delete", this));
        entryMenu.add(entryRemove);
        Menu entryCodes = new Menu("Codes");
        Menu subTing = new Menu("Ting IDs");
        MenuItem entryTingCodes8000 = new MenuItem("MIDs 8000-8999");
        entryTingCodes8000.addActionListener(new MyMenuListener("codes.ting.8000", this));
        subTing.add(entryTingCodes8000);
        MenuItem entryTingCodes15001 = new MenuItem("OIDs 15001-16000");
        entryTingCodes15001.addActionListener(new MyMenuListener("codes.ting.15001", this));
        subTing.add(entryTingCodes15001);
        MenuItem entryTingCodes16001 = new MenuItem("OIDs 16001-17000");
        entryTingCodes16001.addActionListener(new MyMenuListener("codes.ting.16001", this));
        subTing.add(entryTingCodes16001);
        subTing.add(entryTingCodes8000);
        subTing.add(entryTingCodes15001);
        subTing.add(entryTingCodes16001);
        entryCodes.add(subTing);
        Menu subCodes = new Menu("Code IDs");
        for (int i = 0; i < 66; ++i) {
            int max = Math.min(i * 1000 + 999, 65535);
            MenuItem entryCodes0 = new MenuItem(i * 1000 + "-" + max);
            entryCodes0.addActionListener(new MyMenuListener("codes.code." + i, this));
            subCodes.add(entryCodes0);
        }
        entryCodes.add(subCodes);
        bar.add(bookMenu);
        bar.add(entryMenu);
        bar.add(entryCodes);
        return bar;
    }

    private JPanel createContent() {
        JPanel panel = new JPanel();
        final String[] column = new String[]{"ID", "MP3", "MP3 L\u00e4nge"};
        this.dataModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public int getRowCount() {
                if (MainFrame.this.book == null) {
                    return 0;
                }
                return MainFrame.this.book.getSize();
            }

            @Override
            public Object getValueAt(int row, int col) {
                switch (col) {
                    case 0: {
                        return new Integer(row + 15001);
                    }
                    case 1: {
                        File mp3 = MainFrame.this.book.getEntry(row).getMP3();
                        if (mp3 == null) {
                            return null;
                        }
                        return mp3.getName();
                    }
                    case 2: {
                        return new Float(MainFrame.this.book.getEntry(row).getLength());
                    }
                }
                throw new Error();
            }

            @Override
            public String getColumnName(int index) {
                return column[index];
            }
        };
        this.table = new JTable(this.dataModel);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JTable target = (JTable)e.getSource();
                    int row = target.getSelectedRow();
                    int column = target.getSelectedColumn();
                    if (column == 1) {
                        JFileChooser fc = new JFileChooser(MainFrame.this.lastChooseMp3DialogPath);
                        fc.setFileFilter(new FileNameExtensionFilter("mp3", "mp3"));
                        if (fc.showOpenDialog(MainFrame.this) == 0) {
                            try {
                                File file;
                                if (row == MainFrame.this.book.getSize() - 1) {
                                    MainFrame.this.book.addEntry();
                                }
                                if ((file = fc.getSelectedFile()).getParent() != null) {
                                    MainFrame.this.lastChooseMp3DialogPath = file.getParent();
                                }
                                MainFrame.this.book.getEntry(row).setMP3(file);
                                ((AbstractTableModel)MainFrame.this.dataModel).fireTableDataChanged();
                            }
                            catch (FileNotFoundException ex) {
                                JOptionPane.showMessageDialog(MainFrame.this, "Die Datei '" + fc.getSelectedFile() + "' konnte nicht gefunden werden.");
                                ex.printStackTrace(System.out);
                            }
                            catch (IOException ex) {
                                JOptionPane.showMessageDialog(MainFrame.this, "Die Datei '" + fc.getSelectedFile() + "' konnte nicht gelesen werden.");
                                ex.printStackTrace(System.out);
                            }
                        }
                    }
                }
            }
        });
        JScrollPane scrollpane = new JScrollPane(this.table);
        JPanel head = new JPanel();
        head.setLayout(new GridLayout(6, 2));
        head.add(new JLabel("ID (use 80XX):"));
        head.add(this.headId);
        head.add(new JLabel("Name:"));
        head.add(this.headName);
        head.add(new JLabel("Verleger:"));
        head.add(this.headPublisher);
        head.add(new JLabel("Autor:"));
        head.add(this.headAuthor);
        head.add(new JLabel("Version:"));
        head.add(this.headVersion);
        head.add(new JLabel("URL:"));
        head.add(this.headUrl);
        panel.setLayout(new BorderLayout());
        panel.add((Component)scrollpane, "Center");
        panel.add((Component)head, "North");
        return panel;
    }
}

