/*
 * Decompiled with CFR 0.152.
 */
package ting;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import ting.Script;

public class Entry {
    private File mp3 = null;
    private Script script = null;
    private float mp3length = -1.0f;
    private int size = -1;

    void save(DataOutputStream out) throws IOException {
        if (this.mp3 == null) {
            out.writeUTF("");
        } else {
            out.writeUTF(this.mp3.getAbsolutePath());
        }
        if (this.script == null) {
            out.writeUTF("");
        } else {
            out.writeUTF(this.script.toString());
        }
    }

    public int getSize() {
        return this.size;
    }

    static Entry load(DataInputStream in) throws IOException {
        String sScript;
        Entry entry = new Entry();
        String sMp3 = in.readUTF();
        if (!sMp3.isEmpty()) {
            entry.mp3 = new File(sMp3);
            if (!entry.mp3.canRead()) {
                entry.mp3 = null;
            } else {
                entry.size = (int)entry.mp3.length();
            }
            entry.calculateFileLength();
        }
        if (!(sScript = in.readUTF()).isEmpty()) {
            entry.script = new Script(sScript);
        }
        return entry;
    }

    public File getMP3() {
        return this.mp3;
    }

    public float getLength() {
        return this.mp3length;
    }

    public boolean hasCode() {
        return this.script != null || this.mp3 != null;
    }

    public void setScript(Script script) {
        this.script = script;
        this.mp3 = null;
    }

    public Script getScript() {
        return this.script;
    }

    public void setMP3(File mp3) throws FileNotFoundException, IOException {
        String name = mp3.getAbsolutePath();
        if (!mp3.isFile()) {
            this.mp3 = null;
            this.mp3length = -1.0f;
            throw new FileNotFoundException(name);
        }
        if (!mp3.canRead()) {
            this.mp3 = null;
            this.mp3length = -1.0f;
            throw new FileNotFoundException(name);
        }
        this.mp3 = mp3;
        try {
            this.calculateFileLength();
        }
        catch (IOException e) {
            this.mp3 = null;
            throw e;
        }
        this.size = (int)mp3.length();
        this.script = null;
    }

    private void calculateFileLength() throws IOException {
        String row;
        String soxLength = "Length (seconds):";
        String soxBinary = "sox";
        if (System.getProperty("os.name").startsWith("Windows")) {
            soxBinary = "win_sox\\sox.exe";
        }
        ProcessBuilder pBuilder = new ProcessBuilder(soxBinary, this.mp3.getAbsolutePath(), "-n", "stat").redirectErrorStream(true);
        Process exec = pBuilder.start();
        BufferedReader in = new BufferedReader(new InputStreamReader(exec.getInputStream()));
        while ((row = in.readLine()) != null) {
            if (!row.startsWith(soxLength)) continue;
            row = row.substring(soxLength.length()).trim();
            this.mp3length = Float.parseFloat(row);
            in.close();
            exec.destroy();
            return;
        }
        in.close();
        exec.destroy();
        throw new IOException();
    }
}

