/*
 * Decompiled with CFR 0.152.
 */
package ting;

import java.io.PrintWriter;

public class Codes {
    private static final float DOT_SIZE = 0.12f;
    private static final float DELTA_SIZE = 0.12f;
    private static final float BLOCK_SIZE = 0.84f;

    private static float[] getDotPosFromInt(int i) {
        float[] f = new float[2];
        switch (i) {
            case 0: {
                f[0] = 1.0f;
                f[1] = -1.0f;
                return f;
            }
            case 1: {
                f[0] = -1.0f;
                f[1] = -1.0f;
                return f;
            }
            case 2: {
                f[0] = -1.0f;
                f[1] = 1.0f;
                return f;
            }
            case 3: {
                f[0] = 1.0f;
                f[1] = 1.0f;
                return f;
            }
        }
        throw new Error();
    }

    private static int getPari(int w7, int w6, int w5, int w4, int w3, int w2, int w1, int w0) {
        int c1 = ((w1 ^ w4 ^ w6 ^ w7) & 1) << 1;
        int c2 = (w0 ^ w2 ^ w3 ^ w5) & 1;
        return c1 | c2;
    }

    private static float[][][] getPatternFromInt(int i) {
        int w0 = i & 3;
        int w1 = i >> 2 & 3;
        int w2 = i >> 4 & 3;
        int w3 = i >> 6 & 3;
        int w4 = i >> 8 & 3;
        int w5 = i >> 10 & 3;
        int w6 = i >> 12 & 3;
        int w7 = i >> 14 & 3;
        float[][][] pattern = new float[][][]{new float[][]{{0.0f, 0.0f}, {0.0f, 0.0f}, {0.0f, 0.0f}, {0.0f, 0.0f}}, new float[][]{{0.0f, 0.0f}, Codes.getDotPosFromInt(Codes.getPari(w7, w6, w5, w4, w3, w2, w1, w0)), Codes.getDotPosFromInt(w7), Codes.getDotPosFromInt(w6)}, new float[][]{{1.0f, 0.0f}, Codes.getDotPosFromInt(w5), Codes.getDotPosFromInt(w4), Codes.getDotPosFromInt(w3)}, new float[][]{{0.0f, 0.0f}, Codes.getDotPosFromInt(w2), Codes.getDotPosFromInt(w1), Codes.getDotPosFromInt(w0)}};
        return pattern;
    }

    private static void drawText(float x, float y, String text, PrintWriter out) {
        out.println("newpath");
        out.println(x + " " + y + " moveto");
        out.println("(" + text + ") show");
    }

    private static void drawDot(float x, float y, PrintWriter out) {
        out.println("newpath");
        out.println(x + " " + y + " moveto");
        out.println(x + " " + (y + 0.12f) + " lineto");
        out.println(x + 0.12f + " " + (y + 0.12f) + " lineto");
        out.println(x + 0.12f + " " + y + " lineto");
        out.println("fill");
    }

    private static void drawPattern(int p, float x, float y, PrintWriter out) {
        float[][][] pattern = Codes.getPatternFromInt(p);
        for (int dx = 0; dx < 4; ++dx) {
            for (int dy = 0; dy < 4; ++dy) {
                float px = pattern[3 - dy][dx][0] * 0.12f;
                float py = pattern[3 - dy][dx][1] * 0.12f;
                Codes.drawDot(x + (float)dx * 0.84f + px, y + (float)dy * 0.84f + py, out);
            }
        }
    }

    private static void drawCarpet(int p, float x, float y, int w, int h, String label, PrintWriter out) {
        if (label != null) {
            Codes.drawText(x, y - 4.0f, label, out);
        }
        w = (int)((float)w / 3.36f);
        h = (int)((float)h / 3.36f);
        for (int ix = 0; ix < w; ++ix) {
            for (int iy = 0; iy < h; ++iy) {
                Codes.drawPattern(p, x + (float)(ix * 4) * 0.84f, y + (float)(iy * 4) * 0.84f, out);
            }
        }
        out.flush();
    }

    public static void drawEps(int code, int width, int height, PrintWriter out) {
        out.println("%!PS-Adobe-3.0 EPSF-3.0");
        out.println("%%BoundingBox: 0 0 " + width + " " + height);
        Codes.drawCarpet(code, 0.0f, 0.0f, width, height, null, out);
    }

    public static void drawPage(int start, PrintWriter out) {
        int cx = 25;
        int cy = 40;
        int till = Math.min(65535, start + cx * cy - 1);
        out.println("/Times-Roman findfont");
        out.println("5 scalefont");
        out.println("setfont");
        Codes.drawText(50.0f, 815.0f, "CODE IDS: " + start + " - " + till, out);
        out.println("/Times-Roman findfont");
        out.println("4 scalefont");
        out.println("setfont");
        for (int y = cy - 1; y >= 0; --y) {
            for (int x = 0; x < cx; ++x) {
                if (start >= 65536) continue;
                Codes.drawCarpet(start, 50 + x * 20, 17 + y * 20, 15, 15, "" + start++, out);
            }
        }
        out.println("showpage");
        out.flush();
    }

    public static void drawPage(int[] index, String[] caption, PrintWriter out) {
        int cx = 25;
        int cy = 40;
        out.println("/Times-Roman findfont");
        out.println("5 scalefont");
        out.println("setfont");
        Codes.drawText(50.0f, 815.0f, "TING IDS: " + caption[0] + " - " + caption[caption.length - 1], out);
        out.println("/Times-Roman findfont");
        out.println("4 scalefont");
        out.println("setfont");
        int p = 0;
        for (int y = cy - 1; y >= 0; --y) {
            for (int x = 0; x < cx; ++x) {
                if (p >= index.length) continue;
                System.out.println(p);
                Codes.drawCarpet(index[p], 50 + x * 20, 17 + y * 20, 15, 15, caption[p++], out);
            }
        }
        out.println("showpage");
        out.flush();
    }
}

