/*
 * Decompiled with CFR 0.152.
 */
package ting;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.LinkedList;
import ting.Codes;
import ting.Entry;
import ting.Translator;

public class Book {
    private static final int UNKNOWN_STRANGE_VALUE = 1729054757;
    private LinkedList<Entry> index = new LinkedList();
    private int id = -1;
    private String name;
    private String publisher;
    private String author;
    private int version;
    private String url;
    protected static final char[] hexArray = "0123456789abcdef".toCharArray();
    private static final int[] E = new int[]{578, 562, 546, 530, 514, 498, 482, 466, 322, 306, 290, 274, 258, 242, 226, 210, -446, -462, -478, -494, -510, -526, -542, -558, -702, -718, -734, -750, -766, -782, -798, -814};

    public String getName() {
        return this.name;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getUrl() {
        return this.url;
    }

    public int getVersion() {
        return this.version;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public Book() {
        this.index.add(new Entry());
    }

    public void addEntry() {
        this.index.add(new Entry());
    }

    public Entry getEntry(int i) {
        return this.index.get(i);
    }

    public void setID(int id) {
        this.id = id;
    }

    public int getID() {
        return this.id;
    }

    public int getSize() {
        return this.index.size();
    }

    void removeEntry(int row) {
        this.index.remove(row);
    }

    void save(File file) throws IOException {
        DataOutputStream out = new DataOutputStream(new FileOutputStream(file));
        out.writeInt(this.id);
        out.writeUTF(this.name);
        out.writeUTF(this.publisher);
        out.writeUTF(this.author);
        out.writeInt(this.version);
        out.writeUTF(this.url);
        out.writeInt(this.index.size());
        Iterator iterator = this.index.iterator();
        while (iterator.hasNext()) {
            ((Entry)iterator.next()).save(out);
        }
        out.close();
    }

    static Book load(File file) throws FileNotFoundException, IOException {
        DataInputStream in = new DataInputStream(new FileInputStream(file));
        Book book = new Book();
        book.index.clear();
        book.id = in.readInt();
        book.name = in.readUTF();
        book.publisher = in.readUTF();
        book.author = in.readUTF();
        book.version = in.readInt();
        book.url = in.readUTF();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            book.index.add(Entry.load(in));
        }
        return book;
    }

    private String md5(File file) throws IOException {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            FileInputStream is = new FileInputStream(file);
            DigestInputStream dis = new DigestInputStream(is, md);
            byte[] buffer = new byte[4096];
            while (dis.read(buffer) >= 0) {
            }
            byte[] bytes = md.digest();
            char[] hexChars = new char[bytes.length * 2];
            for (int j = 0; j < bytes.length; ++j) {
                int v = bytes[j] & 0xFF;
                hexChars[j * 2] = hexArray[v >>> 4];
                hexChars[j * 2 + 1] = hexArray[v & 0xF];
            }
            return new String(hexChars);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
    }

    private void generateOufFile(DataOutputStream out) throws IOException {
        int startOfIndexTable = 104;
        out.writeInt(startOfIndexTable);
        out.writeInt(2);
        out.writeInt(15001);
        out.writeInt(15000 + this.index.size());
        out.writeInt(this.index.size());
        out.writeInt(this.id);
        out.writeInt(2);
        out.writeInt(1729054757);
        out.writeInt(0);
        out.writeInt(65535);
        for (int i = 40; i < startOfIndexTable; ++i) {
            out.writeByte(0);
        }
        int pos = startOfIndexTable + 12 * this.index.size();
        int lastPosOfEntry = Book.getCodeFromPositionInFile(pos + 256 - (pos & 0xFF), 0);
        for (int i = 0; i < this.index.size(); ++i) {
            if (this.index.get(i).getMP3() != null) {
                pos += 256 - (pos & 0xFF);
                lastPosOfEntry = Book.getCodeFromPositionInFile(pos, i);
                out.writeInt(lastPosOfEntry);
                out.writeInt(this.index.get(i).getSize());
                out.writeInt(1);
                pos += this.index.get(i).getSize();
                continue;
            }
            if (this.index.get(i).getScript() != null) {
                out.writeInt(lastPosOfEntry);
                out.writeInt(this.index.get(i).getSize());
                out.writeInt(2);
                continue;
            }
            out.writeInt(0);
            out.writeInt(0);
            out.writeInt(0);
        }
        pos = startOfIndexTable + 12 * this.index.size();
        byte[] buffer = new byte[4096];
        for (int t = 0; t < this.index.size(); ++t) {
            Entry e = this.index.get(t);
            if (e.getMP3() != null) {
                int b;
                int pad = 256 - (pos & 0xFF);
                pos += pad;
                for (int i = 0; i < pad; ++i) {
                    out.write(0);
                }
                FileInputStream in = new FileInputStream(e.getMP3());
                while ((b = ((InputStream)in).read(buffer)) >= 0) {
                    out.write(buffer, 0, b);
                    pos += b;
                }
                continue;
            }
            if (e.getScript() == null) continue;
            throw new UnsupportedOperationException("Not yet implemented");
        }
        out.close();
    }

    void epsExport(File dir) throws IOException, IllegalArgumentException {
        if (this.id > Translator.getMaxBookCode()) {
            throw new IllegalArgumentException("maximale zur Zeit unterst\u00fczte Buch ID: " + Translator.getMaxBookCode());
        }
        if (this.id < Translator.getMinBookCode()) {
            throw new IllegalArgumentException("minimale zur Zeit unterst\u00fczte Buch ID: " + Translator.getMinBookCode());
        }
        if (15000 + this.index.size() >= Translator.getMaxObjectCode()) {
            throw new IllegalArgumentException("zu viele OIDs. Maximale zur Zeit unterst\u00fczte OIS: " + Translator.getMaxObjectCode());
        }
        PrintWriter out = new PrintWriter(new FileWriter(new File(dir, "activation.eps")));
        Codes.drawEps(Translator.ting2code(this.id), 200, 200, out);
        out.close();
        for (int i = 0; i < this.index.size(); ++i) {
            if (!this.index.get(i).hasCode()) continue;
            out = new PrintWriter(new FileWriter(new File(dir, i + 15001 + ".eps")));
            Codes.drawEps(Translator.ting2code(i + 15001), 100, 100, out);
            out.close();
        }
    }

    void export(File dir) throws IOException, IllegalArgumentException {
        int b;
        if (this.name == null || this.name.isEmpty() || this.name.trim().isEmpty()) {
            throw new IllegalArgumentException("Kein Buchname angegeben");
        }
        if (this.publisher == null || this.publisher.isEmpty() || this.publisher.trim().isEmpty()) {
            throw new IllegalArgumentException("Kein Herausgeber angegeben");
        }
        if (this.author == null || this.author.isEmpty() || this.author.trim().isEmpty()) {
            throw new IllegalArgumentException("Kein Autor angegeben");
        }
        if (this.version < 1) {
            throw new IllegalArgumentException("Keine g\u00fcltige Version angegeben");
        }
        if (this.url == null) {
            this.url = "";
        }
        for (int i = 0; i < this.index.size(); ++i) {
            if (this.index.get(i).getMP3() == null || this.index.get(i).getMP3().canRead()) continue;
            throw new IllegalArgumentException("Die Datei '" + this.index.get(i).getMP3().getAbsolutePath() + "' konnte nicht gelesen werden.");
        }
        String idS = "" + this.id;
        while (idS.length() < 5) {
            idS = "0" + idS;
        }
        File ouf = new File(dir, idS + "_en.ouf");
        File png = new File(dir, idS + "_en.png");
        FileInputStream fci = new FileInputStream("sample.png");
        FileOutputStream fco = new FileOutputStream(png);
        byte[] buffer = new byte[4096];
        while ((b = ((InputStream)fci).read(buffer)) != -1) {
            ((OutputStream)fco).write(buffer, 0, b);
        }
        ((OutputStream)fco).close();
        ((InputStream)fci).close();
        DataOutputStream out = new DataOutputStream(new FileOutputStream(ouf));
        this.generateOufFile(out);
        out.close();
        PrintWriter txt = new PrintWriter(new FileWriter(new File(dir, idS + "_en.txt")));
        txt.println("Name: " + this.name.trim());
        txt.println("Publisher: " + this.publisher.trim());
        txt.println("Author: " + this.author.trim());
        txt.println("Book Version: " + this.version);
        txt.println("URL: " + this.url);
        txt.println("ThumbMD5: " + this.md5(png));
        txt.println("FileMD5: " + this.md5(ouf));
        txt.println("Book Area Code: en");
        txt.close();
    }

    private static int getCodeFromPositionInFile(int position, int n) {
        if ((position & 0xFF) != 0 | n < 0) {
            return -1;
        }
        int b = (position >> 8) + n * 26;
        for (int k = 0; k < E.length; ++k) {
            int v = b - E[k] << 8;
            if (Book.getPositionInFileFromCode(v, n) != position) continue;
            return v;
        }
        return -1;
    }

    private static int getPositionInFileFromCode(int code, int n) {
        if ((code & 0xFF) != 0 | n < 0) {
            return -1;
        }
        int c = (code >>= 8) >> 3 & 1 | (code >> 4 & 1) << 1 | (code >> 5 & 1) << 2 | (code >> 7 & 1) << 3 | (code >> 9 & 1) << 4;
        return (code -= n * 26 - E[c]) << 8;
    }
}

